/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.role.IRoleFollower;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.shared.client.util.NoppesStringUtils;

public class RoleFollower
extends RoleInterface
implements IRoleFollower {
    private String ownerUUID;
    public boolean isFollowing = true;
    public HashMap<Integer, Integer> rates;
    public NpcMiscInventory inventory = new NpcMiscInventory(3);
    public String dialogHire = "";
    public String dialogFarewell = "";
    public int daysHired;
    public long hiredTime;
    public boolean disableGui = false;
    public boolean infiniteDays = false;
    public boolean refuseSoulStone = false;
    public class_1657 owner = null;

    public RoleFollower(EntityNPCInterface npc) {
        super(npc);
        this.rates = new HashMap();
    }

    @Override
    public class_2487 save(class_2487 nbttagcompound) {
        nbttagcompound.method_10569("MercenaryDaysHired", this.daysHired);
        nbttagcompound.method_10544("MercenaryHiredTime", this.hiredTime);
        nbttagcompound.method_10582("MercenaryDialogHired", this.dialogHire);
        nbttagcompound.method_10582("MercenaryDialogFarewell", this.dialogFarewell);
        if (this.hasOwner()) {
            nbttagcompound.method_10582("MercenaryOwner", this.ownerUUID);
        }
        nbttagcompound.method_10566("MercenaryDayRates", (class_2520)NBTTags.nbtIntegerIntegerMap(this.rates));
        nbttagcompound.method_10566("MercenaryInv", (class_2520)this.inventory.getToNBT());
        nbttagcompound.method_10556("MercenaryIsFollowing", this.isFollowing);
        nbttagcompound.method_10556("MercenaryDisableGui", this.disableGui);
        nbttagcompound.method_10556("MercenaryInfiniteDays", this.infiniteDays);
        nbttagcompound.method_10556("MercenaryRefuseSoulstone", this.refuseSoulStone);
        return nbttagcompound;
    }

    @Override
    public void load(class_2487 nbttagcompound) {
        this.ownerUUID = nbttagcompound.method_10558("MercenaryOwner");
        this.daysHired = nbttagcompound.method_10550("MercenaryDaysHired");
        this.hiredTime = nbttagcompound.method_10537("MercenaryHiredTime");
        this.dialogHire = nbttagcompound.method_10558("MercenaryDialogHired");
        this.dialogFarewell = nbttagcompound.method_10558("MercenaryDialogFarewell");
        this.rates = NBTTags.getIntegerIntegerMap(nbttagcompound.method_10554("MercenaryDayRates", 10));
        this.inventory.setFromNBT(nbttagcompound.method_10562("MercenaryInv"));
        this.isFollowing = nbttagcompound.method_10577("MercenaryIsFollowing");
        this.disableGui = nbttagcompound.method_10577("MercenaryDisableGui");
        this.infiniteDays = nbttagcompound.method_10577("MercenaryInfiniteDays");
        this.refuseSoulStone = nbttagcompound.method_10577("MercenaryRefuseSoulstone");
    }

    @Override
    public boolean aiShouldExecute() {
        this.owner = this.getOwner();
        if (!this.infiniteDays && this.owner != null && this.getDays() <= 0) {
            RoleEvent.FollowerFinishedEvent event = new RoleEvent.FollowerFinishedEvent(this.owner, this.npc.wrappedNPC);
            EventHooks.onNPCRole(this.npc, event);
            this.npc.say(this.owner, new Line(NoppesStringUtils.formatText(this.dialogFarewell, new Object[]{this.owner, this.npc})));
            this.killed();
        }
        return false;
    }

    public class_1657 getOwner() {
        if (this.npc.method_37908().field_9236) {
            return null;
        }
        if (this.ownerUUID == null || this.ownerUUID.isEmpty()) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(this.ownerUUID);
            if (uuid != null) {
                return this.npc.method_37908().method_18470(uuid);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ((class_3218)this.npc.method_37908()).method_18456().stream().filter(t -> t.method_5477().getString().equals(this.ownerUUID)).findFirst().orElse(null);
    }

    public boolean hasOwner() {
        if (!this.infiniteDays && this.daysHired <= 0) {
            return false;
        }
        return this.ownerUUID != null && !this.ownerUUID.isEmpty();
    }

    @Override
    public void killed() {
        this.ownerUUID = null;
        this.daysHired = 0;
        this.hiredTime = 0L;
        this.isFollowing = true;
    }

    @Override
    public void reset() {
        this.killed();
    }

    @Override
    public void interact(class_1657 player) {
        if (this.ownerUUID == null || this.ownerUUID.isEmpty()) {
            this.npc.say(player, this.npc.advanced.getInteractLine());
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerFollowerHire, this.npc);
        } else if (player == this.owner && !this.disableGui) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerFollower, this.npc);
        }
    }

    @Override
    public boolean defendOwner() {
        return this.isFollowing() && this.npc.job.getType() == 3;
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean isFollowing() {
        return this.owner != null && this.isFollowing && this.getDays() > 0;
    }

    public void setOwner(class_1657 player) {
        UUID id = player.method_5667();
        if (this.ownerUUID == null || id == null || !this.ownerUUID.equals(id.toString())) {
            this.killed();
        }
        this.ownerUUID = id.toString();
    }

    @Override
    public int getDays() {
        if (this.infiniteDays) {
            return 100;
        }
        if (this.daysHired <= 0) {
            return 0;
        }
        int days = (int)((this.npc.method_37908().method_8510() - this.hiredTime) / 24000L);
        return this.daysHired - days;
    }

    @Override
    public void addDays(int days) {
        this.daysHired = days + this.getDays();
        this.hiredTime = this.npc.method_37908().method_8510();
    }

    @Override
    public boolean getInfinite() {
        return this.infiniteDays;
    }

    @Override
    public void setInfinite(boolean infinite) {
        this.infiniteDays = infinite;
    }

    @Override
    public boolean getGuiDisabled() {
        return this.disableGui;
    }

    @Override
    public void setGuiDisabled(boolean disabled) {
        this.disableGui = disabled;
    }

    @Override
    public boolean getRefuseSoulstone() {
        return this.refuseSoulStone;
    }

    @Override
    public void setRefuseSoulstone(boolean refuse) {
        this.refuseSoulStone = refuse;
    }

    @Override
    public IPlayer getFollowing() {
        class_1657 owner = this.getOwner();
        if (owner != null) {
            return (IPlayer)NpcAPI.Instance().getIEntity((class_1297)owner);
        }
        return null;
    }

    @Override
    public void setFollowing(IPlayer player) {
        if (player == null) {
            this.setOwner(null);
        } else {
            this.setOwner((class_1657)player.getMCEntity());
        }
    }

    @Override
    public int getType() {
        return 2;
    }
}

