/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_7923;
import noppes.npcs.CustomNpcs;
import noppes.npcs.schematics.ISchematic;

public class Schematic
implements ISchematic {
    private static final HashMap<String, class_2680> staticBlockIds = new HashMap();
    public String name;
    public short width;
    public short height;
    public short length;
    private class_2499 entityList;
    public class_2499 tileList;
    public short[] blockArray;
    public byte[] blockDataArray;
    public HashMap<String, class_2680> blockIds = staticBlockIds;

    private static <T extends Comparable<T>> class_2680 setValue(class_2680 state, class_2769<T> prop, String val) {
        Optional optional = prop.method_11900(val);
        if (optional.isPresent()) {
            return (class_2680)state.method_11657(prop, (Comparable)optional.get());
        }
        return state;
    }

    public Schematic(String name) {
        this.name = name;
    }

    public void load(class_2487 compound) {
        this.width = compound.method_10568("Width");
        this.height = compound.method_10568("Height");
        this.length = compound.method_10568("Length");
        byte[] addId = compound.method_10545("AddBlocks") ? compound.method_10547("AddBlocks") : new byte[]{};
        this.setBlockBytes(compound.method_10547("Blocks"), addId);
        this.blockDataArray = compound.method_10547("Data");
        this.entityList = compound.method_10554("Entities", 10);
        this.tileList = compound.method_10554("TileEntities", 10);
        if (compound.method_10573("BlockIDs", 10)) {
            class_2487 comp = compound.method_10562("BlockIDs");
            this.blockIds = new HashMap();
            for (String idStr : comp.method_10541()) {
                String key = comp.method_10558(idStr);
                try {
                    int id = Integer.parseInt(idStr);
                    class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(key));
                    if (block == null) continue;
                    this.blockIds.put(id + ":0", block.method_9564());
                }
                catch (NumberFormatException e) {}
            }
        }
    }

    @Override
    public class_2487 getNBT() {
        class_2487 compound = new class_2487();
        compound.method_10575("Width", this.width);
        compound.method_10575("Height", this.height);
        compound.method_10575("Length", this.length);
        byte[][] arr = this.getBlockBytes();
        compound.method_10570("Blocks", arr[0]);
        if (arr.length > 1) {
            compound.method_10570("AddBlocks", arr[1]);
        }
        compound.method_10570("Data", this.blockDataArray);
        compound.method_10566("TileEntities", (class_2520)this.tileList);
        class_2487 comp = new class_2487();
        for (Map.Entry<String, class_2680> entry : this.blockIds.entrySet()) {
            comp.method_10582("" + class_2248.method_9507((class_2680)entry.getValue()), class_7923.field_41175.method_10221((Object)entry.getValue().method_26204()).toString());
        }
        compound.method_10566("BlockIDs", (class_2520)comp);
        return compound;
    }

    public void setBlockBytes(byte[] blockId, byte[] addId) {
        this.blockArray = new short[blockId.length];
        for (int index = 0; index < blockId.length; ++index) {
            short id = (short)(blockId[index] & 0xFF);
            if (index >> 1 < addId.length) {
                id = (index & 1) == 0 ? (short)(id + (short)((addId[index >> 1] & 0xF) << 8)) : (short)(id + (short)((addId[index >> 1] & 0xF0) << 4));
            }
            this.blockArray[index] = id;
        }
    }

    public byte[][] getBlockBytes() {
        byte[] blocks = new byte[this.blockArray.length];
        byte[] addBlocks = null;
        for (int i = 0; i < blocks.length; ++i) {
            short id = this.blockArray[i];
            if (id > 255) {
                if (addBlocks == null) {
                    addBlocks = new byte[(blocks.length >> 1) + 1];
                }
                addBlocks[i >> 1] = (i & 1) == 0 ? (byte)(addBlocks[i >> 1] & 0xF0 | id >> 8 & 0xF) : (byte)(addBlocks[i >> 1] & 0xF | (id >> 8 & 0xF) << 4);
            }
            blocks[i] = (byte)id;
        }
        if (addBlocks == null) {
            return new byte[][]{blocks};
        }
        return new byte[][]{blocks, addBlocks};
    }

    public int xyzToIndex(int x, int y, int z) {
        return (y * this.length + z) * this.width + x;
    }

    @Override
    public class_2680 getBlockState(int x, int y, int z) {
        return this.getBlockState(this.xyzToIndex(x, y, z));
    }

    @Override
    public class_2680 getBlockState(int i) {
        class_2680 b = this.blockIds.get(this.blockArray[i] + ":" + this.blockDataArray[i]);
        if (b == null) {
            return class_2246.field_10124.method_9564();
        }
        return b;
    }

    @Override
    public short getWidth() {
        return this.width;
    }

    @Override
    public short getHeight() {
        return this.height;
    }

    @Override
    public short getLength() {
        return this.length;
    }

    @Override
    public int getBlockEntityDimensions() {
        if (this.tileList == null) {
            return 0;
        }
        return this.tileList.size();
    }

    @Override
    public class_2487 getBlockEntity(int i) {
        return this.tileList.method_10602(i);
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        class_2960 resource = new class_2960("customnpcs", "legacy_blockids.json");
        class_3298 ir = CustomNpcs.Server.method_34864().method_14486(resource).orElse(null);
        if (ir != null) {
            try {
                InputStream stream = ir.method_14482();
                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                JsonObject result = ((JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class)).getAsJsonObject("blocks");
                for (Map.Entry entry : result.entrySet()) {
                    class_2248 block;
                    String val = ((JsonElement)entry.getValue()).getAsString();
                    String[] properties = null;
                    if (val.indexOf(91) > 0) {
                        properties = val.substring(val.indexOf(91) + 1, val.length() - 1).split(",");
                        val = val.substring(0, val.indexOf(91));
                    }
                    if ((block = (class_2248)class_7923.field_41175.method_10223(new class_2960(val))) == null) continue;
                    class_2680 state = block.method_9564();
                    if (properties != null) {
                        for (class_2769 prop : state.method_28501()) {
                            for (String r : properties) {
                                if (!r.startsWith(prop.method_11899() + "=")) continue;
                                state = Schematic.setValue(state, prop, r.split("=")[1]);
                            }
                        }
                    }
                    staticBlockIds.put((String)entry.getKey(), state);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

