/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import noppes.npcs.schematics.ISchematic;
import noppes.npcs.schematics.Schematic;

public class SchematicWrapper {
    public static final int buildSize = 10000;
    private class_2338 offset = class_2338.field_10980;
    private class_2338 start = class_2338.field_10980;
    public ISchematic schema;
    public int buildPos;
    public int size;
    public int rotation = 0;
    private class_1937 level;
    public boolean isBuilding = false;
    public boolean firstLayer = true;
    private Map<class_1923, class_2487>[] tileEntities;

    public SchematicWrapper(ISchematic schematic) {
        this.schema = schematic;
        this.size = schematic.getWidth() * schematic.getHeight() * schematic.getLength();
        this.tileEntities = new Map[schematic.getHeight()];
        for (int i = 0; i < schematic.getBlockEntityDimensions(); ++i) {
            class_2487 teTag = schematic.getBlockEntity(i);
            int x = teTag.method_10550("x");
            int y = teTag.method_10550("y");
            int z = teTag.method_10550("z");
            Map<class_1923, class_2487> map = this.tileEntities[y];
            if (map == null) {
                this.tileEntities[y] = map = new HashMap<class_1923, class_2487>();
            }
            map.put(new class_1923(x, z), teTag);
        }
    }

    public void load(Schematic s) {
    }

    public void init(class_2338 pos, class_1937 level, int rotation) {
        this.start = pos;
        this.level = level;
        this.rotation = rotation;
    }

    public void offset(int x, int y, int z) {
        this.offset = new class_2338(x, y, z);
    }

    public void build() {
        if (this.level == null || !this.isBuilding) {
            return;
        }
        long endPos = this.buildPos + 10000;
        if (endPos > (long)this.size) {
            endPos = this.size;
        }
        while ((long)this.buildPos < endPos) {
            int x = this.buildPos % this.schema.getWidth();
            int z = (this.buildPos - x) / this.schema.getWidth() % this.schema.getLength();
            int y = ((this.buildPos - x) / this.schema.getWidth() - z) / this.schema.getLength();
            if (this.firstLayer) {
                this.place(x, y, z, 1);
            } else {
                this.place(x, y, z, 2);
            }
            ++this.buildPos;
        }
        if (this.buildPos >= this.size) {
            if (this.firstLayer) {
                this.firstLayer = false;
                this.buildPos = 0;
            } else {
                this.isBuilding = false;
            }
        }
    }

    public void place(int x, int y, int z, int flag) {
        class_2487 comp;
        class_2586 tile;
        class_2680 state = this.schema.getBlockState(x, y, z);
        if (state == null || flag == 1 && !state.method_26234((class_1922)class_2682.field_12294, class_2338.field_10980) && state.method_26204() != class_2246.field_10124 || flag == 2 && (state.method_26234((class_1922)class_2682.field_12294, class_2338.field_10980) || state.method_26204() == class_2246.field_10124)) {
            return;
        }
        int rotation = this.rotation / 90;
        class_2338 pos = this.start.method_10081((class_2382)this.rotatePos(x, y, z, rotation));
        state = this.rotationState(state, rotation);
        this.level.method_8652(pos, state, 2);
        if (state.method_26204() instanceof class_2343 && (tile = this.level.method_8321(pos)) != null && (comp = this.getBlockEntity(x, y, z, pos)) != null) {
            tile.method_11014(comp);
        }
    }

    public class_2680 rotationState(class_2680 state, int rotation) {
        if (rotation == 0) {
            return state;
        }
        for (class_2769 prop : state.method_28501()) {
            class_2350 direction;
            if (!(prop instanceof class_2753) || (direction = (class_2350)state.method_11654(prop)) == class_2350.field_11036 || direction == class_2350.field_11033) continue;
            for (int i = 0; i < rotation; ++i) {
                direction = direction.method_10170();
            }
            return (class_2680)state.method_11657(prop, (Comparable)direction);
        }
        return state;
    }

    public class_2487 getBlockEntity(int x, int y, int z, class_2338 pos) {
        if (y >= this.tileEntities.length || this.tileEntities[y] == null) {
            return null;
        }
        class_2487 compound = this.tileEntities[y].get(new class_1923(x, z));
        if (compound == null) {
            return null;
        }
        compound = compound.method_10553();
        compound.method_10569("x", pos.method_10263());
        compound.method_10569("y", pos.method_10264());
        compound.method_10569("z", pos.method_10260());
        return compound;
    }

    public class_2487 getNBTSmall() {
        class_2487 compound = new class_2487();
        compound.method_10575("Width", this.schema.getWidth());
        compound.method_10575("Height", this.schema.getHeight());
        compound.method_10575("Length", this.schema.getLength());
        compound.method_10582("SchematicName", this.schema.getName());
        class_2499 list = new class_2499();
        for (int i = 0; i < this.size && i < 25000; ++i) {
            class_2680 state = this.schema.getBlockState(i);
            if (state.method_26204() == class_2246.field_10124 || state.method_26204() == class_2246.field_10369) {
                list.add((Object)new class_2487());
                continue;
            }
            list.add((Object)class_2512.method_10686((class_2680)this.schema.getBlockState(i)));
        }
        compound.method_10566("Data", (class_2520)list);
        return compound;
    }

    public class_2338 rotatePos(int x, int y, int z, int rotation) {
        if (rotation == 1) {
            return new class_2338(this.schema.getLength() - z - 1, y, x);
        }
        if (rotation == 2) {
            return new class_2338(this.schema.getWidth() - x - 1, y, this.schema.getLength() - z - 1);
        }
        if (rotation == 3) {
            return new class_2338(z, y, this.schema.getWidth() - x - 1);
        }
        return new class_2338(x, y, z);
    }

    public int getPercentage() {
        double l = this.buildPos + (this.firstLayer ? 0 : this.size);
        return (int)(l / (double)this.size * 50.0);
    }
}

