/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundMessage;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class SoundTracker {
    private static final ConcurrentHashMap<String, ConcurrentHashMap<GridKey3D, ConcurrentHashMap<UUID, SoundRecord>>> SPATIAL_SOUNDS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, SoundRecord> LARGE_RANGE_SOUNDS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Long> RECENT_DUPLICATE_SUPPRESSION = new ConcurrentHashMap();
    private static final long DEDUPLICATE_WINDOW_TICKS = 2L;
    private static final int PREFILTER_LIMIT = 24;
    private static final double WEIGHT_EPSILON = 1.0E-4;
    private static long ticksSinceCleanup = 0L;
    private static ExecutorService soundScoringExecutor;
    private static final ConcurrentLinkedQueue<AsyncSoundResult> ASYNC_RESULTS;
    private static final Map<UUID, CachedEval> EVAL_CACHE;
    private static final Map<UUID, Long> SUBMIT_COOLDOWNS;
    private static final Map<RaycastCacheKey, RaycastCacheEntry> RAYCAST_CACHE;
    private static long currentTickCounter;
    private static final double NO_MUFFLING_RANGE = 1.0;
    private static final double NO_MUFFLING_WEIGHT = 1.0;

    private static GridKey3D gridKey(BlockPos pos) {
        int x = pos.getX() >> 4;
        int y = pos.getY() >> 4;
        int z = pos.getZ() >> 4;
        return new GridKey3D(x, y, z);
    }

    private static void addRecordToSpatialCollections(SoundRecord r) {
        double threshold = (Double)SoundAttractConfig.COMMON.largeSoundRangeThreshold.get();
        if (r.range > threshold) {
            LARGE_RANGE_SOUNDS.put(r.id, r);
        } else {
            SPATIAL_SOUNDS.computeIfAbsent(r.dimensionKey, d -> new ConcurrentHashMap()).computeIfAbsent(SoundTracker.gridKey(r.pos), k -> new ConcurrentHashMap()).put(r.id, r);
        }
    }

    private static void removeRecordFromSpatialCollections(SoundRecord r) {
        double threshold = (Double)SoundAttractConfig.COMMON.largeSoundRangeThreshold.get();
        if (r.range > threshold) {
            LARGE_RANGE_SOUNDS.remove(r.id);
        } else {
            ConcurrentHashMap<GridKey3D, ConcurrentHashMap<UUID, SoundRecord>> dimMap = SPATIAL_SOUNDS.get(r.dimensionKey);
            if (dimMap != null) {
                GridKey3D key = SoundTracker.gridKey(r.pos);
                ConcurrentHashMap<UUID, SoundRecord> cellMap = dimMap.get(key);
                if (cellMap != null) {
                    cellMap.remove(r.id);
                    if (cellMap.isEmpty()) {
                        dimMap.remove(key);
                    }
                }
                if (dimMap.isEmpty()) {
                    SPATIAL_SOUNDS.remove(r.dimensionKey);
                }
            }
        }
    }

    public static void addSound(SoundEvent se, BlockPos pos, String dimensionKey, double range, double weight, int lifetime, String explicitSoundId) {
        ResourceLocation loc;
        String soundIdToUse;
        String string = explicitSoundId != null ? explicitSoundId : (soundIdToUse = se != null && se.getLocation() != null ? se.getLocation().toString() : "unknown");
        if (soundIdToUse == null) {
            soundIdToUse = "unknown";
        }
        if ((loc = ResourceLocation.tryParse((String)soundIdToUse)) != null && !SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() && !SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(loc)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.debug("Sound {} not in whitelist, ignoring.", (Object)soundIdToUse);
            }
            return;
        }
        String dedupKey = dimensionKey + "|" + soundIdToUse + "|" + pos.asLong();
        long nowTick = currentTickCounter;
        Long lastTick = RECENT_DUPLICATE_SUPPRESSION.get(dedupKey);
        if (lastTick != null && nowTick - lastTick <= 2L) {
            return;
        }
        RECENT_DUPLICATE_SUPPRESSION.put(dedupKey, nowTick);
        SoundRecord record = new SoundRecord(se, soundIdToUse, pos, lifetime, dimensionKey, range, weight);
        SoundTracker.addRecordToSpatialCollections(record);
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[addSound] Stored {} (Range={}, Weight={})", new Object[]{soundIdToUse, range, weight});
        }
    }

    public static void addVirtualSound(BlockPos pos, String dimensionKey, double range, double weight, int lifetime, UUID sourcePlayer, String animationClass) {
        VirtualSoundRecord record = new VirtualSoundRecord(pos, lifetime, dimensionKey, range, weight, sourcePlayer, animationClass);
        SoundTracker.addRecordToSpatialCollections(record);
    }

    public static void addSound(SoundEvent se, BlockPos pos, String dimensionKey, double range, double weight, int lifetime) {
        SoundTracker.addSound(se, pos, dimensionKey, range, weight, lifetime, null);
    }

    public static void addSound(SoundEvent se, BlockPos pos, String dimensionKey) {
        SoundTracker.addSound(se, pos, dimensionKey, 16.0, 1.0, (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get());
    }

    public static void initialize() {
        int workerThreads = (Integer)SoundAttractConfig.COMMON.workerThreads.get();
        if (workerThreads > 0) {
            soundScoringExecutor = Executors.newFixedThreadPool(workerThreads);
            SoundAttractMod.LOGGER.info("Initialized SoundTracker with {} worker threads.", (Object)workerThreads);
        }
    }

    public static void shutdown() {
        if (soundScoringExecutor != null) {
            soundScoringExecutor.shutdown();
            soundScoringExecutor = null;
            SoundAttractMod.LOGGER.info("Shut down SoundTracker worker threads.");
        }
    }

    public static SoundRecord getCachedOrRequestNearest(Mob mob, Level level, BlockPos pos, Vec3 eyePos) {
        if (soundScoringExecutor == null || soundScoringExecutor.isShutdown()) {
            return SoundTracker.findNearestSound(mob, level, pos, eyePos);
        }
        UUID id = mob.getUUID();
        int ttl = (Integer)SoundAttractConfig.COMMON.asyncResultTtlTicks.get();
        CachedEval cached = EVAL_CACHE.get(id);
        if (cached != null && currentTickCounter - cached.tick < (long)ttl) {
            return cached.record;
        }
        long now = currentTickCounter;
        long cooldownUntil = SUBMIT_COOLDOWNS.getOrDefault(id, 0L);
        if (now < cooldownUntil) {
            return cached != null ? cached.record : null;
        }
        MobProfile profile = SoundAttractConfig.getMatchingProfile(mob);
        soundScoringExecutor.submit(new SoundScoringTask(id, level, pos.immutable(), eyePos, profile));
        int cooldownTicks = (Integer)SoundAttractConfig.COMMON.soundScoringSubmitCooldownTicks.get();
        SUBMIT_COOLDOWNS.put(id, now + (long)cooldownTicks);
        return cached != null ? cached.record : null;
    }

    public static void tick() {
        AsyncSoundResult result;
        ++currentTickCounter;
        SPATIAL_SOUNDS.forEach((dim, grid) -> {
            grid.forEach((key, cell) -> {
                cell.forEach((id, record) -> {
                    --record.ticksRemaining;
                    if (record.ticksRemaining <= 0) {
                        cell.remove(id);
                    }
                });
                if (cell.isEmpty()) {
                    grid.remove(key);
                }
            });
            if (grid.isEmpty()) {
                SPATIAL_SOUNDS.remove(dim);
            }
        });
        LARGE_RANGE_SOUNDS.forEach((id, record) -> {
            --record.ticksRemaining;
            if (record.ticksRemaining <= 0) {
                LARGE_RANGE_SOUNDS.remove(id);
            }
        });
        ++ticksSinceCleanup;
        if (((Boolean)SoundAttractConfig.COMMON.enableRaycastCache.get()).booleanValue()) {
            int interval = (Integer)SoundAttractConfig.COMMON.raycastCacheCleanupIntervalTicks.get();
            if (interval > 0 && ticksSinceCleanup % (long)interval == 0L) {
                SoundTracker.cleanupRaycastCache();
            }
        } else {
            RAYCAST_CACHE.clear();
        }
        RECENT_DUPLICATE_SUPPRESSION.entrySet().removeIf(entry -> currentTickCounter - (Long)entry.getValue() > 2L);
        while ((result = ASYNC_RESULTS.poll()) != null) {
            EVAL_CACHE.put(result.mobId(), new CachedEval(result.result(), result.completionTick()));
        }
        if (currentTickCounter % 200L == 0L) {
            long now = currentTickCounter;
            SUBMIT_COOLDOWNS.entrySet().removeIf(entry -> now > (Long)entry.getValue() + 400L);
            EVAL_CACHE.entrySet().removeIf(entry -> now > ((CachedEval)entry.getValue()).tick + (long)((Integer)SoundAttractConfig.COMMON.asyncResultTtlTicks.get()).intValue() * 2L);
        }
    }

    private static SoundRecord findNearestSoundInternal(Level level, BlockPos mobPos, Vec3 mobEyePos, MobProfile mobProfile) {
        String dimensionKey = level.dimension().location().toString();
        List<SoundRecord> nearbyCandidates = SoundTracker.getNearbySounds(dimensionKey, mobPos);
        if (nearbyCandidates.isEmpty()) {
            return null;
        }
        HashMap<String, ApproxCandidate> approxBySound = new HashMap<String, ApproxCandidate>();
        double noveltyBonusValue = (Double)SoundAttractConfig.COMMON.soundNoveltyBonusWeight.get();
        int noveltyTicks = (Integer)SoundAttractConfig.COMMON.soundNoveltyTimeTicks.get();
        int maxLifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
        for (SoundRecord r : nearbyCandidates) {
            ApproxCandidate existing;
            double novelty;
            double approxWeight;
            double distSqr;
            Optional<MobProfile.SoundOverride> ov;
            String soundKey;
            ResourceLocation rl;
            if (r == null || r.pos == null || (rl = ResourceLocation.tryParse((String)(soundKey = r.soundId != null ? r.soundId : "unknown"))) != null && !SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() && !SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(rl)) continue;
            double effRange = r.range;
            double effWeight = r.weight;
            if (mobProfile != null && rl != null && (ov = mobProfile.getSoundOverride(rl)).isPresent()) {
                MobProfile.SoundOverride so = ov.get();
                effRange = so.range();
                effWeight = so.weight();
            }
            if ((distSqr = mobPos.distSqr((Vec3i)r.pos)) > effRange * effRange || (approxWeight = effWeight + (novelty = r.ticksRemaining > maxLifetime - noveltyTicks ? noveltyBonusValue : 0.0)) <= 0.0 || (existing = (ApproxCandidate)approxBySound.get(soundKey)) != null && !(approxWeight > existing.approxWeight) && (!(Math.abs(approxWeight - existing.approxWeight) < 0.001) || !(distSqr < existing.distSqr))) continue;
            approxBySound.put(soundKey, new ApproxCandidate(r, effRange, effWeight, novelty, approxWeight, distSqr, soundKey, rl));
        }
        if (approxBySound.isEmpty()) {
            return null;
        }
        ArrayList<Object> shortlist = new ArrayList(approxBySound.values());
        shortlist.sort((a, b) -> {
            int cmp = Double.compare(b.approxWeight, a.approxWeight);
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(a.distSqr, b.distSqr);
        });
        if (shortlist.size() > 24) {
            shortlist = new ArrayList(shortlist.subList(0, 24));
        }
        ApproxCandidate bestCandidate = null;
        double bestFinalWeight = -1.0;
        double bestFinalDist = Double.MAX_VALUE;
        for (ApproxCandidate candidate : shortlist) {
            double finalWeight;
            if (bestCandidate != null && candidate.approxWeight < bestFinalWeight - 1.0E-4) continue;
            double[] muffled = SoundTracker.applyBlockMuffling(level, candidate.rec.pos, mobPos, candidate.effRange, candidate.effWeight, candidate.soundKey);
            candidate.muffledRange = muffled[0];
            candidate.muffledWeight = muffled[1];
            if (candidate.distSqr > candidate.muffledRange * candidate.muffledRange || !((finalWeight = candidate.finalWeight()) > bestFinalWeight) && (!(Math.abs(finalWeight - bestFinalWeight) < 0.001) || !(candidate.distSqr < bestFinalDist))) continue;
            bestCandidate = candidate;
            bestFinalWeight = finalWeight;
            bestFinalDist = candidate.distSqr;
        }
        if (bestCandidate != null) {
            return new SoundRecord(bestCandidate.rec.sound, bestCandidate.rec.soundId, bestCandidate.rec.pos, bestCandidate.rec.ticksRemaining, bestCandidate.rec.dimensionKey, bestCandidate.muffledRange, bestCandidate.muffledWeight);
        }
        return null;
    }

    public static SoundRecord findNearestSound(Mob mob, Level level, BlockPos mobPos, Vec3 mobEyePos) {
        return SoundTracker.findNearestSoundInternal(level, mobPos, mobEyePos, SoundAttractConfig.getMatchingProfile(mob));
    }

    private static List<SoundRecord> getNearbySounds(String dim, BlockPos pos) {
        ArrayList<SoundRecord> result = new ArrayList<SoundRecord>();
        ConcurrentHashMap<GridKey3D, ConcurrentHashMap<UUID, SoundRecord>> dimMap = SPATIAL_SOUNDS.get(dim);
        if (dimMap != null) {
            GridKey3D centerKey = SoundTracker.gridKey(pos);
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        GridKey3D neighborKey = new GridKey3D(centerKey.x() + dx, centerKey.y() + dy, centerKey.z() + dz);
                        ConcurrentHashMap<UUID, SoundRecord> cell = dimMap.get(neighborKey);
                        if (cell == null) continue;
                        result.addAll(cell.values());
                    }
                }
            }
        }
        for (SoundRecord r : LARGE_RANGE_SOUNDS.values()) {
            if (!r.dimensionKey.equals(dim)) continue;
            result.add(r);
        }
        return result;
    }

    private static void advanceTickCounter() {
        ++currentTickCounter;
    }

    private static void cleanupRaycastCache() {
        long now = currentTickCounter;
        int ttl = (Integer)SoundAttractConfig.COMMON.raycastCacheTtlTicks.get();
        int maxSize = (Integer)SoundAttractConfig.COMMON.raycastCacheMaxEntries.get();
        if (ttl <= 0) {
            ttl = 1;
        }
        if (!RAYCAST_CACHE.isEmpty()) {
            Iterator<Map.Entry<RaycastCacheKey, RaycastCacheEntry>> it = RAYCAST_CACHE.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<RaycastCacheKey, RaycastCacheEntry> e2 = it.next();
                if (now - e2.getValue().lastAccessTick <= (long)ttl) continue;
                it.remove();
            }
        }
        if (RAYCAST_CACHE.size() > maxSize) {
            int toRemove = RAYCAST_CACHE.size() - maxSize;
            ArrayList<Map.Entry<RaycastCacheKey, RaycastCacheEntry>> entries = new ArrayList<Map.Entry<RaycastCacheKey, RaycastCacheEntry>>(RAYCAST_CACHE.entrySet());
            entries.sort(Comparator.comparingLong(e -> ((RaycastCacheEntry)e.getValue()).lastAccessTick));
            for (int i = 0; i < toRemove && i < entries.size(); ++i) {
                RAYCAST_CACHE.remove(((Map.Entry)entries.get(i)).getKey());
            }
        }
    }

    public static double[] applyBlockMuffling(Level level, BlockPos src, BlockPos dst, double origRange, double origWeight, String soundId) {
        Vec3 end;
        RaycastCacheEntry cached;
        if (!((Boolean)SoundAttractConfig.COMMON.enableBlockMuffling.get()).booleanValue()) {
            return new double[]{origRange, origWeight};
        }
        String dimKey = level.dimension().location().toString();
        RaycastCacheKey cacheKey = new RaycastCacheKey(dst, src, soundId, dimKey);
        if (((Boolean)SoundAttractConfig.COMMON.enableRaycastCache.get()).booleanValue() && (cached = RAYCAST_CACHE.get(cacheKey)) != null) {
            cached.lastAccessTick = currentTickCounter;
            return cached.result;
        }
        double currentRange = origRange;
        double currentWeight = origWeight;
        int blocksHit = 0;
        Vec3 start = Vec3.atCenterOf((Vec3i)src);
        BlockHitResult result = level.clip(new ClipContext(start, end = Vec3.atCenterOf((Vec3i)dst), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
        if (result.getType() == HitResult.Type.BLOCK) {
            BlockPos currentPos = result.getBlockPos();
            Vec3 currentHitVec = result.getLocation();
            int maxChecks = (Integer)SoundAttractConfig.COMMON.maxMufflingBlocksToCheck.get();
            for (int i = 0; i < maxChecks && currentRange > 0.1 && currentWeight > 0.01; ++i) {
                BlockState blockState = level.getBlockState(currentPos);
                Block block = blockState.getBlock();
                double rangeMultiplier = 1.0;
                double weightMultiplier = 1.0;
                if (SoundTracker.isCustomWool(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorWool.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorWool.get();
                } else if (SoundTracker.isCustomLiquid(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorLiquid.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorLiquid.get();
                } else if (SoundTracker.isCustomThin(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorThin.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorThin.get();
                } else if (SoundTracker.isCustomSolid(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorSolid.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorSolid.get();
                } else if (SoundTracker.isCustomNonSolid(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorNonSolid.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorNonSolid.get();
                }
                currentRange *= rangeMultiplier;
                currentWeight *= weightMultiplier;
                ++blocksHit;
                Vec3 direction = end.subtract(start).normalize();
                currentHitVec = currentHitVec.add(direction.scale(0.1));
                BlockHitResult nextResult = level.clip(new ClipContext(currentHitVec, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                if (nextResult.getType() != HitResult.Type.BLOCK || nextResult.getBlockPos().equals((Object)currentPos)) break;
                currentPos = nextResult.getBlockPos();
                currentHitVec = nextResult.getLocation();
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && blocksHit > 0) {
            SoundAttractMod.LOGGER.debug("Muffling for sound {} from {} to {}: {} blocks hit. Range: {} -> {}, Weight: {} -> {}", new Object[]{soundId, src, dst, blocksHit, origRange, currentRange, origWeight, currentWeight});
        }
        double[] finalResult = new double[]{Math.max(0.0, currentRange), Math.max(0.0, currentWeight)};
        if (((Boolean)SoundAttractConfig.COMMON.enableRaycastCache.get()).booleanValue()) {
            RAYCAST_CACHE.put(cacheKey, new RaycastCacheEntry(finalResult, currentTickCounter));
        }
        return finalResult;
    }

    private static boolean isBlockInConfigList(BlockState state, Block block, List<String> configList) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (id == null) {
            return false;
        }
        String blockIdStr = id.toString();
        for (String configEntry : configList) {
            TagKey tagKey;
            if (!(configEntry.endsWith("*") ? state.is(tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)configEntry.substring(0, configEntry.length() - 1)))) : blockIdStr.equals(configEntry))) continue;
            return true;
        }
        return false;
    }

    private static boolean safeBlockStateCheck(BlockState state, Level level, BlockPos pos, BiPredicate<BlockState, BlockGetter> check, boolean defaultValueOnNPE) {
        if (level == null || pos == null) {
            SoundAttractMod.LOGGER.warn("safeBlockStateCheck called with null level or pos for block {}. Defaulting.", (Object)BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()));
            return defaultValueOnNPE;
        }
        try {
            return check.test(state, (BlockGetter)level);
        }
        catch (NullPointerException npe) {
            SoundAttractMod.LOGGER.warn("A NullPointerException occurred during a block state check for block {} at {}. This might be a mod incompatibility. Defaulting.", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()), pos, npe});
            return defaultValueOnNPE;
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("An unexpected error occurred during a block state check for block {} at {}. Defaulting.", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()), pos, e});
            return defaultValueOnNPE;
        }
    }

    private static boolean isCustomWool(BlockState state, Block block, Level level, BlockPos pos) {
        if (SoundTracker.isBlockInConfigList(state, block, ((List)SoundAttractConfig.COMMON.customWoolBlocks.get()).stream().map(String::valueOf).toList())) {
            return true;
        }
        try {
            return state.is(BlockTags.WOOL);
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.warn("Exception checking BlockTags.WOOL for block {} at {}. Defaulting to false.", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)block), pos, e});
            return false;
        }
    }

    private static boolean isCustomSolid(BlockState state, Block block, Level level, BlockPos pos) {
        if (SoundTracker.isBlockInConfigList(state, block, ((List)SoundAttractConfig.COMMON.customSolidBlocks.get()).stream().map(String::valueOf).toList())) {
            return true;
        }
        try {
            return state.isSolidRender((BlockGetter)level, pos);
        }
        catch (NullPointerException npe) {
            SoundAttractMod.LOGGER.warn("NPE in state.isSolidRender() for block {} at {}. Defaulting to solid.", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)block), pos, npe});
            return true;
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("Error in state.isSolidRender() for block {} at {}. Defaulting to solid.", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)block), pos, e});
            return true;
        }
    }

    private static boolean isCustomNonSolid(BlockState state, Block block, Level level, BlockPos pos) {
        boolean isNormallySolid;
        if (SoundTracker.isBlockInConfigList(state, block, ((List)SoundAttractConfig.COMMON.customNonSolidBlocks.get()).stream().map(String::valueOf).toList())) {
            return true;
        }
        try {
            isNormallySolid = state.isSolid();
        }
        catch (NullPointerException npe) {
            SoundAttractMod.LOGGER.warn("NPE in state.isSolid() for block {} at {}. Defaulting to solid (meaning not 'non-solid').", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)block), pos, npe});
            isNormallySolid = true;
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("Error in state.isSolid() for block {} at {}. Defaulting to solid.", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)block), pos, e});
            isNormallySolid = true;
        }
        return !isNormallySolid;
    }

    private static boolean isCustomThin(BlockState state, Block block, Level level, BlockPos pos) {
        if (SoundTracker.isBlockInConfigList(state, block, ((List)SoundAttractConfig.COMMON.customThinBlocks.get()).stream().map(String::valueOf).toList())) {
            return true;
        }
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (id == null) {
            return false;
        }
        String path = id.getPath();
        return path.contains("pane") || path.contains("iron_bars") || path.contains("painting") || path.contains("fence") || path.contains("trapdoor") || path.contains("door") || path.contains("ladder") || path.contains("scaffolding") || path.contains("rail");
    }

    private static boolean isCustomLiquid(BlockState state, Block block, Level level, BlockPos pos) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return id != null && SoundAttractConfig.CUSTOM_LIQUID_BLOCKS_CACHE.contains(id);
    }

    static {
        ASYNC_RESULTS = new ConcurrentLinkedQueue();
        EVAL_CACHE = new ConcurrentHashMap<UUID, CachedEval>();
        SUBMIT_COOLDOWNS = new ConcurrentHashMap<UUID, Long>();
        RAYCAST_CACHE = new ConcurrentHashMap<RaycastCacheKey, RaycastCacheEntry>();
        currentTickCounter = 0L;
    }

    private record GridKey3D(int x, int y, int z) {
    }

    public static class SoundRecord {
        public final UUID id = UUID.randomUUID();
        public final SoundEvent sound;
        public final String soundId;
        public final BlockPos pos;
        public int ticksRemaining;
        public final String dimensionKey;
        public final double range;
        public final double weight;

        public SoundRecord(SoundEvent sound, String soundId, BlockPos pos, int lifetime, String dimensionKey, double range, double weight) {
            this.sound = sound;
            this.soundId = soundId;
            this.pos = pos;
            this.ticksRemaining = lifetime;
            this.dimensionKey = dimensionKey;
            this.range = range;
            this.weight = weight;
        }
    }

    public static class VirtualSoundRecord
    extends SoundRecord {
        public final UUID sourcePlayer;
        public final String animationClass;

        public VirtualSoundRecord(BlockPos pos, int lifetime, String dimensionKey, double range, double weight, UUID sourcePlayer, String animationClass) {
            super(null, SoundMessage.VOICE_CHAT_SOUND_ID.toString(), pos, lifetime, dimensionKey, range, weight);
            this.sourcePlayer = sourcePlayer;
            this.animationClass = animationClass;
        }
    }

    private static final class CachedEval {
        final SoundRecord record;
        final long tick;

        CachedEval(SoundRecord record, long tick) {
            this.record = record;
            this.tick = tick;
        }
    }

    private static class SoundScoringTask
    implements Runnable {
        private final UUID mobId;
        private final Level level;
        private final BlockPos pos;
        private final Vec3 eye;
        private final MobProfile profile;

        SoundScoringTask(UUID mobId, Level level, BlockPos pos, Vec3 eye, MobProfile profile) {
            this.mobId = mobId;
            this.level = level;
            this.pos = pos;
            this.eye = eye;
            this.profile = profile;
        }

        @Override
        public void run() {
            try {
                SoundRecord result = SoundTracker.findNearestSoundInternal(this.level, this.pos, this.eye, this.profile);
                ASYNC_RESULTS.add(new AsyncSoundResult(this.mobId, result, currentTickCounter));
            }
            catch (Exception e) {
                SoundAttractMod.LOGGER.error("Error during async sound scoring for mob {}", (Object)this.mobId, (Object)e);
            }
        }
    }

    private record AsyncSoundResult(UUID mobId, SoundRecord result, long completionTick) {
    }

    private static final class ApproxCandidate {
        final SoundRecord rec;
        final double effRange;
        final double effWeight;
        final double novelty;
        final double approxWeight;
        final double distSqr;
        final String soundKey;
        final ResourceLocation baseSoundId;
        double muffledRange;
        double muffledWeight;

        ApproxCandidate(SoundRecord rec, double effRange, double effWeight, double novelty, double approxWeight, double distSqr, String soundKey, ResourceLocation baseSoundId) {
            this.rec = rec;
            this.effRange = effRange;
            this.effWeight = effWeight;
            this.novelty = novelty;
            this.approxWeight = approxWeight;
            this.distSqr = distSqr;
            this.soundKey = soundKey;
            this.baseSoundId = baseSoundId;
            this.muffledRange = effRange;
            this.muffledWeight = effWeight;
        }

        double finalWeight() {
            return this.muffledWeight + this.novelty;
        }
    }

    private static final class RaycastCacheEntry {
        final double[] result;
        long lastAccessTick;

        RaycastCacheEntry(double[] result, long lastAccessTick) {
            this.result = result;
            this.lastAccessTick = lastAccessTick;
        }
    }

    private static class RaycastCacheKey {
        public final BlockPos mobPos;
        public final BlockPos soundPos;
        public final String soundId;
        public final String dimensionKey;

        public RaycastCacheKey(BlockPos mobPos, BlockPos soundPos, String soundId, String dimensionKey) {
            this.mobPos = mobPos;
            this.soundPos = soundPos;
            this.soundId = soundId;
            this.dimensionKey = dimensionKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RaycastCacheKey)) {
                return false;
            }
            RaycastCacheKey other = (RaycastCacheKey)o;
            return this.mobPos.equals((Object)other.mobPos) && this.soundPos.equals((Object)other.soundPos) && this.soundId.equals(other.soundId) && this.dimensionKey.equals(other.dimensionKey);
        }

        public int hashCode() {
            return this.mobPos.hashCode() ^ this.soundPos.hashCode() ^ this.soundId.hashCode() ^ this.dimensionKey.hashCode();
        }
    }
}

