/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.phys.Vec3;

public class CombatBlockBreakAssistGoal
extends Goal {
    private final Mob mob;
    private int stuckTicks = 0;
    private BlockPos lastPos = null;
    private static final int STUCK_THRESHOLD = 10;

    public CombatBlockBreakAssistGoal(Mob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.noneOf(Goal.Flag.class));
    }

    public boolean canUse() {
        if (this.mob == null || this.mob.level() == null || this.mob.level().isClientSide()) {
            return false;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) {
            return false;
        }
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (this.shouldPreferRangedAttack(target)) {
            return false;
        }
        BlockPos dest = target.blockPosition();
        BlockPos blocking = BlockBreakerPosGoal.findFirstBlockingBlock(this.mob.level(), this.mob, dest);
        return blocking != null;
    }

    public boolean canContinueToUse() {
        if (this.mob == null || this.mob.level() == null || this.mob.level().isClientSide()) {
            return false;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) {
            return false;
        }
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        return !this.shouldPreferRangedAttack(target);
    }

    public void tick() {
        if (this.lastPos != null && this.lastPos.equals((Object)this.mob.blockPosition())) {
            ++this.stuckTicks;
        } else {
            this.stuckTicks = 0;
            this.lastPos = this.mob.blockPosition();
        }
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isAlive()) {
            return;
        }
        if (!(this.mob.getNavigation() != null && this.mob.getNavigation().isStuck() || this.stuckTicks >= 10)) {
            return;
        }
        BlockPos dest = target.blockPosition();
        if (dest == null) {
            return;
        }
        BlockPos blocking = BlockBreakerPosGoal.findFirstBlockingBlock(this.mob.level(), this.mob, dest);
        if (blocking == null) {
            return;
        }
        boolean hasBreaker = this.mob.goalSelector.getAvailableGoals().stream().anyMatch(w -> w.getGoal() instanceof BlockBreakerPosGoal);
        if (hasBreaker) {
            return;
        }
        double mult = (Double)SoundAttractConfig.COMMON.blockBreakTimeMultiplier.get();
        boolean toolOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakToolOnly.get();
        boolean properOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolOnly.get();
        boolean properReq = (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolRequired.get();
        BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, dest, mult, toolOnly, properOnly, properReq);
        BlockBreakerManager.scheduleAdd(this.mob, breaker, 2);
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[CombatBlockBreakAssistGoal] {} scheduled BlockBreakerPosGoal toward target at {} (blocked at {}).", new Object[]{this.mob.getName().getString(), dest, blocking});
        }
    }

    private boolean shouldPreferRangedAttack(LivingEntity target) {
        try {
            double maxRange;
            Vec3 tp;
            boolean hasLOS;
            if (!(this.mob instanceof RangedAttackMob)) {
                return false;
            }
            boolean bl = hasLOS = this.mob.getSensing() != null && this.mob.getSensing().hasLineOfSight((Entity)target);
            if (!hasLOS) {
                return false;
            }
            Vec3 me = this.mob.position();
            double distSq = me.distanceToSqr(tp = target.position());
            return distSq <= (maxRange = 16.0) * maxRange;
        }
        catch (Exception e) {
            return false;
        }
    }
}

