/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.phys.Vec3;

public class FollowLeaderGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private Mob leader;
    private static final double MAX_DISTANCE = 12.0;
    private int stuckTicks = 0;
    private int stuckThreshold;
    private int dynamicTickCounter;
    private AttractionGoal leaderAttractionGoal;
    private BlockPos leaderObjectivePos;
    private BlockPos myStableDestination;
    private BlockBreakerPosGoal followerBreaker;
    private Vec3 lastPosVec;
    private Vec3 lastPosSample;
    private int navIdleTicks;

    private void moveTowardsLeader(double speed) {
        if (this.leader == null) {
            return;
        }
        BlockPos leaderBlock = this.leader.blockPosition();
        this.mob.getNavigation().moveTo((double)leaderBlock.getX() + 0.5, (double)leaderBlock.getY(), (double)leaderBlock.getZ() + 0.5, speed);
    }

    private void startMovingToDestination(double speed) {
        if (this.myStableDestination != null) {
            this.mob.getNavigation().moveTo((double)this.myStableDestination.getX() + 0.5, (double)this.myStableDestination.getY(), (double)this.myStableDestination.getZ() + 0.5, speed);
        }
    }

    private BlockPos calculateStableDestination(BlockPos leaderTarget) {
        if (leaderTarget == null) {
            return null;
        }
        double arrival = (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
        long seed = this.mob.getUUID().getMostSignificantBits() ^ leaderTarget.asLong();
        Random rand = new Random(seed);
        double angle = rand.nextDouble() * Math.PI * 2.0;
        double radius = arrival * (0.5 + rand.nextDouble() * 0.5);
        int x = leaderTarget.getX() + (int)Math.floor(Math.cos(angle) * radius);
        int z = leaderTarget.getZ() + (int)Math.floor(Math.sin(angle) * radius);
        return new BlockPos(x, leaderTarget.getY(), z);
    }

    public FollowLeaderGoal(Mob mob, double moveSpeed) {
        this.stuckThreshold = (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
        this.dynamicTickCounter = 0;
        this.leaderAttractionGoal = null;
        this.followerBreaker = null;
        this.lastPosVec = null;
        this.lastPosSample = null;
        this.navIdleTicks = 0;
        this.mob = mob;
        this.moveSpeed = moveSpeed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    private double getGroupDistance() {
        return (Double)SoundAttractConfig.COMMON.groupDistance.get();
    }

    public boolean canUse() {
        this.leader = MobGroupManager.getLeader(this.mob);
        if (this.leader == null || this.leader == this.mob) {
            return false;
        }
        if (this.mob.distanceToSqr((Entity)this.leader) < this.getGroupDistance() * this.getGroupDistance()) {
            return false;
        }
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        if (smartEdge && MobGroupManager.isEdgeMob(this.mob)) {
            return false;
        }
        if (!this.leader.isAlive()) {
            return false;
        }
        this.leaderAttractionGoal = this.leader.goalSelector.getAvailableGoals().stream().map(WrappedGoal::getGoal).filter(goal -> goal instanceof AttractionGoal).map(goal -> (AttractionGoal)((Object)goal)).filter(AttractionGoal::isPursuingSound).findFirst().orElse(null);
        if (this.leaderAttractionGoal == null && !RaidManager.isRaidAdvancing(this.leader)) {
            return false;
        }
        this.leaderObjectivePos = this.leaderAttractionGoal != null ? this.leaderAttractionGoal.getTargetSoundPos() : RaidManager.getRaidTarget(this.leader);
        this.myStableDestination = this.calculateStableDestination(this.leaderObjectivePos != null ? this.leaderObjectivePos : this.leader.blockPosition());
        this.startMovingToDestination(this.moveSpeed);
        return true;
    }

    public boolean canContinueToUse() {
        if (this.leader == null || !this.leader.isAlive()) {
            return false;
        }
        if (RaidManager.isRaidAdvancing(this.leader) || RaidManager.isRaidTicking(this.leader)) {
            return true;
        }
        return this.leaderAttractionGoal != null && this.leaderAttractionGoal.isPursuingSound();
    }

    public void tick() {
        BlockPos currentLeaderTarget;
        BlockPos raidTarget;
        if (this.leader == null || !this.leader.isAlive()) {
            return;
        }
        int scanCooldown = (Integer)SoundAttractConfig.COMMON.scanCooldownTicks.get();
        int updateInterval = Math.max(1, scanCooldown / 2);
        this.dynamicTickCounter = (this.dynamicTickCounter + 1) % updateInterval;
        if (this.dynamicTickCounter != 0) {
            return;
        }
        double sprintMult = (Double)SoundAttractConfig.COMMON.groupSprintMultiplier.get();
        boolean raidAdvancing = RaidManager.isRaidAdvancing(this.leader);
        double speed = raidAdvancing ? this.moveSpeed * sprintMult : this.moveSpeed;
        Vec3 leaderPos = this.leader.position();
        Vec3 curPos = this.mob.position();
        if (RaidManager.isRaidAdvancing(this.leader) && (raidTarget = RaidManager.getRaidTarget(this.leader)) != null) {
            this.leaderObjectivePos = raidTarget;
            this.myStableDestination = this.calculateStableDestination(this.leaderObjectivePos);
            this.startMovingToDestination(speed);
            return;
        }
        if (this.leaderAttractionGoal != null && this.leaderAttractionGoal.isPursuingSound() && (currentLeaderTarget = this.leaderAttractionGoal.getTargetSoundPos()) != null && !currentLeaderTarget.equals((Object)this.leaderObjectivePos) && (this.leaderObjectivePos == null || this.leaderObjectivePos.distSqr((Vec3i)currentLeaderTarget) > 100.0)) {
            this.leaderObjectivePos = currentLeaderTarget;
            this.myStableDestination = this.calculateStableDestination(this.leaderObjectivePos);
            this.startMovingToDestination(this.moveSpeed);
        }
        if (this.myStableDestination != null) {
            double distSq = curPos.distanceToSqr(Vec3.atCenterOf((Vec3i)this.myStableDestination));
            if (this.mob.getNavigation().isDone() || distSq > 4.0) {
                this.mob.getNavigation().moveTo((double)this.myStableDestination.getX() + 0.5, (double)this.myStableDestination.getY(), (double)this.myStableDestination.getZ() + 0.5, speed);
                this.startMovingToDestination(speed);
            }
        } else if (curPos.distanceToSqr(leaderPos) > 4.0) {
            this.moveTowardsLeader(speed);
        }
        if (this.lastPosSample != null && curPos.distanceToSqr(this.lastPosSample) < 0.04) {
            ++this.stuckTicks;
            if (this.stuckTicks > this.stuckThreshold) {
                this.stuckTicks = 0;
                this.startMovingToDestination(speed);
            }
        } else {
            this.stuckTicks = 0;
        }
        this.lastPosSample = curPos;
        if (this.lastPosVec != null && curPos.distanceToSqr(this.lastPosVec) < 0.01) {
            ++this.stuckTicks;
        } else {
            this.stuckTicks = 0;
            this.lastPosVec = curPos;
            if (this.followerBreaker != null) {
                BlockBreakerManager.scheduleRemove(this.mob, this.followerBreaker);
                this.followerBreaker = null;
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) {
            boolean running;
            boolean trulyStuck;
            double distSqToTarget = this.myStableDestination != null ? this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.myStableDestination)) : curPos.distanceToSqr(leaderPos);
            boolean navIdleAndFar = this.mob.getNavigation().isDone() && distSqToTarget > 4.0;
            boolean bl = trulyStuck = this.stuckTicks >= 10;
            if (this.followerBreaker != null && !(running = this.mob.goalSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).anyMatch(wrapped -> wrapped.getGoal() == this.followerBreaker))) {
                this.followerBreaker = null;
            }
            if (this.followerBreaker == null && (navIdleAndFar || trulyStuck)) {
                BlockPos dest = this.myStableDestination != null ? this.myStableDestination : this.leader.blockPosition();
                BlockBreakerPosGoal breaker = new BlockBreakerPosGoal(this.mob, dest, (Double)SoundAttractConfig.COMMON.blockBreakTimeMultiplier.get(), (Boolean)SoundAttractConfig.COMMON.blockBreakToolOnly.get(), (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolOnly.get(), (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolRequired.get());
                BlockBreakerManager.scheduleAdd(this.mob, breaker, 2);
                this.followerBreaker = breaker;
                this.stuckTicks = 0;
            }
        }
        if (this.leaderAttractionGoal == null && !RaidManager.isRaidAdvancing(this.leader) && this.mob.distanceToSqr((Entity)this.leader) < this.getGroupDistance() * this.getGroupDistance()) {
            this.mob.getNavigation().stop();
        }
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.leader = null;
        this.leaderAttractionGoal = null;
        this.leaderObjectivePos = null;
        this.myStableDestination = null;
        this.lastPosVec = null;
        if (this.followerBreaker != null) {
            BlockBreakerManager.scheduleRemove(this.mob, this.followerBreaker);
            this.followerBreaker = null;
        }
    }
}

