/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundAttractionEvents;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.StealthDetectionEvents;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.BlockBreakerPosGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FollowerEdgeRelayGoal
extends Goal {
    private final Mob mob;
    private final double moveSpeed;
    private BlockPos targetSoundPos;
    private double currentTargetWeight = -1.0;
    private int scanCooldownCounter = 0;
    private BlockPos lastPos = null;
    private int stuckTicks = 0;
    private SoundTracker.SoundRecord cachedSound = null;
    private BlockBreakerPosGoal blockBreakerGoal = null;
    private EdgeMobState edgeMobState = null;
    private boolean raidScheduled = false;

    public FollowerEdgeRelayGoal(Mob mob, double moveSpeed) {
        this.mob = mob;
        this.moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    private int scanCooldownTicks() {
        return DynamicScanCooldownManager.currentScanCooldownTicks;
    }

    private boolean isMobEligible() {
        Set<EntityType<?>> attractedTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        boolean byType = attractedTypes.contains(this.mob.getType());
        boolean hasProfile = SoundAttractConfig.getMatchingProfile(this.mob) != null;
        return byType || hasProfile;
    }

    private double getArrivalDistance() {
        return (Double)SoundAttractConfig.COMMON.arrivalDistance.get();
    }

    private SoundTracker.SoundRecord findNearestSound() {
        Level level = this.mob.level();
        if (level.isClientSide()) {
            return null;
        }
        return SoundTracker.findNearestSound(this.mob, level, this.mob.blockPosition(), this.mob.getEyePosition());
    }

    public boolean canUse() {
        if (this.mob.isVehicle() || this.mob.isSleeping()) {
            return false;
        }
        if (!this.isMobEligible()) {
            return false;
        }
        if (!((Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get()).booleanValue()) {
            return false;
        }
        Mob leader = MobGroupManager.getLeader(this.mob);
        boolean isDeserter = MobGroupManager.isDeserter(this.mob);
        if (leader == this.mob && !isDeserter) {
            return false;
        }
        if (!MobGroupManager.isEdgeMob(this.mob) && !isDeserter) {
            return false;
        }
        if (this.scanCooldownCounter > 0) {
            --this.scanCooldownCounter;
            return false;
        }
        this.scanCooldownCounter = this.scanCooldownTicks();
        SoundTracker.SoundRecord newSound = this.findNearestSound();
        if (newSound == null) {
            return false;
        }
        this.targetSoundPos = newSound.pos;
        this.currentTargetWeight = newSound.weight;
        this.cachedSound = newSound;
        this.edgeMobState = EdgeMobState.GOING_TO_SOUND;
        this.raidScheduled = false;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] START GOING_TO_SOUND: mob={} leader={} edgeMob={}", new Object[]{this.mob.getName().getString(), leader != null ? leader.getName().getString() : "null", MobGroupManager.isEdgeMob(this.mob)});
        }
        return true;
    }

    public boolean canContinueToUse() {
        if (this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER) {
            return true;
        }
        if (!this.isMobEligible() || this.mob.isVehicle() || this.mob.isSleeping()) {
            return false;
        }
        if (this.targetSoundPos == null) {
            return false;
        }
        SoundTracker.SoundRecord bestSound = this.findNearestSound();
        if (bestSound == null) {
            return false;
        }
        if (bestSound.pos.equals((Object)this.targetSoundPos)) {
            this.cachedSound = bestSound;
            this.currentTargetWeight = bestSound.weight;
            return true;
        }
        double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
        if (bestSound.weight > this.currentTargetWeight * switchRatio) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] canContinueToUse -> FALSE (switch to stronger sound {} > {}) for mob {}.", new Object[]{String.format("%.2f", bestSound.weight), String.format("%.2f", this.currentTargetWeight), this.mob.getName().getString()});
            }
            return false;
        }
        return true;
    }

    public void stop() {
        this.mob.getNavigation().stop();
        this.edgeMobState = null;
        this.targetSoundPos = null;
        this.cachedSound = null;
        this.raidScheduled = false;
    }

    public void tick() {
        if (this.scanCooldownCounter > 0) {
            --this.scanCooldownCounter;
        }
        Mob leader = MobGroupManager.getLeader(this.mob);
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        if (this.lastPos != null && this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.lastPos)) < 1.0) {
            ++this.stuckTicks;
        } else {
            this.stuckTicks = 0;
            if (this.blockBreakerGoal != null) {
                BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                this.blockBreakerGoal = null;
            }
        }
        if (this.stuckTicks == 0) {
            this.lastPos = this.mob.blockPosition();
        }
        if (this.stuckTicks >= 40 && ((Boolean)SoundAttractConfig.COMMON.enableBlockBreaking.get()).booleanValue()) {
            BlockPos destination;
            BlockPos blockPos = destination = this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER && leader != null ? leader.blockPosition() : this.targetSoundPos;
            if (this.mob.getNavigation().isDone()) {
                if (destination != null && this.mob.blockPosition().distSqr((Vec3i)destination) > 4.0) {
                    ++this.stuckTicks;
                    if (this.stuckTicks >= 20 && this.blockBreakerGoal == null) {
                        double timeMultiplier = (Double)SoundAttractConfig.COMMON.blockBreakTimeMultiplier.get();
                        boolean toolOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakToolOnly.get();
                        boolean properOnly = (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolOnly.get();
                        boolean properReq = (Boolean)SoundAttractConfig.COMMON.blockBreakProperToolRequired.get();
                        BlockBreakerPosGoal newGoal = new BlockBreakerPosGoal(this.mob, destination, timeMultiplier, toolOnly, properOnly, properReq);
                        BlockBreakerManager.scheduleAdd(this.mob, newGoal, 1);
                        this.blockBreakerGoal = newGoal;
                    }
                } else {
                    this.stuckTicks = 0;
                }
            } else {
                this.stuckTicks = 0;
                if (this.blockBreakerGoal != null) {
                    BlockBreakerManager.scheduleRemove(this.mob, this.blockBreakerGoal);
                    this.blockBreakerGoal = null;
                }
            }
        }
        if (!smartEdge) {
            if (this.targetSoundPos != null) {
                this.mob.getNavigation().moveTo((double)this.targetSoundPos.getX(), (double)this.targetSoundPos.getY(), (double)this.targetSoundPos.getZ(), this.moveSpeed);
            }
            return;
        }
        if (this.edgeMobState == null) {
            this.edgeMobState = EdgeMobState.GOING_TO_SOUND;
        }
        if (this.edgeMobState == EdgeMobState.GOING_TO_SOUND) {
            if (StealthDetectionEvents.shouldSuppressTargeting(this.mob)) {
                if (!this.raidScheduled && !MobGroupManager.isDeserter(this.mob)) {
                    raidLeader = MobGroupManager.getLeader(this.mob);
                    if (raidLeader == this.mob) {
                        raidLeader = null;
                    }
                    if (raidLeader != null && !RaidManager.isRaidTicking(raidLeader) && !RaidManager.isRaidAdvancing(raidLeader)) {
                        RaidManager.scheduleRaid(raidLeader, this.targetSoundPos, this.mob.level().getGameTime());
                        this.raidScheduled = true;
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} suppression -> schedule RAID for leader {} at {}.", new Object[]{this.mob.getName().getString(), raidLeader.getName().getString(), this.targetSoundPos});
                        }
                    }
                }
                this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
                this.mob.getNavigation().stop();
            } else {
                this.mob.getNavigation().moveTo((double)this.targetSoundPos.getX(), (double)this.targetSoundPos.getY(), (double)this.targetSoundPos.getZ(), this.moveSpeed);
                if (this.mob.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.targetSoundPos)) < this.getArrivalDistance() * this.getArrivalDistance()) {
                    if (!this.raidScheduled && !MobGroupManager.isDeserter(this.mob)) {
                        raidLeader = MobGroupManager.getLeader(this.mob);
                        if (raidLeader == this.mob) {
                            raidLeader = null;
                        }
                        if (raidLeader != null && !RaidManager.isRaidTicking(raidLeader) && !RaidManager.isRaidAdvancing(raidLeader)) {
                            RaidManager.scheduleRaid(raidLeader, this.targetSoundPos, this.mob.level().getGameTime());
                            this.raidScheduled = true;
                            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                SoundAttractMod.LOGGER.info("[FollowerEdgeRelayGoal] {} arrival -> schedule RAID for leader {} at {}.", new Object[]{this.mob.getName().getString(), raidLeader.getName().getString(), this.targetSoundPos});
                            }
                        }
                    }
                    this.edgeMobState = EdgeMobState.RETURNING_TO_LEADER;
                }
            }
        } else if (this.edgeMobState == EdgeMobState.RETURNING_TO_LEADER) {
            Mob returnLeader;
            if (MobGroupManager.isDeserter(this.mob)) {
                this.targetSoundPos = null;
                this.edgeMobState = null;
                return;
            }
            Object object = returnLeader = leader != this.mob ? leader : null;
            if (returnLeader != null && !returnLeader.isRemoved() && !returnLeader.isDeadOrDying()) {
                double sprintMult = (Double)SoundAttractConfig.COMMON.groupSprintMultiplier.get();
                this.mob.getNavigation().moveTo(returnLeader.getX(), returnLeader.getY(), returnLeader.getZ(), this.moveSpeed * sprintMult);
                double arrive = (Double)SoundAttractConfig.COMMON.leaderReturnArrivalDistance.get();
                if (this.mob.distanceToSqr((Entity)returnLeader) < arrive * arrive) {
                    this.targetSoundPos = null;
                    this.edgeMobState = null;
                }
            } else {
                this.targetSoundPos = null;
                this.edgeMobState = null;
            }
        }
    }

    private static enum EdgeMobState {
        GOING_TO_SOUND,
        RETURNING_TO_LEADER;

    }
}

