/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.EnhancedAICompat;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;

public class PickUpAndThrowToSoundGoal
extends Goal {
    private final Mob mob;
    private final TargetingConditions targetingConditions;
    private Mob pickUp;
    private int unreachableTime;
    private int cooldown;
    private SoundTracker.SoundRecord targetSound;

    public PickUpAndThrowToSoundGoal(Mob mob) {
        this.mob = mob;
        this.targetingConditions = TargetingConditions.forNonCombat().range(this.getFollowDistance()).selector(livingEntity -> !livingEntity.isPassenger());
        this.setFlags(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!((Boolean)SoundAttractConfig.COMMON.enablePickUpAndThrowToSound.get()).booleanValue()) {
            return false;
        }
        if (this.mob.isVehicle()) {
            return false;
        }
        if (--this.cooldown > 0) {
            return false;
        }
        double chance = EnhancedAICompat.getPickUpAndThrowChance(this.mob.level());
        if (this.mob.getRandom().nextDouble() >= chance) {
            return false;
        }
        this.targetSound = SoundTracker.findNearestSound(this.mob, this.mob.level(), this.mob.blockPosition(), this.mob.getEyePosition());
        if (this.targetSound == null) {
            return false;
        }
        String canPickUpTagStr = (String)SoundAttractConfig.COMMON.pickUpCanPickUpTag.get();
        if (canPickUpTagStr == null || canPickUpTagStr.isBlank()) {
            return false;
        }
        TagKey canPickUpTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)canPickUpTagStr));
        if (!this.mob.getType().is(canPickUpTag)) {
            return false;
        }
        int minDist = EnhancedAICompat.getPickUpMinDistanceToPickUp();
        double distToSound = Math.sqrt(this.mob.blockPosition().distSqr((Vec3i)this.targetSound.pos));
        if (distToSound < (double)minDist) {
            return false;
        }
        String canBePickedUpTagStr = (String)SoundAttractConfig.COMMON.pickUpCanBePickedUpTag.get();
        if (canBePickedUpTagStr == null || canBePickedUpTagStr.isBlank()) {
            return false;
        }
        TagKey canBePickedUpTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)canBePickedUpTagStr));
        this.targetingConditions.range(this.getFollowDistance());
        this.pickUp = (Mob)this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(Mob.class, this.mob.getBoundingBox().inflate(this.getFollowDistance()), living -> living.getType().is(canBePickedUpTag)), this.targetingConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
        return this.pickUp != null && this.pickUp.isAlive();
    }

    public boolean canContinueToUse() {
        return this.pickUp != null && this.pickUp.isAlive() && this.targetSound != null && this.targetSound.ticksRemaining > 0;
    }

    public void start() {
        this.mob.getLookControl().setLookAt((Entity)this.pickUp);
        this.mob.getNavigation().stop();
        this.mob.getNavigation().moveTo((Entity)this.pickUp, EnhancedAICompat.getPickUpSpeedModifier());
        this.pickUp.getNavigation().stop();
    }

    public void stop() {
        this.pickUp = null;
        this.unreachableTime = 0;
        this.targetSound = null;
    }

    protected double getFollowDistance() {
        return this.mob.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    public void tick() {
        if (this.targetSound == null || this.targetSound.ticksRemaining <= 0) {
            this.targetSound = SoundTracker.findNearestSound(this.mob, this.mob.level(), this.mob.blockPosition(), this.mob.getEyePosition());
            if (this.targetSound == null) {
                this.stop();
                return;
            }
        }
        if (!this.mob.isVehicle()) {
            this.pickUp.getNavigation().stop();
            if (this.mob.getNavigation().isDone()) {
                this.mob.getNavigation().moveTo((Entity)this.pickUp, EnhancedAICompat.getPickUpSpeedModifier());
            }
            if (this.mob.distanceToSqr((Entity)this.pickUp) <= 4.0) {
                this.pickUp.startRiding((Entity)this.mob, false);
                this.cooldown = this.adjustedTickDelay(20);
            }
        } else {
            BlockPos soundPos = this.targetSound.pos;
            int maxThrow = EnhancedAICompat.getPickUpMaxDistanceToThrow();
            double distToSoundSq = this.mob.blockPosition().distSqr((Vec3i)soundPos);
            if (--this.cooldown <= 0 && distToSoundSq <= (double)(maxThrow * maxThrow)) {
                double distanceY = (double)soundPos.getY() + 0.5 - this.pickUp.getY();
                double distanceX = (double)soundPos.getX() + 0.5 - this.pickUp.getX();
                double distanceZ = (double)soundPos.getZ() + 0.5 - this.pickUp.getZ();
                double distanceXZ = Math.sqrt(distanceX * distanceX + distanceZ * distanceZ);
                Vec3 motion = new Vec3(distanceX * 0.1, Mth.clamp((double)distanceY, (double)4.0, (double)40.0) / 10.0 + distanceXZ / 100.0, distanceZ * 0.1);
                this.pickUp.stopRiding();
                this.pickUp.setDeltaMovement(motion);
                this.mob.playSound(SoundEvents.AXE_STRIP, 3.0f, 1.5f);
                this.cooldown = this.adjustedTickDelay(EnhancedAICompat.getPickUpCooldownTicks());
                this.stop();
                return;
            }
        }
        if (++this.unreachableTime > this.adjustedTickDelay(120)) {
            this.cooldown = this.adjustedTickDelay(EnhancedAICompat.getPickUpCooldownTicks());
            this.stop();
        }
    }
}

