/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.EnhancedAICompat;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class TeleportToSoundGoal
extends Goal {
    private final Mob mob;
    private final TargetingConditions targetingConditions;
    private Mob toTeleport;
    private int unreachableTime;
    private int cooldown;
    private int teleportTick;
    private SoundTracker.SoundRecord targetSound;

    public TeleportToSoundGoal(Mob mob) {
        this.mob = mob;
        this.targetingConditions = TargetingConditions.forNonCombat().range(this.getFollowDistance());
        this.setFlags(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!((Boolean)SoundAttractConfig.COMMON.enableTeleportToSound.get()).booleanValue()) {
            return false;
        }
        if (--this.cooldown > 0) {
            return false;
        }
        if (this.mob.isBaby()) {
            return false;
        }
        String teleporterTagStr = (String)SoundAttractConfig.COMMON.teleportCanTeleportTag.get();
        if (teleporterTagStr == null || teleporterTagStr.isBlank()) {
            return false;
        }
        TagKey teleporterTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)teleporterTagStr));
        if (!this.mob.getType().is(teleporterTag)) {
            return false;
        }
        double chance = EnhancedAICompat.getTeleportToTargetChance(this.mob.level());
        if (this.mob.getRandom().nextDouble() >= chance) {
            return false;
        }
        this.targetSound = SoundTracker.findNearestSound(this.mob, this.mob.level(), this.mob.blockPosition(), this.mob.getEyePosition());
        if (this.targetSound == null) {
            return false;
        }
        String targetTagStr = (String)SoundAttractConfig.COMMON.teleportCanBeTeleportedTag.get();
        if (targetTagStr == null || targetTagStr.isBlank()) {
            return false;
        }
        TagKey targetTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)targetTagStr));
        this.targetingConditions.range(this.getFollowDistance());
        this.toTeleport = (Mob)this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(Mob.class, this.mob.getBoundingBox().inflate(this.getFollowDistance()), other -> other != this.mob && other.isAlive() && other.getType().is(targetTag)), this.targetingConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
        return this.toTeleport != null;
    }

    public boolean canContinueToUse() {
        return this.toTeleport != null && this.toTeleport.isAlive() && this.targetSound != null && this.targetSound.ticksRemaining > 0;
    }

    public void start() {
        this.mob.getLookControl().setLookAt((Entity)this.toTeleport);
        this.mob.getNavigation().stop();
        this.mob.getNavigation().moveTo((Entity)this.toTeleport, 1.5);
        this.toTeleport.getNavigation().stop();
    }

    public void stop() {
        this.toTeleport = null;
        this.unreachableTime = 0;
        this.targetSound = null;
        this.teleportTick = 0;
    }

    protected double getFollowDistance() {
        return this.mob.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    public void tick() {
        if (this.targetSound == null) {
            this.stop();
            return;
        }
        BlockPos soundPos = this.targetSound.pos;
        if (this.teleportTick <= 0) {
            this.mob.getLookControl().setLookAt((Entity)this.toTeleport);
            this.toTeleport.getNavigation().stop();
            if (this.mob.getNavigation().isDone()) {
                this.mob.getNavigation().moveTo((Entity)this.toTeleport, 1.5);
            }
            if (this.mob.distanceToSqr((Entity)this.toTeleport) <= 4.0) {
                this.hide((LivingEntity)this.mob);
                this.hide((LivingEntity)this.toTeleport);
                this.teleportTick = this.adjustedTickDelay(30);
            }
        } else if (--this.teleportTick <= 0) {
            this.show((LivingEntity)this.mob);
            this.teleportSafely((LivingEntity)this.toTeleport, (double)soundPos.getX() + 0.5, soundPos.getY(), (double)soundPos.getZ() + 0.5);
            this.show((LivingEntity)this.toTeleport);
            this.cooldown = this.adjustedTickDelay(EnhancedAICompat.getTeleportCooldownTicks());
            this.stop();
            return;
        }
        if (++this.unreachableTime > this.adjustedTickDelay(120)) {
            this.cooldown = this.adjustedTickDelay(EnhancedAICompat.getTeleportCooldownTicks());
            this.stop();
        }
    }

    private void hide(LivingEntity entity) {
        this.applySpeedFreeze(entity);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, entity.getX(), entity.getEyeY(), entity.getZ(), 200, 0.5, 0.5, 0.5, 0.5);
        }
        entity.playSound(SoundEvents.ENDERMAN_TELEPORT, 4.0f, 0.5f);
        entity.setNoGravity(true);
        entity.setInvisible(true);
    }

    private void show(LivingEntity entity) {
        this.removeSpeedFreeze(entity);
        entity.setNoGravity(false);
        entity.setInvisible(false);
        entity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 2.0f);
    }

    private void applySpeedFreeze(LivingEntity entity) {
        if (!entity.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) || entity.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() < 10) {
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, this.adjustedTickDelay(60), 10, false, false, false));
        }
    }

    private void removeSpeedFreeze(LivingEntity entity) {
        entity.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
    }

    private void teleportSafely(LivingEntity entity, double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pX, pY, pZ);
        BlockState state = entity.level().getBlockState((BlockPos)mutable);
        boolean blocksMotion = state.blocksMotion();
        boolean isWater = state.getFluidState().is(FluidTags.WATER);
        if (blocksMotion && !isWater) {
            do {
                Vec3 oldPos = entity.position();
                entity.teleportTo(pX, pY += 1.0, pZ);
                entity.level().gameEvent((Holder)GameEvent.TELEPORT, oldPos, GameEvent.Context.of((Entity)entity));
            } while (entity.getY() < (double)entity.level().getMaxBuildHeight() && !entity.level().noCollision((Entity)entity));
        } else {
            Vec3 oldPos = entity.position();
            entity.teleportTo(pX, pY, pZ);
            entity.level().gameEvent((Holder)GameEvent.TELEPORT, oldPos, GameEvent.Context.of((Entity)entity));
        }
    }
}

