/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import su.plo.slib.api.entity.player.McPlayer;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.InjectPlasmoVoice;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.event.audio.source.PlayerSpeakEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.player.VoicePlayer;

@Addon(id="soundattract", name="Attract to Sound", version="PlasmoVoice", authors={"Paldiu", "Sylsatra"})
public final class PlasmoIntegration
implements AddonInitializer {
    @InjectPlasmoVoice
    private PlasmoVoiceServer server;

    public void onAddonInitialize() {
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[PlasmoIntegration] onAddonInitialize: registering voice listener");
        }
        try {
            if (this.server == null) {
                SoundAttractMod.LOGGER.warn("[PlasmoIntegration] PlasmoVoiceServer is null; skipping listener registration.");
                return;
            }
            this.server.getEventBus().register((Object)this, (Object)new VoiceListener());
        }
        catch (Throwable t) {
            SoundAttractMod.LOGGER.warn("[PlasmoIntegration] register(this, listener) failed: {}", (Object)t.toString());
        }
    }

    public void onAddonShutdown() {
        super.onAddonShutdown();
    }

    public static final class VoiceListener {
        private ServerPlayer resolveMcPlayer(Object inst) {
            String[] fieldNames;
            String[] methodNames;
            if (inst instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)inst;
                return sp;
            }
            if (inst == null) {
                return null;
            }
            for (String name : methodNames = new String[]{"getPlayer", "getMinecraftPlayer", "getHandle", "getNms", "player"}) {
                try {
                    Method m = inst.getClass().getMethod(name, new Class[0]);
                    m.setAccessible(true);
                    Object value = m.invoke(inst, new Object[0]);
                    if (!(value instanceof ServerPlayer)) continue;
                    ServerPlayer sp = (ServerPlayer)value;
                    return sp;
                }
                catch (Throwable m) {
                    // empty catch block
                }
            }
            for (String name : fieldNames = new String[]{"player", "minecraftPlayer", "handle", "nms"}) {
                try {
                    Field f = inst.getClass().getDeclaredField(name);
                    f.setAccessible(true);
                    Object value = f.get(inst);
                    if (!(value instanceof ServerPlayer)) continue;
                    ServerPlayer sp = (ServerPlayer)value;
                    return sp;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[PlasmoIntegration] resolveMcPlayer: failed to unwrap {}", (Object)inst.getClass().getName());
            }
            return null;
        }

        private UUID tryResolveUuid(Object obj) {
            String[] fields;
            String[] methods;
            if (obj == null) {
                return null;
            }
            for (String name : methods = new String[]{"getUUID", "getUuid", "getUniqueId", "getId"}) {
                try {
                    Method m = obj.getClass().getMethod(name, new Class[0]);
                    m.setAccessible(true);
                    Object value = m.invoke(obj, new Object[0]);
                    if (value instanceof UUID) {
                        UUID u = (UUID)value;
                        return u;
                    }
                    if (!(value instanceof String)) continue;
                    String s = (String)value;
                    try {
                        return UUID.fromString(s);
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable m) {
                    // empty catch block
                }
            }
            for (String name : fields = new String[]{"uuid", "UUID", "id", "uniqueId"}) {
                try {
                    Field f = obj.getClass().getDeclaredField(name);
                    f.setAccessible(true);
                    Object value = f.get(obj);
                    if (value instanceof UUID) {
                        UUID u = (UUID)value;
                        return u;
                    }
                    if (!(value instanceof String)) continue;
                    String s = (String)value;
                    try {
                        return UUID.fromString(s);
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }

        private ServerPlayer resolveViaServer(UUID uuid) {
            if (uuid == null) {
                return null;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return null;
            }
            return server.getPlayerList().getPlayer(uuid);
        }

        @EventSubscribe
        public void onPlayerSpeak(PlayerSpeakEvent event) {
            try {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[PlasmoIntegration] onPlayerSpeak: event={} player={}", (Object)event, (Object)(event != null ? event.getPlayer() : null));
                }
                if (event == null) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[PlasmoIntegration] onPlayerSpeak: event was null (early return)");
                    }
                    return;
                }
                if (event.getPlayer() == null) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[PlasmoIntegration] onPlayerSpeak: event.getPlayer() was null (early return)");
                    }
                    return;
                }
                if (!((Boolean)SoundAttractConfig.COMMON.enableVoiceChatIntegration.get()).booleanValue()) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[PlasmoIntegration] onPlayerSpeak: integration disabled by config");
                    }
                    return;
                }
                McPlayer inst = event.getPlayer().getInstance();
                ServerPlayer mcPlayer = this.resolveMcPlayer(inst);
                if (mcPlayer == null) {
                    UUID uuid = this.tryResolveUuid(event.getPlayer());
                    if (uuid == null) {
                        uuid = this.tryResolveUuid(inst);
                    }
                    if ((mcPlayer = this.resolveViaServer(uuid)) == null) {
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[PlasmoIntegration] onPlayerSpeak: could not resolve ServerPlayer (uuid={} inst={})", (Object)uuid, (Object)(inst != null ? inst.getClass().getName() : "null"));
                        }
                        return;
                    }
                }
                int range = (Integer)SoundAttractConfig.COMMON.voiceChatNormalRange.get();
                double weight = (Double)SoundAttractConfig.COMMON.voiceChatWeight.get();
                int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
                BlockPos pos = mcPlayer.blockPosition();
                String dim = mcPlayer.serverLevel().dimension().location().toString();
                UUID uuid = mcPlayer.getUUID();
                SoundTracker.addVirtualSound(pos, dim, range, weight, lifetime, uuid, "voice_chat");
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[PlasmoIntegration] VOICE_CHAT (PlayerSpeakEvent) player={} range={} dim={}", new Object[]{mcPlayer.getGameProfile().getName(), range, dim});
                }
            }
            catch (Throwable t) {
                SoundAttractMod.LOGGER.error("[PlasmoIntegration] Exception in onPlayerSpeak", t);
            }
        }

        @EventSubscribe
        public void onServerSourceAudio(ServerSourceAudioPacketEvent event) {
            try {
                PlayerActivationInfo activationInfo;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[PlasmoIntegration] onServerSourceAudio: event received={}", (Object)event);
                }
                if (event == null) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[PlasmoIntegration] onServerSourceAudio: event was null (early return)");
                    }
                    return;
                }
                if (!((Boolean)SoundAttractConfig.COMMON.enableVoiceChatIntegration.get()).booleanValue()) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[PlasmoIntegration] onServerSourceAudio: integration disabled by config");
                    }
                    return;
                }
                int distance = event.getDistance();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[PlasmoIntegration] onServerSourceAudio: distance={}", (Object)((short)distance));
                }
                if ((activationInfo = event.getActivationInfo()) == null) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[PlasmoIntegration] onServerSourceAudio: activationInfo is null (early return)");
                    }
                    return;
                }
                VoicePlayer voicePlayer = activationInfo.getPlayer();
                if (voicePlayer == null) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[PlasmoIntegration] onServerSourceAudio: activationInfo.getPlayer() is null (early return)");
                    }
                    return;
                }
                McPlayer inst = voicePlayer.getInstance();
                ServerPlayer mcPlayer = this.resolveMcPlayer(inst);
                if (mcPlayer == null) {
                    UUID uuid = this.tryResolveUuid(voicePlayer);
                    if (uuid == null) {
                        uuid = this.tryResolveUuid(inst);
                    }
                    if ((mcPlayer = this.resolveViaServer(uuid)) == null) {
                        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                            SoundAttractMod.LOGGER.info("[PlasmoIntegration] onServerSourceAudio: could not resolve ServerPlayer (uuid={} inst={})", (Object)uuid, (Object)(inst != null ? inst.getClass().getName() : "null"));
                        }
                        return;
                    }
                }
                int range = distance > 0 ? distance : (Integer)SoundAttractConfig.COMMON.voiceChatNormalRange.get();
                double weight = (Double)SoundAttractConfig.COMMON.voiceChatWeight.get();
                int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[PlasmoIntegration] onServerSourceAudio: computed range={} weight={} lifetime={} for player {}", new Object[]{range, weight, lifetime, mcPlayer.getGameProfile().getName()});
                }
                BlockPos pos = mcPlayer.blockPosition();
                String dim = mcPlayer.serverLevel().dimension().location().toString();
                UUID uuid = mcPlayer.getUUID();
                SoundTracker.addVirtualSound(pos, dim, range, weight, lifetime, uuid, "voice_chat");
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[PlasmoIntegration] VOICE_CHAT (ServerSourceAudio) player={} range={} dim={}", new Object[]{mcPlayer.getGameProfile().getName(), range, dim});
                }
            }
            catch (Throwable t) {
                SoundAttractMod.LOGGER.error("[PlasmoIntegration] Exception in onServerSourceAudio", t);
            }
        }
    }
}

