/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class VanillaIntegrationEvents {
    private static boolean wasSprinting = false;
    private static boolean wasSneaking = false;
    private static boolean wasCrawling = false;
    private static boolean wasOnGround = true;
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        boolean isJumping;
        if (event.getEntity().level().isClientSide) {
            return;
        }
        int cooldown = DynamicScanCooldownManager.currentScanCooldownTicks;
        if (++tickCounter % cooldown != 0) {
            return;
        }
        Player player = event.getEntity();
        ResourceLocation dim = player.level().dimension().location();
        Vec3 pos = player.position();
        Optional<UUID> uuid = Optional.of(player.getUUID());
        if (player.isSprinting()) {
            VanillaIntegrationEvents.addVanillaSound("VanillaSprint", "minecraft:entity.player.sprint", pos, dim, uuid, 10, 1.2);
        }
        wasSprinting = player.isSprinting();
        if (!player.isSprinting() && !player.isCrouching() && player.getDeltaMovement().horizontalDistanceSqr() > 0.01 && player.onGround() && !player.isSwimming()) {
            VanillaIntegrationEvents.addVanillaSound("VanillaWalk", "minecraft:entity.player.walk", pos, dim, uuid, 6, 0.6);
        }
        boolean bl = isJumping = player.fallDistance == 0.0f && player.getDeltaMovement().y > 0.1 && !wasOnGround;
        if (isJumping) {
            VanillaIntegrationEvents.addVanillaSound("VanillaJump", "minecraft:entity.player.jump", pos, dim, uuid, 7, 0.7);
        }
        wasOnGround = player.onGround();
        if (player.isCrouching()) {
            VanillaIntegrationEvents.addVanillaSound("VanillaSneak", "minecraft:entity.player.sneak", pos, dim, uuid, 3, 0.2);
        }
        wasSneaking = player.isCrouching();
        boolean isCrawling = player.isVisuallyCrawling();
        if (isCrawling) {
            VanillaIntegrationEvents.addVanillaSound("VanillaCrawl", "minecraft:block.wool.step", pos, dim, uuid, 2, 0.1);
        }
        wasCrawling = isCrawling;
    }

    private static int parseIntOr(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static double parseDoubleOr(String s, double def) {
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static void addVanillaSound(String animatorClass, String soundId, Vec3 position, ResourceLocation dim, Optional<UUID> uuid, int range, double weight) {
        ResourceLocation soundResource = ResourceLocation.parse((String)soundId);
        if (!SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() && !SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(soundResource)) {
            return;
        }
        BlockPos pos = BlockPos.containing((Position)position);
        String dimString = dim.toString();
        int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
        Optional se = BuiltInRegistries.SOUND_EVENT.getOptional(soundResource);
        se.ifPresentOrElse(soundEvent -> SoundTracker.addSound(soundEvent, pos, dimString, range, weight, lifetime), () -> {
            if (animatorClass != null && !animatorClass.isEmpty()) {
                SoundTracker.addVirtualSound(pos, dimString, range, weight, lifetime, uuid.orElse(null), animatorClass);
            }
        });
    }
}

