/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.loot;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.enchantment.ModEnchantments;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddItemLootModifier
extends LootModifier {
    public static final MapCodec<AddItemLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> AddItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AddItemLootModifier::new));

    public AddItemLootModifier(LootItemCondition[] conditions) {
        super(conditions);
        SoundAttractMod.LOGGER.info("AddItemLootModifier INSTANCE CREATED!");
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        SoundAttractMod.LOGGER.info("AddItemLootModifier is running for loot table: " + String.valueOf(context.getQueriedLootTableId()));
        Registry enchantmentRegistry = context.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        enchantmentRegistry.getHolder(ModEnchantments.CONCEAL).ifPresent(concealHolder -> {
            SoundAttractMod.LOGGER.info("Found CONCEAL enchantment holder! Adding book to loot.");
            EnchantmentInstance instance = new EnchantmentInstance((Holder)concealHolder, 1);
            ItemStack enchantedBook = EnchantedBookItem.createForEnchantment((EnchantmentInstance)instance);
            generatedLoot.add((Object)enchantedBook);
        });
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

