/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.client;

import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.path.NodeIndex;
import com.example.soundattract.path.VisibilityGraphCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="soundattract", value={Dist.CLIENT})
public class NodePathDebugRenderer {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!((Boolean)SoundAttractConfig.COMMON.debugNodePathfinding.get()).booleanValue()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        LocalPlayer context = mc.f_91074_;
        Vec3 cam = mc.f_91063_.m_109153_().m_90583_();
        PoseStack ps = event.getPoseStack();
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        int radius = Math.min(64, (Integer)SoundAttractConfig.COMMON.nodeSearchRadius.get());
        double maxEdgeDist = (Double)SoundAttractConfig.COMMON.nodeMaxEdgeDistance.get();
        int maxVD = (Integer)SoundAttractConfig.COMMON.nodeMaxVerticalDelta.get();
        int ttl = (Integer)SoundAttractConfig.COMMON.nodeGraphCacheTtlTicks.get();
        List<NodeIndex.Node> nodes = NodeIndex.get((Level)level).nodesWithin((Level)level, context.m_20182_(), radius);
        Map<NodeIndex.Node, List<NodeIndex.Node>> neighbors = VisibilityGraphCache.get((Level)level).getNeighbors((Level)level, (Entity)context, nodes, maxEdgeDist, maxVD, ttl);
        VertexConsumer lineBuffer = buffers.m_6299_(RenderType.m_110504_());
        int shown = 0;
        HashSet<Long> drawnPairs = new HashSet<Long>();
        for (NodeIndex.Node node : nodes) {
            Vec3 p = node.pos;
            double x = p.f_82479_ - cam.f_82479_;
            double y = p.f_82480_ - cam.f_82480_;
            double z = p.f_82481_ - cam.f_82481_;
            AABB box = new AABB(x - 0.15, y - 0.15, z - 0.15, x + 0.15, y + 0.15, z + 0.15);
            LevelRenderer.m_109646_((PoseStack)ps, (VertexConsumer)lineBuffer, (AABB)box, (float)0.2f, (float)0.8f, (float)0.2f, (float)1.0f);
            if (++shown <= 200) continue;
            break;
        }
        for (Map.Entry entry : neighbors.entrySet()) {
            NodeIndex.Node a = (NodeIndex.Node)entry.getKey();
            for (NodeIndex.Node b : (List)entry.getValue()) {
                long key = NodePathDebugRenderer.pairKey(a.pos, b.pos);
                long keyR = NodePathDebugRenderer.pairKey(b.pos, a.pos);
                if (drawnPairs.contains(key) || drawnPairs.contains(keyR)) continue;
                drawnPairs.add(key);
                NodePathDebugRenderer.drawLine(ps, lineBuffer, cam, a.pos, b.pos, 0.2f, 0.4f, 1.0f, 1.0f);
            }
        }
        buffers.m_109912_(RenderType.m_110504_());
    }

    private static long pairKey(Vec3 a, Vec3 b) {
        long ax = (long)Math.floor(a.f_82479_);
        long ay = (long)Math.floor(a.f_82480_);
        long az = (long)Math.floor(a.f_82481_);
        long bx = (long)Math.floor(b.f_82479_);
        long by = (long)Math.floor(b.f_82480_);
        long bz = (long)Math.floor(b.f_82481_);
        long h1 = ax * 73856093L ^ ay * 19349663L ^ az * 83492791L;
        long h2 = bx * 73856093L ^ by * 19349663L ^ bz * 83492791L;
        return h1 << 1 ^ h2;
    }

    private static void drawLine(PoseStack ps, VertexConsumer v, Vec3 cam, Vec3 a, Vec3 b, float r, float g, float bl, float apha) {
        Vec3 a0 = a.m_82546_(cam);
        Vec3 b0 = b.m_82546_(cam);
        v.m_252986_(ps.m_85850_().m_252922_(), (float)a0.f_82479_, (float)a0.f_82480_, (float)a0.f_82481_).m_85950_(r, g, bl, apha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        v.m_252986_(ps.m_85850_().m_252922_(), (float)b0.f_82479_, (float)b0.f_82480_, (float)b0.f_82481_).m_85950_(r, g, bl, apha).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

