/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.loot;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class EnchantRandomlyModifier
extends LootModifier {
    protected final Enchantment enchantment;

    public EnchantRandomlyModifier(LootItemCondition[] conditionsIn, Enchantment enchantment) {
        super(conditionsIn);
        this.enchantment = enchantment;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        List potentialTargets = generatedLoot.stream().filter(stack -> !stack.m_41619_() && !stack.m_41793_() && this.isValidItem((ItemStack)stack) && this.enchantment.m_6081_(stack)).collect(Collectors.toList());
        if (!potentialTargets.isEmpty()) {
            ItemStack toEnchant = (ItemStack)potentialTargets.get(context.m_230907_().m_188503_(potentialTargets.size()));
            toEnchant.m_41663_(this.enchantment, 1);
        }
        return generatedLoot;
    }

    protected abstract boolean isValidItem(ItemStack var1);

    public static <T extends EnchantRandomlyModifier> RecordCodecBuilder<T, Enchantment> enchantmentCodecStart(RecordCodecBuilder.Instance<T> instance) {
        return ForgeRegistries.ENCHANTMENTS.getCodec().fieldOf("enchantment").forGetter(m -> m.enchantment);
    }
}

