/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.path;

import com.example.soundattract.config.SoundAttractConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class NodeIndex {
    private static final Map<Level, NodeIndex> INSTANCES = new ConcurrentHashMap<Level, NodeIndex>();

    public static NodeIndex get(Level level) {
        return INSTANCES.computeIfAbsent(level, l -> new NodeIndex());
    }

    private NodeIndex() {
    }

    public List<Node> nodesWithin(Level level, Vec3 center, double radius) {
        double r = Math.max(1.0, radius);
        AABB box = new AABB(center, center).m_82400_(r);
        String tag = (String)SoundAttractConfig.COMMON.nodeEntityTag.get();
        String upTag = (String)SoundAttractConfig.COMMON.nodeStairUpTag.get();
        String downTag = (String)SoundAttractConfig.COMMON.nodeStairDownTag.get();
        List entities = level.m_6443_(Entity.class, box, e -> e != null && e.m_6084_() && e.m_19880_().contains(tag));
        ArrayList<Node> nodes = new ArrayList<Node>(entities.size());
        for (Entity e2 : entities) {
            Vec3 p = e2.m_20182_();
            boolean stairUp = e2.m_19880_().contains(upTag);
            boolean stairDown = e2.m_19880_().contains(downTag);
            nodes.add(new Node(new Vec3(Math.floor(p.f_82479_) + 0.5, Math.floor(p.f_82480_), Math.floor(p.f_82481_) + 0.5), stairUp, stairDown));
        }
        return nodes;
    }

    public Node nearestNode(Level level, Vec3 pos, double maxRadius) {
        double radius = Math.max(1.0, maxRadius);
        List<Node> candidates = this.nodesWithin(level, pos, radius);
        Node best = null;
        double bestD = Double.MAX_VALUE;
        for (Node n : candidates) {
            double d = n.pos.m_82557_(pos);
            if (!(d < bestD)) continue;
            bestD = d;
            best = n;
        }
        return best;
    }

    public static final class Node {
        public final Vec3 pos;
        public final boolean stairUp;
        public final boolean stairDown;

        public Node(Vec3 pos, boolean stairUp, boolean stairDown) {
            this.pos = pos;
            this.stairUp = stairUp;
            this.stairDown = stairDown;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node other = (Node)o;
            BlockPos a = BlockPos.m_274446_((Position)this.pos);
            BlockPos b = BlockPos.m_274446_((Position)other.pos);
            return a.equals((Object)b);
        }

        public int hashCode() {
            BlockPos a = BlockPos.m_274446_((Position)this.pos);
            return a.hashCode();
        }
    }
}

