/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.path;

import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.path.NodeIndex;
import com.example.soundattract.path.VisibilityGraphCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class NodePathfinder {
    private NodePathfinder() {
    }

    public static List<Vec3> findPath(Level level, Entity contextEntity, Vec3 startPos, Vec3 goalPos, int searchRadius, double maxEdgeDistance, int maxNeighbors, int maxVerticalDelta) {
        if (level == null || startPos == null || goalPos == null) {
            return List.of();
        }
        NodeIndex index = NodeIndex.get(level);
        NodeIndex.Node startNode = index.nearestNode(level, startPos, searchRadius);
        NodeIndex.Node goalNode = index.nearestNode(level, goalPos, searchRadius);
        if (startNode == null || goalNode == null) {
            return List.of();
        }
        List<NodeIndex.Node> candidates = index.nodesWithin(level, startPos, searchRadius);
        if (!candidates.contains(goalNode)) {
            List<NodeIndex.Node> goalArea = index.nodesWithin(level, goalPos, searchRadius);
            for (NodeIndex.Node n2 : goalArea) {
                if (candidates.contains(n2)) continue;
                candidates.add(n2);
            }
        }
        int ttl = (Integer)SoundAttractConfig.COMMON.nodeGraphCacheTtlTicks.get();
        Map<NodeIndex.Node, List<NodeIndex.Node>> allNeighbors = VisibilityGraphCache.get(level).getNeighbors(level, contextEntity, candidates, maxEdgeDistance, maxVerticalDelta, ttl);
        Comparator<NodeIndex.Node> byDistToGoal = Comparator.comparingDouble(n -> n.pos.m_82557_(goalPos));
        HashSet<NodeIndex.Node> closed = new HashSet<NodeIndex.Node>();
        HashMap<NodeIndex.Node, NodeIndex.Node> parent = new HashMap<NodeIndex.Node, NodeIndex.Node>();
        HashMap<NodeIndex.Node, Double> gScore = new HashMap<NodeIndex.Node, Double>();
        HashMap<NodeIndex.Node, Double> fScore = new HashMap<NodeIndex.Node, Double>();
        PriorityQueue<NodeIndex.Node> open = new PriorityQueue<NodeIndex.Node>(Comparator.comparingDouble(n -> fScore.getOrDefault(n, Double.POSITIVE_INFINITY)));
        gScore.put(startNode, 0.0);
        fScore.put(startNode, NodePathfinder.heuristic(startNode.pos, goalNode.pos));
        open.add(startNode);
        while (!open.isEmpty()) {
            NodeIndex.Node current = open.poll();
            if (current == goalNode) {
                return NodePathfinder.reconstructPath(parent, current, goalPos);
            }
            closed.add(current);
            List<NodeIndex.Node> neighbors = allNeighbors.getOrDefault(current, List.of());
            if (!neighbors.isEmpty()) {
                neighbors = new ArrayList(neighbors);
                neighbors.sort(byDistToGoal);
                if (neighbors.size() > maxNeighbors) {
                    neighbors = neighbors.subList(0, maxNeighbors);
                }
            }
            for (NodeIndex.Node nb : neighbors) {
                double tentativeG;
                if (closed.contains(nb) || !((tentativeG = gScore.getOrDefault(current, Double.POSITIVE_INFINITY) + Math.sqrt(current.pos.m_82557_(nb.pos))) < gScore.getOrDefault(nb, Double.POSITIVE_INFINITY))) continue;
                parent.put(nb, current);
                gScore.put(nb, tentativeG);
                fScore.put(nb, tentativeG + NodePathfinder.heuristic(nb.pos, goalNode.pos));
                if (open.contains(nb)) continue;
                open.add(nb);
            }
        }
        return List.of();
    }

    private static double heuristic(Vec3 a, Vec3 b) {
        return Math.sqrt(a.m_82557_(b));
    }

    private static List<Vec3> reconstructPath(Map<NodeIndex.Node, NodeIndex.Node> parent, NodeIndex.Node goal, Vec3 goalPos) {
        ArrayList<Vec3> path = new ArrayList<Vec3>();
        NodeIndex.Node cur = goal;
        while (cur != null) {
            path.add(0, cur.pos);
            cur = parent.get(cur);
        }
        path.add(goalPos);
        return path;
    }

    private static boolean hasClearLos(Level level, Entity entity, Vec3 a, Vec3 b) {
        ClipContext ctx = new ClipContext(a, b, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        BlockHitResult hit = level.m_45547_(ctx);
        return hit.m_6662_() == HitResult.Type.MISS;
    }
}

