/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.path;

import com.example.soundattract.path.NodeIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class VisibilityGraphCache {
    private static final Map<Level, VisibilityGraphCache> INSTANCES = new ConcurrentHashMap<Level, VisibilityGraphCache>();
    private final Map<String, Map<BlockPos, CachedNeighbors>> paramScoped = new HashMap<String, Map<BlockPos, CachedNeighbors>>();

    public static VisibilityGraphCache get(Level level) {
        return INSTANCES.computeIfAbsent(level, l -> new VisibilityGraphCache());
    }

    public Map<NodeIndex.Node, List<NodeIndex.Node>> getNeighbors(Level level, Entity context, List<NodeIndex.Node> candidates, double maxEdgeDistance, int maxVerticalDelta, int ttlTicks) {
        String key = VisibilityGraphCache.keyFor(maxEdgeDistance, maxVerticalDelta);
        Map cache = this.paramScoped.computeIfAbsent(key, k -> new HashMap());
        long now = level.m_46467_();
        HashSet<BlockPos> candidateSet = new HashSet<BlockPos>();
        for (NodeIndex.Node n : candidates) {
            candidateSet.add(BlockPos.m_274446_((Position)n.pos));
        }
        HashMap<NodeIndex.Node, List<NodeIndex.Node>> result = new HashMap<NodeIndex.Node, List<NodeIndex.Node>>();
        for (NodeIndex.Node n : candidates) {
            BlockPos np = BlockPos.m_274446_((Position)n.pos);
            CachedNeighbors cn = (CachedNeighbors)cache.get(np);
            if (cn == null || now - cn.tick > (long)ttlTicks) {
                ArrayList<NodeIndex.Node> near = new ArrayList<NodeIndex.Node>();
                for (NodeIndex.Node m : candidates) {
                    if (n == m || Math.abs(m.pos.f_82480_ - n.pos.f_82480_) > (double)maxVerticalDelta || n.pos.m_82557_(m.pos) > maxEdgeDistance * maxEdgeDistance || !VisibilityGraphCache.hasClearLos(level, context, n.pos, m.pos)) continue;
                    near.add(m);
                }
                cn = new CachedNeighbors(near, now);
                cache.put(np, cn);
            }
            ArrayList<NodeIndex.Node> filtered = new ArrayList<NodeIndex.Node>();
            for (NodeIndex.Node m : cn.neighbors) {
                if (!candidateSet.contains(BlockPos.m_274446_((Position)m.pos))) continue;
                filtered.add(m);
            }
            result.put(n, filtered);
        }
        return result;
    }

    private static String keyFor(double maxEdgeDistance, int maxVerticalDelta) {
        return String.format("d=%.3f|v=%d", maxEdgeDistance, maxVerticalDelta);
    }

    private static boolean hasClearLos(Level level, Entity entity, Vec3 a, Vec3 b) {
        ClipContext ctx = new ClipContext(a, b, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
        BlockHitResult hit = level.m_45547_(ctx);
        return hit.m_6662_() == HitResult.Type.MISS;
    }

    private static final class CachedNeighbors {
        final List<NodeIndex.Node> neighbors;
        final long tick;

        CachedNeighbors(List<NodeIndex.Node> neighbors, long tick) {
            this.neighbors = neighbors;
            this.tick = tick;
        }
    }
}

