/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.worker;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;

public final class WorkerScheduler {
    private static final BlockingQueue<GroupComputeResult> GROUP_RESULTS = new LinkedBlockingQueue<GroupComputeResult>();
    private static final BlockingQueue<SoundScoreResult> SOUND_RESULTS = new LinkedBlockingQueue<SoundScoreResult>();
    private static volatile ExecutorService EXECUTOR;
    private static final AtomicBoolean INIT;

    private WorkerScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureInit() {
        if (INIT.get()) {
            return;
        }
        Class<WorkerScheduler> clazz = WorkerScheduler.class;
        synchronized (WorkerScheduler.class) {
            if (INIT.get()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            int threads = 2;
            try {
                Integer configured = (Integer)SoundAttractConfig.COMMON.workerThreads.get();
                if (configured != null) {
                    threads = Math.max(1, configured);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            EXECUTOR = new ThreadPoolExecutor(threads, threads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), r -> {
                Thread t = new Thread(r, "SoundAttract-Worker");
                t.setDaemon(true);
                return t;
            }, (r, executor) -> {
                new ThreadPoolExecutor.DiscardOldestPolicy().rejectedExecution(r, executor);
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.warn("[WorkerScheduler] Task dropped due to saturation (DiscardOldestPolicy)");
                }
            });
            INIT.set(true);
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[WorkerScheduler] Initialized with {} threads", (Object)threads);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Future<?> submitGroupCompute(List<MobSnapshot> mobs, ConfigSnapshot cfg, ResourceLocation dimension) {
        WorkerScheduler.ensureInit();
        long computedDeadline = System.currentTimeMillis() + 10L;
        try {
            Integer budget = (Integer)SoundAttractConfig.COMMON.workerTaskBudgetMs.get();
            if (budget != null) {
                long cfgBudget = budget.longValue();
                computedDeadline = System.currentTimeMillis() + Math.max(5L, cfgBudget);
            }
        }
        catch (Throwable budget) {
            // empty catch block
        }
        long deadlineMs = computedDeadline;
        return EXECUTOR.submit(() -> {
            block3: {
                try {
                    GroupComputeResult result = WorkerScheduler.computeGroups(mobs, cfg, deadlineMs, dimension);
                    if (result != null) {
                        GROUP_RESULTS.offer(result);
                    }
                }
                catch (Throwable t) {
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block3;
                    SoundAttractMod.LOGGER.error("[WorkerScheduler] Group compute failed", t);
                }
            }
        });
    }

    public static List<GroupComputeResult> drainGroupResults() {
        ArrayList<GroupComputeResult> list = new ArrayList<GroupComputeResult>();
        GROUP_RESULTS.drainTo(list);
        return list;
    }

    public static Future<?> submitSoundScore(List<SoundScoreRequest> batch) {
        if (batch == null || batch.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        WorkerScheduler.ensureInit();
        long computedDeadline = System.currentTimeMillis() + 10L;
        try {
            Integer budget = (Integer)SoundAttractConfig.COMMON.workerTaskBudgetMs.get();
            if (budget != null) {
                long cfgBudget = budget.longValue();
                computedDeadline = System.currentTimeMillis() + Math.max(5L, cfgBudget);
            }
        }
        catch (Throwable budget) {
            // empty catch block
        }
        long deadlineMs = computedDeadline;
        return EXECUTOR.submit(() -> {
            block2: {
                try {
                    WorkerScheduler.computeSoundScores(batch, deadlineMs);
                }
                catch (Throwable t) {
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block2;
                    SoundAttractMod.LOGGER.error("[WorkerScheduler] Sound scoring failed", t);
                }
            }
        });
    }

    public static List<SoundScoreResult> drainSoundScoreResults() {
        ArrayList<SoundScoreResult> list = new ArrayList<SoundScoreResult>();
        SOUND_RESULTS.drainTo(list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static GroupComputeResult computeGroups(List<MobSnapshot> mobs, ConfigSnapshot cfg, long deadlineMs, ResourceLocation dimension) {
        double dz;
        double dx;
        if (mobs == null || mobs.isEmpty()) {
            return null;
        }
        ArrayList<MobSnapshot> candidates = new ArrayList<MobSnapshot>();
        for (MobSnapshot m : mobs) {
            if (!m.alive()) continue;
            candidates.add(m);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        candidates.sort(Comparator.comparingDouble(MobSnapshot::health).reversed());
        ArrayList<MobSnapshot> leaders = new ArrayList<MobSnapshot>();
        HashMap<UUID, UUID> mobToLeader = new HashMap<UUID, UUID>();
        double groupRadius = cfg.leaderGroupRadius();
        double leaderSpacing = groupRadius * cfg.leaderSpacingMultiplier();
        int maxLeaders = cfg.maxLeaders();
        int maxGroupSize = cfg.maxGroupSize();
        int sectors = cfg.numEdgeSectors();
        int perSector = cfg.edgeMobsPerSector();
        for (MobSnapshot mobSnapshot : candidates) {
            if (leaders.size() >= maxLeaders) break;
            boolean bl = false;
            for (MobSnapshot mobSnapshot2 : leaders) {
                double dz2;
                double dx2 = mobSnapshot.x() - mobSnapshot2.x();
                double dist2 = dx2 * dx2 + (dz2 = mobSnapshot.z() - mobSnapshot2.z()) * dz2;
                if (!(dist2 < leaderSpacing * leaderSpacing)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                leaders.add(mobSnapshot);
            }
            if (System.currentTimeMillis() <= deadlineMs) continue;
            break;
        }
        if (leaders.isEmpty()) {
            leaders.add((MobSnapshot)candidates.get(0));
        }
        HashMap<UUID, List<UUID>> leaderToGroup = new HashMap<UUID, List<UUID>>();
        for (MobSnapshot mobSnapshot : leaders) {
            leaderToGroup.put(mobSnapshot.uuid(), new ArrayList<UUID>(Collections.singletonList(mobSnapshot.uuid())));
        }
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (MobSnapshot mobSnapshot : candidates) {
            void var20_30;
            if (leaders.contains(mobSnapshot)) {
                hashSet.add(mobSnapshot.uuid());
                mobToLeader.put(mobSnapshot.uuid(), mobSnapshot.uuid());
                continue;
            }
            Object var20_29 = null;
            double bestDist = Double.MAX_VALUE;
            for (MobSnapshot mobSnapshot3 : leaders) {
                double dist;
                List group = (List)leaderToGroup.get(mobSnapshot3.uuid());
                if (group.size() >= maxGroupSize || !((dist = Math.hypot(dx = mobSnapshot.x() - mobSnapshot3.x(), dz = mobSnapshot.z() - mobSnapshot3.z())) <= groupRadius) || !(dist < bestDist)) continue;
                bestDist = dist;
                MobSnapshot mobSnapshot4 = mobSnapshot3;
            }
            if (var20_30 != null) {
                ((List)leaderToGroup.get(var20_30.uuid())).add(mobSnapshot.uuid());
                mobToLeader.put(mobSnapshot.uuid(), var20_30.uuid());
                hashSet.add(mobSnapshot.uuid());
            }
            if (System.currentTimeMillis() <= deadlineMs) continue;
            break;
        }
        HashMap<UUID, Set<UUID>> hashMap = new HashMap<UUID, Set<UUID>>();
        for (MobSnapshot mobSnapshot : leaders) {
            List group = leaderToGroup.getOrDefault(mobSnapshot.uuid(), Collections.emptyList());
            HashMap<Integer, List> sectorLists = new HashMap<Integer, List>();
            for (UUID uUID : group) {
                MobSnapshot m;
                if (uUID.equals(mobSnapshot.uuid()) || (m = WorkerScheduler.find(mobs, uUID)) == null) continue;
                dx = m.x() - mobSnapshot.x();
                dz = m.z() - mobSnapshot.z();
                double angle = Math.atan2(dz, dx);
                int sector = (int)Math.floor((angle + Math.PI) / (Math.PI * 2) * (double)sectors) % sectors;
                sectorLists.computeIfAbsent(sector, k -> new ArrayList()).add(uUID);
            }
            HashSet<Object> edge = new HashSet<Object>();
            for (Map.Entry e : sectorLists.entrySet()) {
                List ids = (List)e.getValue();
                ids.sort((a, b) -> {
                    MobSnapshot ma = WorkerScheduler.find(mobs, a);
                    MobSnapshot mb = WorkerScheduler.find(mobs, b);
                    double da = ma == null ? 0.0 : WorkerScheduler.distance(ma, leader);
                    double db = mb == null ? 0.0 : WorkerScheduler.distance(mb, leader);
                    return Double.compare(db, da);
                });
                int count = Math.min(perSector, ids.size());
                for (int i = 0; i < count; ++i) {
                    edge.add((UUID)ids.get(i));
                }
            }
            if (edge.isEmpty() && group.size() > 1) {
                void var24_51;
                Object var24_50 = null;
                double best = -1.0;
                for (UUID id : group) {
                    double d;
                    MobSnapshot m;
                    if (id.equals(mobSnapshot.uuid()) || (m = WorkerScheduler.find(mobs, id)) == null || !((d = WorkerScheduler.distance(m, mobSnapshot)) > best)) continue;
                    best = d;
                    UUID uUID = id;
                }
                if (var24_51 != null) {
                    edge.add(var24_51);
                }
            }
            hashMap.put(mobSnapshot.uuid(), edge);
            if (System.currentTimeMillis() <= deadlineMs) continue;
            break;
        }
        HashSet<UUID> hashSet2 = new HashSet<UUID>();
        for (MobSnapshot m : candidates) {
            if (hashSet.contains(m.uuid())) continue;
            hashSet2.add(m.uuid());
        }
        return new GroupComputeResult(dimension, mobToLeader, hashMap, hashSet2);
    }

    private static void computeSoundScores(List<SoundScoreRequest> batch, long deadlineMs) {
        for (SoundScoreRequest req : batch) {
            if (System.currentTimeMillis() > deadlineMs) break;
            if (req == null || req.candidates == null || req.candidates.isEmpty()) {
                SOUND_RESULTS.offer(new SoundScoreResult(req == null ? null : req.mobUuid, null, 0.0));
                continue;
            }
            Double currentScore = null;
            if (req.currentTargetSoundId != null) {
                for (SoundCandidate c : req.candidates) {
                    if (!req.currentTargetSoundId.equals(c.soundId)) continue;
                    currentScore = WorkerScheduler.scoreCandidate(req, c);
                    break;
                }
            }
            String bestId = null;
            double bestScore = Double.NEGATIVE_INFINITY;
            for (SoundCandidate c : req.candidates) {
                double s = WorkerScheduler.scoreCandidate(req, c);
                if (s > bestScore) {
                    bestScore = s;
                    bestId = c.soundId;
                }
                if (System.currentTimeMillis() <= deadlineMs) continue;
                break;
            }
            if (currentScore != null && req.currentTargetSoundId != null && bestId != null && !req.currentTargetSoundId.equals(bestId) && bestScore < currentScore * req.switchRatio) {
                bestId = req.currentTargetSoundId;
                bestScore = currentScore;
            }
            SOUND_RESULTS.offer(new SoundScoreResult(req.mobUuid, bestId, bestScore == Double.NEGATIVE_INFINITY ? 0.0 : bestScore));
        }
    }

    private static double scoreCandidate(SoundScoreRequest req, SoundCandidate c) {
        double effectiveRange;
        double dx = req.mobX - c.x;
        double dz = req.mobZ - c.z;
        double dist = Math.hypot(dx, dz);
        if (dist > (effectiveRange = Math.max(1.0E-4, c.range))) {
            return Double.NEGATIVE_INFINITY;
        }
        double proximity = Math.max(0.0, 1.0 - dist / effectiveRange);
        double muffling = c.mufflingFactor;
        if (muffling < 0.0) {
            muffling = 0.0;
        } else if (muffling > 1.0) {
            muffling = 1.0;
        }
        double score = c.weight * proximity * (0.5 + 0.5 * muffling);
        long ageTicks = Math.max(0L, req.gameTime - c.gameTime);
        if (ageTicks <= (long)req.noveltyTicks) {
            score += req.noveltyBonus;
        }
        return score;
    }

    private static double distance(MobSnapshot a, MobSnapshot b) {
        double dx = a.x() - b.x();
        double dz = a.z() - b.z();
        return Math.hypot(dx, dz);
    }

    private static MobSnapshot find(List<MobSnapshot> list, UUID id) {
        for (MobSnapshot m : list) {
            if (!m.uuid().equals(id)) continue;
            return m;
        }
        return null;
    }

    static {
        INIT = new AtomicBoolean(false);
    }

    public record ConfigSnapshot(double leaderGroupRadius, int maxLeaders, int maxGroupSize, double leaderSpacingMultiplier, int numEdgeSectors, int edgeMobsPerSector) {
    }

    public record MobSnapshot(UUID uuid, double x, double y, double z, double health, boolean alive) {
    }

    public record GroupComputeResult(ResourceLocation dimension, Map<UUID, UUID> mobUuidToLeaderUuid, Map<UUID, Set<UUID>> edgeMobsByLeaderUuid, Set<UUID> deserterUuids) {
    }

    public static final class SoundScoreRequest {
        public final UUID mobUuid;
        public final double mobX;
        public final double mobY;
        public final double mobZ;
        public final long gameTime;
        public final String currentTargetSoundId;
        public final List<SoundCandidate> candidates;
        public final double switchRatio;
        public final double noveltyBonus;
        public final int noveltyTicks;

        public SoundScoreRequest(UUID mobUuid, double mobX, double mobY, double mobZ, long gameTime, String currentTargetSoundId, List<SoundCandidate> candidates, double switchRatio, double noveltyBonus, int noveltyTicks) {
            this.mobUuid = mobUuid;
            this.mobX = mobX;
            this.mobY = mobY;
            this.mobZ = mobZ;
            this.gameTime = gameTime;
            this.currentTargetSoundId = currentTargetSoundId;
            this.candidates = candidates == null ? Collections.emptyList() : candidates;
            this.switchRatio = switchRatio;
            this.noveltyBonus = noveltyBonus;
            this.noveltyTicks = noveltyTicks;
        }
    }

    public record SoundScoreResult(UUID mobUuid, String soundId, double score) {
    }

    public static final class SoundCandidate {
        public final String soundId;
        public final double x;
        public final double y;
        public final double z;
        public final long gameTime;
        public final double range;
        public final double weight;
        public final double mufflingFactor;

        public SoundCandidate(String soundId, double x, double y, double z, long gameTime, double range, double weight, double mufflingFactor) {
            this.soundId = soundId;
            this.x = x;
            this.y = y;
            this.z = z;
            this.gameTime = gameTime;
            this.range = range;
            this.weight = weight;
            this.mufflingFactor = mufflingFactor;
        }
    }
}

