/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.labels;

import com.google.common.math.DoubleMath;
import java.util.function.Predicate;
import net.mehvahdjukaar.labels.LabelsMod;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Byte> DATA_DYE_COLOR = SynchedEntityData.defineId(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> DATA_GLOWING = SynchedEntityData.defineId(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_TEXT = SynchedEntityData.defineId(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private AttachFace attachFace = null;
    private Direction direction = null;
    private int checkInterval;
    private boolean needsVisualRefresh = true;
    @Nullable
    private ResourceLocation textureId;
    private float scale;
    private FormattedCharSequence[] labelText;
    protected static final Predicate<Entity> HANGING_ENTITY = entity -> entity instanceof HangingEntity || entity instanceof LabelEntity;

    public LabelEntity(EntityType<? extends LabelEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static LabelEntity placeOnFace(Level level, Vec3 hitVec, Direction clickedFace, Direction horizontalFacing) {
        LabelEntity lab = new LabelEntity(LabelsMod.LABEL.get(), level);
        if (clickedFace.getAxis().isHorizontal()) {
            lab.setOrientation(clickedFace, AttachFace.WALL);
        } else {
            lab.setOrientation(horizontalFacing.getOpposite(), clickedFace == Direction.UP ? AttachFace.FLOOR : AttachFace.CEILING);
        }
        float offset = (float)lab.getThickness() / 32.0f;
        Vec3 step = new Vec3(clickedFace.step());
        Vec3 stepSQ = step.multiply(step);
        Vec3 invStep = new Vec3(1.0, 1.0, 1.0).subtract(stepSQ);
        BlockPos pos = BlockPos.containing((Position)hitVec);
        Vec3 newPos = pos.getCenter().multiply(invStep).add(stepSQ.multiply(hitVec.add(step.scale((double)offset))));
        lab.setPos(newPos.x, newPos.y, newPos.z);
        return lab;
    }

    public BlockPos calculateBehindPos() {
        return BlockPos.containing((Position)this.position().relative(this.getBehindDirection(), 0.0625));
    }

    private Direction getBehindDirection() {
        return switch (this.attachFace) {
            default -> throw new MatchException(null, null);
            case AttachFace.WALL -> this.direction.getOpposite();
            case AttachFace.FLOOR -> Direction.DOWN;
            case AttachFace.CEILING -> Direction.UP;
        };
    }

    public void setOrientation(@NotNull Direction horizontalOrientation, @NotNull AttachFace face) {
        this.attachFace = face;
        this.direction = horizontalOrientation;
        if (face != AttachFace.WALL) {
            this.setXRot(90.0f * (float)(face == AttachFace.FLOOR ? -1 : 1));
            this.xRotO = this.getXRot();
        }
        this.setYRot(horizontalOrientation.get2DDataValue() * 90);
        this.yRotO = this.getYRot();
    }

    public Direction getDirection() {
        return this.direction;
    }

    protected AABB makeBoundingBox() {
        BlockPos supportPos;
        if (this.attachFace == null || this.direction == null) {
            return super.makeBoundingBox();
        }
        Level level = this.level();
        BlockState support = level.getBlockState(supportPos = this.calculateBehindPos());
        VoxelShape shape = support.getBlockSupportShape((BlockGetter)level, supportPos);
        if (shape.isEmpty()) {
            return super.makeBoundingBox();
        }
        Direction dir = this.getBehindDirection();
        double offset = dir.getAxisDirection() != Direction.AxisDirection.POSITIVE ? 0.5 - shape.max(dir.getAxis()) : -0.5 + shape.min(dir.getAxis());
        Vec3 v = Vec3.atCenterOf((Vec3i)supportPos);
        offset -= (double)((float)this.getThickness() / 32.0f);
        if (dir.getAxis() != Direction.Axis.Y && support.is(LabelsMod.LOWERS_LABELS)) {
            v = v.add(0.0, -0.125, 0.0);
        }
        v = v.add((double)dir.getStepX() * offset, (double)dir.getStepY() * offset, (double)dir.getStepZ() * offset);
        this.setPosRaw(v.x, v.y, v.z);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double width = this.getWidth();
        double height = this.getHeight();
        double zWidth = this.getWidth();
        double thickness = this.getThickness();
        Direction.Axis axis = dir.getAxis();
        switch (axis) {
            case X: {
                width = thickness;
                break;
            }
            case Y: {
                height = thickness;
                break;
            }
            case Z: {
                zWidth = thickness;
            }
        }
        return new AABB(x - (width /= 32.0), y - (height /= 32.0), z - (zWidth /= 32.0), x + width, y + height, z + zWidth);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity, (this.direction.get2DDataValue() & 0xFF) << 8 | this.attachFace.ordinal() & 0xFF);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        int i = packet.getData();
        Direction direction = Direction.from2DDataValue((int)((i & 0xFF00) >> 8));
        AttachFace attachFace = AttachFace.values()[i & 0xFF];
        this.setOrientation(direction, attachFace);
        super.recreateFromPacket(packet);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        ItemStack item = this.getItem();
        if (!item.isEmpty()) {
            tag.put("Item", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
        }
        tag.putByte("Facing", (byte)this.direction.get2DDataValue());
        tag.putByte("AttachFace", (byte)this.attachFace.ordinal());
        tag.putBoolean("Glowing", this.hasGlowInk());
        tag.putBoolean("Text", this.hasText());
        DyeColor c = this.getColor();
        if (c != null) {
            tag.putByte("DyeColor", (byte)c.ordinal());
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        ItemStack itemStack;
        if (tag.contains("Item", 10)) {
            CompoundTag compoundTag = tag.getCompound("Item");
            itemStack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag).orElse(ItemStack.EMPTY);
        } else {
            itemStack = ItemStack.EMPTY;
        }
        this.setItem(itemStack);
        this.setOrientation(Direction.from2DDataValue((int)tag.getByte("Facing")), AttachFace.values()[tag.getByte("AttachFace")]);
        this.setHasGlowInk(tag.getBoolean("Glowing"));
        this.setHasText(tag.getBoolean("Text"));
        if (tag.contains("DyeColor")) {
            this.getEntityData().set(DATA_DYE_COLOR, (Object)tag.getByte("DyeColor"));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DATA_DYE_COLOR, (Object)-1);
        builder.define(DATA_GLOWING, (Object)false);
        builder.define(DATA_TEXT, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (this.level().isClientSide) {
            if (pKey.equals(DATA_ITEM)) {
                ItemStack itemstack = this.getItem();
                if (!itemstack.isEmpty() && itemstack.getEntityRepresentation() != this) {
                    itemstack.setEntityRepresentation((Entity)this);
                }
                this.recomputeTexture(itemstack);
                this.needsVisualRefresh = true;
            } else if (pKey.equals(DATA_DYE_COLOR)) {
                this.recomputeTexture(this.getItem());
            }
        }
    }

    public int getWidth() {
        return 8;
    }

    public int getHeight() {
        return 10;
    }

    public int getThickness() {
        return 1;
    }

    public void dropItem(@Nullable Entity entity) {
        block2: {
            block3: {
                if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) break block2;
                this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
                if (!(entity instanceof Player)) break block3;
                Player player = (Player)entity;
                if (player.getAbilities().instabuild) break block2;
            }
            this.spawnAtLocation((ItemLike)LabelsMod.LABEL_ITEM.get());
        }
    }

    public void tick() {
        if (!this.level().isClientSide) {
            this.checkBelowWorld();
            if (this.checkInterval++ == 100) {
                this.checkInterval = 0;
                if (!this.isRemoved() && !this.survives()) {
                    this.discard();
                    this.dropItem(null);
                }
            }
        }
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.ITEM_FRAME_PLACE, 1.0f, 1.0f);
    }

    public void setItem(ItemStack stack) {
        if (!stack.isEmpty()) {
            stack = stack.copy();
            stack.setCount(1);
            stack.setEntityRepresentation((Entity)this);
        }
        this.getEntityData().set(DATA_ITEM, (Object)stack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM);
    }

    private void recomputeTexture(ItemStack itemstack) {
        Object s = Utils.getID((Item)itemstack.getItem()).toString().replace(":", "/");
        DyeColor color = this.getColor();
        if (color != null) {
            s = (String)s + "_" + color.getName();
        }
        this.textureId = LabelsMod.res((String)s);
    }

    public boolean isCurrentlyGlowing() {
        return false;
    }

    @Nullable
    public ItemStack getPickResult() {
        return LabelsMod.LABEL_ITEM.get().getDefaultInstance();
    }

    public boolean survives() {
        Level level = this.level();
        if (!level.noCollision((Entity)this)) {
            return false;
        }
        BlockPos supportingPos = this.calculateBehindPos();
        Direction behindDIr = this.getBehindDirection();
        BlockState state = level.getBlockState(supportingPos);
        VoxelShape blockShape = state.getBlockSupportShape((BlockGetter)level, supportingPos);
        if (blockShape.isEmpty() || !state.isSolid()) {
            return false;
        }
        AABB bbShape = this.getBoundingBox();
        blockShape = blockShape.move((double)supportingPos.getX(), (double)supportingPos.getY(), (double)supportingPos.getZ());
        if (behindDIr.getAxisDirection() == Direction.AxisDirection.POSITIVE ? !DoubleMath.fuzzyEquals((double)bbShape.max(behindDIr.getAxis()), (double)blockShape.min(behindDIr.getAxis()), (double)1.0E-7) : !DoubleMath.fuzzyEquals((double)bbShape.min(behindDIr.getAxis()), (double)blockShape.max(behindDIr.getAxis()), (double)1.0E-7)) {
            return false;
        }
        return level.getEntities((Entity)this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    public boolean isPickable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !this.level().mayInteract(player, this.getOnPos()) ? true : this.hurt(this.damageSources().playerAttack(player), 0.0f);
        }
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.isRemoved() && !this.level().isClientSide) {
            this.kill();
            this.markHurt();
            this.dropItem(source.getEntity());
        }
        return true;
    }

    public void move(MoverType type, Vec3 pos) {
        if (!this.level().isClientSide && !this.isRemoved() && pos.lengthSqr() > 0.0) {
            this.kill();
            this.dropItem(null);
        }
    }

    public void push(double x, double y, double z) {
        if (!this.level().isClientSide && !this.isRemoved() && x * x + y * y + z * z > 0.0) {
            this.kill();
            this.dropItem(null);
        }
    }

    public ItemEntity spawnAtLocation(ItemStack stack, float offsetY) {
        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX() + (double)((float)this.direction.getStepX() * 0.15f), this.getY() + (double)offsetY, this.getZ() + (double)((float)this.direction.getStepZ() * 0.15f), stack);
        itemEntity.setDefaultPickUpDelay();
        this.level().addFreshEntity((Entity)itemEntity);
        return itemEntity;
    }

    protected boolean repositionEntityAfterLoad() {
        return true;
    }

    public float rotate(Rotation transformRotation) {
        if (this.direction.getAxis() != Direction.Axis.Y) {
            switch (transformRotation) {
                case CLOCKWISE_180: {
                    this.direction = this.direction.getOpposite();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.direction = this.direction.getCounterClockWise();
                    break;
                }
                case CLOCKWISE_90: {
                    this.direction = this.direction.getClockWise();
                }
            }
        }
        float f = Mth.wrapDegrees((float)this.getYRot());
        switch (transformRotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 90.0f;
            }
            case CLOCKWISE_90: {
                return f + 270.0f;
            }
        }
        return f;
    }

    public float mirror(Mirror transformMirror) {
        return this.rotate(transformMirror.getRotation(this.direction));
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
    }

    public void refreshDimensions() {
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ServerPlayer color;
        if (this.isRemoved()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        Level level = this.level();
        if (player.isSecondaryUseActive() && !itemstack.isEmpty()) {
            if (!level.isClientSide) {
                this.setItem(itemstack);
                if (!itemstack.isEmpty()) {
                    this.playSound(SoundEvents.INK_SAC_USE, 1.0f, 1.0f);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        boolean consume = true;
        boolean success = false;
        boolean glowInk = this.hasGlowInk();
        if (itemstack.getItem() == Items.FEATHER) {
            this.cycleText();
            consume = false;
            success = true;
        } else if (itemstack.getItem() == Items.GLOW_INK_SAC && !glowInk) {
            level.playSound(null, (Entity)this, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setHasGlowInk(true);
            success = true;
        } else if (itemstack.getItem() == Items.INK_SAC && glowInk) {
            level.playSound(null, (Entity)this, SoundEvents.INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setHasGlowInk(false);
            success = true;
        } else if (ForgeHelper.getColor((ItemStack)itemstack) != null) {
            level.playSound(null, (Entity)this, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            color = ForgeHelper.getColor((ItemStack)itemstack);
            this.setColor((DyeColor)color);
            this.recomputeTexture(this.getItem());
            success = true;
        }
        if (success) {
            if (consume && !player.isCreative()) {
                itemstack.shrink(1);
            }
            if (player instanceof ServerPlayer) {
                color = (ServerPlayer)player;
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockPos p = this.calculateBehindPos();
            InteractionResult interactionresult = sp.gameMode.useItemOn(sp, level, itemstack, hand, new BlockHitResult(Vec3.atCenterOf((Vec3i)p), this.direction, p, false));
            return interactionresult;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean needsVisualUpdate() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public void setLabelText(FormattedCharSequence[] tempPageLines) {
        this.labelText = tempPageLines;
    }

    public void setLabelTextScale(float scale) {
        this.scale = scale;
    }

    public float getLabelTextScale() {
        return this.scale;
    }

    public FormattedCharSequence[] getLabelText() {
        return this.labelText;
    }

    @Nullable
    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public boolean hasGlowInk() {
        return (Boolean)this.getEntityData().get(DATA_GLOWING);
    }

    public boolean hasText() {
        return (Boolean)this.getEntityData().get(DATA_TEXT);
    }

    private void setHasGlowInk(boolean glowing) {
        this.getEntityData().set(DATA_GLOWING, (Object)glowing);
    }

    private void setHasText(boolean text) {
        this.getEntityData().set(DATA_TEXT, (Object)text);
    }

    private void cycleText() {
        this.getEntityData().set(DATA_TEXT, (Object)((Boolean)this.getEntityData().get(DATA_TEXT) == false ? 1 : 0));
    }

    @Nullable
    public DyeColor getColor() {
        byte i = (Byte)this.getEntityData().get(DATA_DYE_COLOR);
        return i == -1 ? null : DyeColor.byId((int)i);
    }

    private void setColor(@Nullable DyeColor color) {
        this.getEntityData().set(DATA_DYE_COLOR, (Object)((byte)(color == null ? -1 : color.ordinal())));
    }
}

