/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.labels;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import net.mehvahdjukaar.labels.ClientConfigs;
import net.mehvahdjukaar.labels.ColorManager;
import net.mehvahdjukaar.labels.LabelEntity;
import net.mehvahdjukaar.labels.LabelsMod;
import net.mehvahdjukaar.labels.LabelsModClient;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class LabelEntityRenderer
extends EntityRenderer<LabelEntity> {
    private final ModelBlockRenderer modelRenderer;
    private final ModelManager modelManager;
    private final Camera camera;

    public LabelEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        Minecraft minecraft = Minecraft.getInstance();
        this.modelRenderer = minecraft.getBlockRenderer().getModelRenderer();
        this.modelManager = minecraft.getBlockRenderer().getBlockModelShaper().getModelManager();
        this.camera = minecraft.gameRenderer.getMainCamera();
    }

    public void render(LabelEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        FrameBufferBackedDynamicTexture tex;
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, light);
        if (this.entityRenderDispatcher.shouldRenderHitBoxes()) {
            BlockPos behind = entity.calculateBehindPos();
            VertexConsumer lines = buffer.getBuffer(RenderType.lines());
            poseStack.pushPose();
            Vec3 ep = entity.position();
            Vec3 vec3 = new Vec3((double)behind.getX() - ep.x, (double)behind.getY() - ep.y, (double)behind.getZ() - ep.z);
            AABB bb = new AABB(vec3, vec3.add(1.0, 1.0, 1.0)).inflate(0.01);
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)lines, (AABB)bb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entity.getYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees(-entity.getXRot()));
        poseStack.translate(0.0, 0.0, -0.46875);
        poseStack.translate(-0.5, -0.5, -0.5);
        this.modelRenderer.renderModel(poseStack.last(), buffer.getBuffer(Sheets.cutoutBlockSheet()), null, ClientHelper.getModel((ModelManager)this.modelManager, (ModelResourceLocation)LabelsModClient.LABEL_MODEL), 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
        Item item = entity.getItem().getItem();
        ResourceLocation id = entity.getTextureId();
        if (item != Items.AIR && id != null && (tex = RenderedTexturesManager.requestFlatItemTexture((ResourceLocation)id, (Item)item, (int)ClientConfigs.TEXTURE_SIZE.get(), i -> {
            try {
                LabelEntityRenderer.postProcess(i, entity.getColor());
            }
            catch (Exception e) {
                LabelsMod.LOGGER.warn("Failed to correctly create label image for {}:", i, (Object)e);
            }
        })).isInitialized()) {
            boolean hasText = entity.hasText();
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)tex.getTextureLocation()));
            PoseStack.Pose pose = poseStack.last();
            int overlay = OverlayTexture.NO_OVERLAY;
            float z = 0.9875f;
            float s = hasText ? 0.1875f : 0.25f;
            poseStack.translate(0.5, hasText ? 0.575 : 0.5, (double)z);
            poseStack.pushPose();
            boolean glow = entity.hasGlowInk();
            if (glow) {
                light = 0xF000F0;
            }
            vertexConsumer.addVertex(pose, -s, -s, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
            vertexConsumer.addVertex(pose, -s, s, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
            vertexConsumer.addVertex(pose, s, s, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
            vertexConsumer.addVertex(pose, s, -s, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setOverlay(overlay).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
            poseStack.popPose();
            if (hasText) {
                this.drawLabelText(poseStack, buffer, entity, entity.getItem().getHoverName(), glow, light);
            }
        }
        poseStack.popPose();
    }

    private static void postProcess(NativeImage image, @Nullable DyeColor tint) {
        TextureImage outlineTexture;
        boolean outline;
        boolean reduceColors = ClientConfigs.REDUCE_COLORS.get();
        boolean recolor = ClientConfigs.IS_RECOLORED.get();
        boolean bl = outline = ClientConfigs.OUTLINE.get() != false && recolor;
        if (recolor || reduceColors) {
            SpriteUtils.mergeSimilarColors((NativeImage)image, (float)0.015f);
        }
        if (recolor) {
            SpriteUtils.grayscaleImage((NativeImage)image);
        }
        TextureImage originalTexture = TextureImage.of((NativeImage)image, (McMetaFile)null);
        if (outline) {
            ArrayList outlinePosition = new ArrayList();
            outlineTexture = originalTexture.makeCopy();
            SpriteUtils.forEachPixel((NativeImage)outlineTexture.getImage(), (x, y) -> {
                int c = outlineTexture.getImage().getPixelRGBA(x.intValue(), y.intValue());
                if (new RGBColor(c).alpha() != 0.0f && (x == 0 || new RGBColor(image.getPixelRGBA(x - 1, y.intValue())).alpha() == 0.0f || x == image.getWidth() - 1 || new RGBColor(image.getPixelRGBA(x + 1, y.intValue())).alpha() == 0.0f || y == 0 || new RGBColor(image.getPixelRGBA(x.intValue(), y - 1)).alpha() == 0.0f || y == image.getHeight() - 1 || new RGBColor(image.getPixelRGBA(x.intValue(), y + 1)).alpha() == 0.0f)) {
                    outlinePosition.add(Pair.of((Object)x, (Object)y));
                }
            });
            SpriteUtils.forEachPixel((NativeImage)outlineTexture.getImage(), (x, y) -> {
                if (!outlinePosition.contains(Pair.of((Object)x, (Object)y))) {
                    outlineTexture.getImage().setPixelRGBA(x.intValue(), y.intValue(), 0);
                } else {
                    originalTexture.getImage().setPixelRGBA(x.intValue(), y.intValue(), 0);
                }
            });
        } else {
            outlineTexture = null;
        }
        if (reduceColors) {
            int cutoff = 11;
            IntUnaryOperator fn = i -> {
                if (i < cutoff) {
                    return i;
                }
                return (int)(Math.pow(i - cutoff + 1, 0.3333333432674408) + (double)cutoff - 1.0);
            };
            SpriteUtils.reduceColors((NativeImage)image, (IntUnaryOperator)fn);
            if (outlineTexture != null) {
                int maxOutlineColors = 3;
                try {
                    SpriteUtils.reduceColors((NativeImage)outlineTexture.getImage(), j -> Math.min(j, maxOutlineColors));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (recolor) {
            Palette old;
            int s;
            RGBColor dark = new RGBColor(ColorManager.getDark(tint));
            RGBColor light = new RGBColor(ColorManager.getLight(tint));
            if (ClientConfigs.COLOR_PRESET.get() != ClientConfigs.Preset.DEFAULT) {
                dark = dark.asHCL();
                light = light.asHCL();
            }
            Palette newPalette = (s = (old = Palette.fromImage((TextureImage)originalTexture, null, (float)0.0f)).size()) < 3 ? Palette.ofColors(List.of(light.asRGB(), dark.asRGB())) : Palette.fromArc((BaseColor)light.asRGB(), (BaseColor)dark.asRGB(), (int)(s + (outline ? 2 : 0)));
            if (outline) {
                Palette newOutlinePalette;
                if (newPalette.size() > 4) {
                    newOutlinePalette = Palette.ofColors(List.of(newPalette.remove(0).rgb()));
                    PaletteColor v = newPalette.remove(0);
                    newOutlinePalette.add(v);
                    newOutlinePalette.add(newPalette.getDarkest());
                } else {
                    newOutlinePalette = newPalette.copy();
                    newOutlinePalette.add(newPalette.getDarkest().getDarkened());
                }
                LabelEntityRenderer.fastInPlaceRecolor(outlineTexture.getImage(), Palette.fromImage((TextureImage)outlineTexture), newOutlinePalette);
            }
            LabelEntityRenderer.fastInPlaceRecolor(image, old, newPalette);
        }
        if (outlineTexture != null) {
            originalTexture.applyOverlay(new TextureImage[]{outlineTexture});
            outlineTexture.close();
        }
    }

    private static void fastInPlaceRecolor(NativeImage image, Palette old, Palette newPalette) {
        assert (old.size() <= newPalette.size()) : "Palettes must have same size";
        SpriteUtils.forEachPixel((NativeImage)image, (x, y) -> {
            int c = image.getPixelRGBA(x.intValue(), y.intValue());
            for (int i = 0; i < old.size(); ++i) {
                if (((PaletteColor)old.getValues().get(i)).value() != c) continue;
                c = ((PaletteColor)newPalette.getValues().get(i)).value();
                image.setPixelRGBA(x.intValue(), y.intValue(), c);
                break;
            }
        });
    }

    private void drawLabelText(PoseStack matrixStack, MultiBufferSource buffer, LabelEntity entity, Component text, boolean glow, int light) {
        DyeColor d;
        matrixStack.scale(-1.0f, 1.0f, -1.0f);
        Font font = Minecraft.getInstance().font;
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.25, 0.0);
        if (entity.needsVisualUpdate()) {
            float paperHeight = 0.100000024f;
            float paperWidth = 0.45f;
            Pair pair = TextUtil.fitLinesToBox((Font)font, (FormattedText)text, (float)paperWidth, (float)paperHeight);
            entity.setLabelText((FormattedCharSequence[])((List)pair.getFirst()).toArray(FormattedCharSequence[]::new));
            entity.setLabelTextScale(((Float)pair.getSecond()).floatValue());
        }
        float scale = entity.getLabelTextScale();
        FormattedCharSequence[] tempPageLines = entity.getLabelText();
        matrixStack.translate(0.0, -0.475, 0.0);
        matrixStack.scale(scale, -scale, scale);
        DyeColor c = DyeColor.BLACK;
        if (ClientConfigs.COLORED_TEXT.get().booleanValue() && (d = entity.getColor()) != null) {
            c = d;
        }
        TextUtil.renderAllLines((FormattedCharSequence[])tempPageLines, (int)10, (Font)font, (PoseStack)matrixStack, (MultiBufferSource)buffer, (TextUtil.RenderProperties)TextUtil.renderProperties((DyeColor)c, (boolean)glow, (float)1.5f, (int)light, (Style)Style.EMPTY, (Vector3f)entity.getDirection().step(), () -> new LOD(this.camera, entity.blockPosition()).isVeryNear()));
        matrixStack.popPose();
    }

    public Vec3 getRenderOffset(LabelEntity entity, float partialTicks) {
        return Vec3.ZERO;
    }

    public ResourceLocation getTextureLocation(LabelEntity labelEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    protected boolean shouldShowName(LabelEntity labelEntity) {
        return false;
    }
}

