/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.labels;

import com.google.common.math.DoubleMath;
import java.util.function.Predicate;
import net.mehvahdjukaar.labels.LabelsMod;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Byte> DATA_DYE_COLOR = SynchedEntityData.m_135353_(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_GLOWING = SynchedEntityData.m_135353_(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_TEXT = SynchedEntityData.m_135353_(LabelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AttachFace attachFace = null;
    private Direction direction = null;
    private int checkInterval;
    private boolean needsVisualRefresh = true;
    @Nullable
    private ResourceLocation textureId;
    private float scale;
    private FormattedCharSequence[] labelText;
    protected static final Predicate<Entity> HANGING_ENTITY = entity -> entity instanceof HangingEntity || entity instanceof LabelEntity;

    public LabelEntity(EntityType<? extends LabelEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static LabelEntity placeOnFace(Level level, Vec3 hitVec, Direction clickedFace, Direction horizontalFacing) {
        LabelEntity lab = new LabelEntity(LabelsMod.LABEL.get(), level);
        if (clickedFace.m_122434_().m_122479_()) {
            lab.setOrientation(clickedFace, AttachFace.WALL);
        } else {
            lab.setOrientation(horizontalFacing.m_122424_(), clickedFace == Direction.UP ? AttachFace.FLOOR : AttachFace.CEILING);
        }
        float offset = (float)lab.getThickness() / 32.0f;
        Vec3 step = new Vec3(clickedFace.m_253071_());
        Vec3 stepSQ = step.m_82559_(step);
        Vec3 invStep = new Vec3(1.0, 1.0, 1.0).m_82546_(stepSQ);
        BlockPos pos = BlockPos.m_274446_((Position)hitVec);
        Vec3 newPos = pos.m_252807_().m_82559_(invStep).m_82549_(stepSQ.m_82559_(hitVec.m_82549_(step.m_82490_((double)offset))));
        lab.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        return lab;
    }

    public BlockPos calculateBehindPos() {
        return BlockPos.m_274446_((Position)this.m_20182_().m_231075_(this.getBehindDirection(), 0.0625));
    }

    private Direction getBehindDirection() {
        return switch (this.attachFace) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.WALL -> this.direction.m_122424_();
            case AttachFace.FLOOR -> Direction.DOWN;
            case AttachFace.CEILING -> Direction.UP;
        };
    }

    public void setOrientation(@NotNull Direction horizontalOrientation, @NotNull AttachFace face) {
        this.attachFace = face;
        this.direction = horizontalOrientation;
        if (face != AttachFace.WALL) {
            this.m_146926_(90.0f * (float)(face == AttachFace.FLOOR ? -1 : 1));
            this.f_19860_ = this.m_146909_();
        }
        this.m_146922_(horizontalOrientation.m_122416_() * 90);
        this.f_19859_ = this.m_146908_();
    }

    public Direction m_6350_() {
        return this.direction;
    }

    protected AABB m_142242_() {
        BlockPos supportPos;
        if (this.attachFace == null || this.direction == null) {
            return super.m_142242_();
        }
        Level level = this.m_9236_();
        BlockState support = level.m_8055_(supportPos = this.calculateBehindPos());
        VoxelShape shape = support.m_60816_((BlockGetter)level, supportPos);
        if (shape.m_83281_()) {
            return super.m_142242_();
        }
        Direction dir = this.getBehindDirection();
        double offset = dir.m_122421_() != Direction.AxisDirection.POSITIVE ? 0.5 - shape.m_83297_(dir.m_122434_()) : -0.5 + shape.m_83288_(dir.m_122434_());
        Vec3 v = Vec3.m_82512_((Vec3i)supportPos);
        offset -= (double)((float)this.getThickness() / 32.0f);
        if (dir.m_122434_() != Direction.Axis.Y && support.m_204336_(LabelsMod.LOWERS_LABELS)) {
            v = v.m_82520_(0.0, -0.125, 0.0);
        }
        v = v.m_82520_((double)dir.m_122429_() * offset, (double)dir.m_122430_() * offset, (double)dir.m_122431_() * offset);
        this.m_20343_(v.f_82479_, v.f_82480_, v.f_82481_);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        double width = this.getWidth();
        double height = this.getHeight();
        double zWidth = this.getWidth();
        double thickness = this.getThickness();
        Direction.Axis axis = dir.m_122434_();
        switch (axis) {
            case X: {
                width = thickness;
                break;
            }
            case Y: {
                height = thickness;
                break;
            }
            case Z: {
                zWidth = thickness;
            }
        }
        return new AABB(x - (width /= 32.0), y - (height /= 32.0), z - (zWidth /= 32.0), x + width, y + height, z + zWidth);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, (this.direction.m_122416_() & 0xFF) << 8 | this.attachFace.ordinal() & 0xFF);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        int i = packet.m_131509_();
        Direction direction = Direction.m_122407_((int)((i & 0xFF00) >> 8));
        AttachFace attachFace = AttachFace.values()[i & 0xFF];
        this.setOrientation(direction, attachFace);
        super.m_141965_(packet);
    }

    public void m_7380_(CompoundTag tag) {
        ItemStack item = this.getItem();
        if (!item.m_41619_()) {
            tag.m_128365_("Item", (Tag)item.m_41739_(new CompoundTag()));
        }
        tag.m_128344_("Facing", (byte)this.direction.m_122416_());
        tag.m_128344_("AttachFace", (byte)this.attachFace.ordinal());
        tag.m_128379_("Glowing", this.hasGlowInk());
        tag.m_128379_("Text", this.hasText());
        DyeColor c = this.getColor();
        if (c != null) {
            tag.m_128344_("DyeColor", (byte)c.ordinal());
        }
    }

    public void m_7378_(CompoundTag tag) {
        CompoundTag compound = tag.m_128469_("Item");
        if (!compound.m_128456_()) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compound);
            if (itemstack.m_41619_()) {
                LabelsMod.LOGGER.warn("Unable to load item from: {}", (Object)compound);
            }
            this.setItem(itemstack);
        }
        this.setOrientation(Direction.m_122407_((int)tag.m_128445_("Facing")), AttachFace.values()[tag.m_128445_("AttachFace")]);
        this.setHasGlowInk(tag.m_128471_("Glowing"));
        this.setHasText(tag.m_128471_("Text"));
        if (tag.m_128441_("DyeColor")) {
            this.m_20088_().m_135381_(DATA_DYE_COLOR, (Object)tag.m_128445_("DyeColor"));
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_DYE_COLOR, (Object)-1);
        this.f_19804_.m_135372_(DATA_GLOWING, (Object)false);
        this.f_19804_.m_135372_(DATA_TEXT, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (this.m_9236_().f_46443_) {
            if (pKey.equals(DATA_ITEM)) {
                ItemStack itemstack = this.getItem();
                if (!itemstack.m_41619_() && itemstack.m_41609_() != this) {
                    itemstack.m_41636_((Entity)this);
                }
                this.recomputeTexture(itemstack);
                this.needsVisualRefresh = true;
            } else if (pKey.equals(DATA_DYE_COLOR)) {
                this.recomputeTexture(this.getItem());
            }
        }
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return 0.0f;
    }

    public int getWidth() {
        return 8;
    }

    public int getHeight() {
        return 10;
    }

    public int getThickness() {
        return 1;
    }

    public void dropItem(@Nullable Entity entity) {
        block2: {
            block3: {
                if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) break block2;
                this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
                if (!(entity instanceof Player)) break block3;
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) break block2;
            }
            this.m_19998_((ItemLike)LabelsMod.LABEL_ITEM.get());
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            this.m_146871_();
            if (this.checkInterval++ == 100) {
                this.checkInterval = 0;
                if (!this.m_213877_() && !this.survives()) {
                    this.m_146870_();
                    this.dropItem(null);
                }
            }
        }
    }

    public void playPlacementSound() {
        this.m_5496_(SoundEvents.f_12015_, 1.0f, 1.0f);
    }

    public void setItem(ItemStack stack) {
        if (!stack.m_41619_()) {
            stack = stack.m_41777_();
            stack.m_41764_(1);
            stack.m_41636_((Entity)this);
        }
        this.m_20088_().m_135381_(DATA_ITEM, (Object)stack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM);
    }

    private void recomputeTexture(ItemStack itemstack) {
        Object s = Utils.getID((Item)itemstack.m_41720_()).toString().replace(":", "/");
        DyeColor color = this.getColor();
        if (color != null) {
            s = (String)s + "_" + color.m_41065_();
        }
        this.textureId = LabelsMod.res((String)s);
    }

    public boolean m_142038_() {
        return false;
    }

    @Nullable
    public ItemStack m_142340_() {
        return LabelsMod.LABEL_ITEM.get().m_7968_();
    }

    public boolean survives() {
        Level level = this.m_9236_();
        if (!level.m_45786_((Entity)this)) {
            return false;
        }
        BlockPos supportingPos = this.calculateBehindPos();
        Direction behindDIr = this.getBehindDirection();
        BlockState state = level.m_8055_(supportingPos);
        VoxelShape blockShape = state.m_60816_((BlockGetter)level, supportingPos);
        if (blockShape.m_83281_() || !state.m_280296_()) {
            return false;
        }
        AABB bbShape = this.m_20191_();
        blockShape = blockShape.m_83216_((double)supportingPos.m_123341_(), (double)supportingPos.m_123342_(), (double)supportingPos.m_123343_());
        if (behindDIr.m_122421_() == Direction.AxisDirection.POSITIVE ? !DoubleMath.fuzzyEquals((double)bbShape.m_82374_(behindDIr.m_122434_()), (double)blockShape.m_83288_(behindDIr.m_122434_()), (double)1.0E-7) : !DoubleMath.fuzzyEquals((double)bbShape.m_82340_(behindDIr.m_122434_()), (double)blockShape.m_83297_(behindDIr.m_122434_()), (double)1.0E-7)) {
            return false;
        }
        return level.m_6249_((Entity)this, this.m_20191_(), HANGING_ENTITY).isEmpty();
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_7313_(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !this.m_9236_().m_7966_(player, this.m_20097_()) ? true : this.m_6469_(this.m_269291_().m_269075_(player), 0.0f);
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_213877_() && !this.m_9236_().f_46443_) {
            this.m_6074_();
            this.m_5834_();
            this.dropItem(source.m_7639_());
        }
        return true;
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_() && pos.m_82556_() > 0.0) {
            this.m_6074_();
            this.dropItem(null);
        }
    }

    public void m_5997_(double x, double y, double z) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_() && x * x + y * y + z * z > 0.0) {
            this.m_6074_();
            this.dropItem(null);
        }
    }

    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_() + (double)((float)this.direction.m_122429_() * 0.15f), this.m_20186_() + (double)offsetY, this.m_20189_() + (double)((float)this.direction.m_122431_() * 0.15f), stack);
        itemEntity.m_32060_();
        this.m_9236_().m_7967_((Entity)itemEntity);
        return itemEntity;
    }

    protected boolean m_6093_() {
        return true;
    }

    public float m_7890_(Rotation transformRotation) {
        if (this.direction.m_122434_() != Direction.Axis.Y) {
            switch (transformRotation) {
                case CLOCKWISE_180: {
                    this.direction = this.direction.m_122424_();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.direction = this.direction.m_122428_();
                    break;
                }
                case CLOCKWISE_90: {
                    this.direction = this.direction.m_122427_();
                }
            }
        }
        float f = Mth.m_14177_((float)this.m_146908_());
        switch (transformRotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 90.0f;
            }
            case CLOCKWISE_90: {
                return f + 270.0f;
            }
        }
        return f;
    }

    public float m_6961_(Mirror transformMirror) {
        return this.m_7890_(transformMirror.m_54846_(this.direction));
    }

    public void m_8038_(ServerLevel level, LightningBolt lightning) {
    }

    public void m_6210_() {
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ServerPlayer color;
        if (this.m_213877_()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.m_21120_(hand);
        Level level = this.m_9236_();
        if (player.m_36341_() && !itemstack.m_41619_()) {
            if (!level.f_46443_) {
                this.setItem(itemstack);
                if (!itemstack.m_41619_()) {
                    this.m_5496_(SoundEvents.f_144181_, 1.0f, 1.0f);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        boolean consume = true;
        boolean success = false;
        boolean glowInk = this.hasGlowInk();
        if (itemstack.m_41720_() == Items.f_42402_) {
            this.cycleText();
            consume = false;
            success = true;
        } else if (itemstack.m_41720_() == Items.f_151056_ && !glowInk) {
            level.m_6269_(null, (Entity)this, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setHasGlowInk(true);
            success = true;
        } else if (itemstack.m_41720_() == Items.f_42532_ && glowInk) {
            level.m_6269_(null, (Entity)this, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setHasGlowInk(false);
            success = true;
        } else if (ForgeHelper.getColor((ItemStack)itemstack) != null) {
            level.m_6269_(null, (Entity)this, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
            color = ForgeHelper.getColor((ItemStack)itemstack);
            this.setColor((DyeColor)color);
            this.recomputeTexture(this.getItem());
            success = true;
        }
        if (success) {
            if (consume && !player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                color = (ServerPlayer)player;
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockPos p = this.calculateBehindPos();
            InteractionResult interactionresult = sp.f_8941_.m_7179_(sp, level, itemstack, hand, new BlockHitResult(Vec3.m_82512_((Vec3i)p), this.direction, p, false));
            return interactionresult;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean needsVisualUpdate() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public void setLabelText(FormattedCharSequence[] tempPageLines) {
        this.labelText = tempPageLines;
    }

    public void setLabelTextScale(float scale) {
        this.scale = scale;
    }

    public float getLabelTextScale() {
        return this.scale;
    }

    public FormattedCharSequence[] getLabelText() {
        return this.labelText;
    }

    @Nullable
    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public boolean hasGlowInk() {
        return (Boolean)this.m_20088_().m_135370_(DATA_GLOWING);
    }

    public boolean hasText() {
        return (Boolean)this.m_20088_().m_135370_(DATA_TEXT);
    }

    private void setHasGlowInk(boolean glowing) {
        this.m_20088_().m_135381_(DATA_GLOWING, (Object)glowing);
    }

    private void setHasText(boolean text) {
        this.m_20088_().m_135381_(DATA_TEXT, (Object)text);
    }

    private void cycleText() {
        this.m_20088_().m_135381_(DATA_TEXT, (Object)((Boolean)this.m_20088_().m_135370_(DATA_TEXT) == false ? 1 : 0));
    }

    @Nullable
    public DyeColor getColor() {
        byte i = (Byte)this.m_20088_().m_135370_(DATA_DYE_COLOR);
        return i == -1 ? null : DyeColor.m_41053_((int)i);
    }

    private void setColor(@Nullable DyeColor color) {
        this.m_20088_().m_135381_(DATA_DYE_COLOR, (Object)((byte)(color == null ? -1 : color.ordinal())));
    }
}

