/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.labels;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import net.mehvahdjukaar.labels.ClientConfigs;
import net.mehvahdjukaar.labels.ColorManager;
import net.mehvahdjukaar.labels.LabelEntity;
import net.mehvahdjukaar.labels.LabelsMod;
import net.mehvahdjukaar.labels.LabelsModClient;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class LabelEntityRenderer
extends EntityRenderer<LabelEntity> {
    private final ModelBlockRenderer modelRenderer;
    private final ModelManager modelManager;
    private final Camera camera;

    public LabelEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        Minecraft minecraft = Minecraft.m_91087_();
        this.modelRenderer = minecraft.m_91289_().m_110937_();
        this.modelManager = minecraft.m_91289_().m_110907_().m_110881_();
        this.camera = minecraft.f_91063_.m_109153_();
    }

    public void render(LabelEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        FrameBufferBackedDynamicTexture tex;
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, light);
        if (this.f_114476_.m_114377_()) {
            BlockPos behind = entity.calculateBehindPos();
            VertexConsumer lines = buffer.m_6299_(RenderType.m_110504_());
            poseStack.m_85836_();
            Vec3 ep = entity.m_20182_();
            Vec3 vec3 = new Vec3((double)behind.m_123341_() - ep.f_82479_, (double)behind.m_123342_() - ep.f_82480_, (double)behind.m_123343_() - ep.f_82481_);
            AABB bb = new AABB(vec3, vec3.m_82520_(1.0, 1.0, 1.0)).m_82400_(0.01);
            LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)lines, (AABB)bb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entity.m_146908_()));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-entity.m_146909_()));
        poseStack.m_85837_(0.0, 0.0, -0.46875);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        this.modelRenderer.m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), null, ClientHelper.getModel((ModelManager)this.modelManager, (ResourceLocation)LabelsModClient.LABEL_MODEL), 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
        Item item = entity.getItem().m_41720_();
        ResourceLocation id = entity.getTextureId();
        if (item != Items.f_41852_ && id != null && (tex = RenderedTexturesManager.requestFlatItemTexture((ResourceLocation)id, (Item)item, (int)ClientConfigs.TEXTURE_SIZE.get(), i -> {
            try {
                LabelEntityRenderer.postProcess(i, entity.getColor());
            }
            catch (Exception e) {
                LabelsMod.LOGGER.warn("Failed to correctly create label image for {}:", i, (Object)e);
            }
        })).isInitialized()) {
            boolean hasText = entity.hasText();
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)tex.getTextureLocation()));
            Matrix4f tr = poseStack.m_85850_().m_252922_();
            Matrix3f normal = poseStack.m_85850_().m_252943_();
            int overlay = OverlayTexture.f_118083_;
            float z = 0.9875f;
            float s = hasText ? 0.1875f : 0.25f;
            poseStack.m_85837_(0.5, hasText ? 0.575 : 0.5, (double)z);
            poseStack.m_85836_();
            boolean glow = entity.hasGlowInk();
            if (glow) {
                light = 0xF000F0;
            }
            vertexConsumer.m_252986_(tr, -s, -s, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexConsumer.m_252986_(tr, -s, s, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexConsumer.m_252986_(tr, s, s, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexConsumer.m_252986_(tr, s, -s, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            poseStack.m_85849_();
            if (hasText) {
                this.drawLabelText(poseStack, buffer, entity, entity.getItem().m_41786_(), glow, light);
            }
        }
        poseStack.m_85849_();
    }

    private static void postProcess(NativeImage image, @Nullable DyeColor tint) {
        TextureImage outlineTexture;
        boolean outline;
        boolean reduceColors = ClientConfigs.REDUCE_COLORS.get();
        boolean recolor = ClientConfigs.IS_RECOLORED.get();
        boolean bl = outline = ClientConfigs.OUTLINE.get() != false && recolor;
        if (recolor || reduceColors) {
            SpriteUtils.mergeSimilarColors((NativeImage)image, (float)0.015f);
        }
        if (recolor) {
            SpriteUtils.grayscaleImage((NativeImage)image);
        }
        TextureImage originalTexture = TextureImage.of((NativeImage)image, (McMetaFile)null);
        if (outline) {
            ArrayList outlinePosition = new ArrayList();
            outlineTexture = originalTexture.makeCopy();
            SpriteUtils.forEachPixel((NativeImage)outlineTexture.getImage(), (x, y) -> {
                int c = outlineTexture.getImage().m_84985_(x.intValue(), y.intValue());
                if (new RGBColor(c).alpha() != 0.0f && (x == 0 || new RGBColor(image.m_84985_(x - 1, y.intValue())).alpha() == 0.0f || x == image.m_84982_() - 1 || new RGBColor(image.m_84985_(x + 1, y.intValue())).alpha() == 0.0f || y == 0 || new RGBColor(image.m_84985_(x.intValue(), y - 1)).alpha() == 0.0f || y == image.m_85084_() - 1 || new RGBColor(image.m_84985_(x.intValue(), y + 1)).alpha() == 0.0f)) {
                    outlinePosition.add(Pair.of((Object)x, (Object)y));
                }
            });
            SpriteUtils.forEachPixel((NativeImage)outlineTexture.getImage(), (x, y) -> {
                if (!outlinePosition.contains(Pair.of((Object)x, (Object)y))) {
                    outlineTexture.getImage().m_84988_(x.intValue(), y.intValue(), 0);
                } else {
                    originalTexture.getImage().m_84988_(x.intValue(), y.intValue(), 0);
                }
            });
        } else {
            outlineTexture = null;
        }
        if (reduceColors) {
            int cutoff = 11;
            IntUnaryOperator fn = i -> {
                if (i < cutoff) {
                    return i;
                }
                return (int)(Math.pow(i - cutoff + 1, 0.3333333432674408) + (double)cutoff - 1.0);
            };
            SpriteUtils.reduceColors((NativeImage)image, (IntUnaryOperator)fn);
            if (outlineTexture != null) {
                int maxOutlineColors = 3;
                try {
                    SpriteUtils.reduceColors((NativeImage)outlineTexture.getImage(), j -> Math.min(j, maxOutlineColors));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (recolor) {
            Palette old;
            int s;
            RGBColor dark = new RGBColor(ColorManager.getDark(tint));
            RGBColor light = new RGBColor(ColorManager.getLight(tint));
            if (ClientConfigs.COLOR_PRESET.get() != ClientConfigs.Preset.DEFAULT) {
                dark = dark.asHCL();
                light = light.asHCL();
            }
            Palette newPalette = (s = (old = Palette.fromImage((TextureImage)originalTexture, null, (float)0.0f)).size()) < 3 ? Palette.ofColors(List.of(light.asRGB(), dark.asRGB())) : Palette.fromArc((BaseColor)light.asRGB(), (BaseColor)dark.asRGB(), (int)(s + (outline ? 2 : 0)));
            if (outline) {
                Palette newOutlinePalette;
                if (newPalette.size() > 4) {
                    newOutlinePalette = Palette.ofColors(List.of(newPalette.remove(0).rgb()));
                    PaletteColor v = newPalette.remove(0);
                    newOutlinePalette.add(v);
                    newOutlinePalette.add(newPalette.getDarkest());
                } else {
                    newOutlinePalette = newPalette.copy();
                    newOutlinePalette.add(newPalette.getDarkest().getDarkened());
                }
                LabelEntityRenderer.fastInPlaceRecolor(outlineTexture.getImage(), Palette.fromImage((TextureImage)outlineTexture), newOutlinePalette);
            }
            LabelEntityRenderer.fastInPlaceRecolor(image, old, newPalette);
        }
        if (outlineTexture != null) {
            originalTexture.applyOverlay(new TextureImage[]{outlineTexture});
            outlineTexture.close();
        }
    }

    private static void fastInPlaceRecolor(NativeImage image, Palette old, Palette newPalette) {
        assert (old.size() <= newPalette.size()) : "Palettes must have same size";
        SpriteUtils.forEachPixel((NativeImage)image, (x, y) -> {
            int c = image.m_84985_(x.intValue(), y.intValue());
            for (int i = 0; i < old.size(); ++i) {
                if (((PaletteColor)old.getValues().get(i)).value() != c) continue;
                c = ((PaletteColor)newPalette.getValues().get(i)).value();
                image.m_84988_(x.intValue(), y.intValue(), c);
                break;
            }
        });
    }

    private void drawLabelText(PoseStack matrixStack, MultiBufferSource buffer, LabelEntity entity, Component text, boolean glow, int light) {
        DyeColor d;
        matrixStack.m_85841_(-1.0f, 1.0f, -1.0f);
        Font font = Minecraft.m_91087_().f_91062_;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.25, 0.0);
        if (entity.needsVisualUpdate()) {
            float paperHeight = 0.100000024f;
            float paperWidth = 0.45f;
            Pair pair = TextUtil.fitLinesToBox((Font)font, (FormattedText)text, (float)paperWidth, (float)paperHeight);
            entity.setLabelText((FormattedCharSequence[])((List)pair.getFirst()).toArray(FormattedCharSequence[]::new));
            entity.setLabelTextScale(((Float)pair.getSecond()).floatValue());
        }
        float scale = entity.getLabelTextScale();
        FormattedCharSequence[] tempPageLines = entity.getLabelText();
        matrixStack.m_85837_(0.0, -0.475, 0.0);
        matrixStack.m_85841_(scale, -scale, scale);
        DyeColor c = DyeColor.BLACK;
        if (ClientConfigs.COLORED_TEXT.get().booleanValue() && (d = entity.getColor()) != null) {
            c = d;
        }
        TextUtil.renderAllLines((FormattedCharSequence[])tempPageLines, (int)10, (Font)font, (PoseStack)matrixStack, (MultiBufferSource)buffer, (TextUtil.RenderProperties)TextUtil.renderProperties((DyeColor)c, (boolean)glow, (float)1.5f, (int)light, (Style)Style.f_131099_, (Vector3f)entity.m_6350_().m_253071_(), () -> new LOD(this.camera, entity.m_20183_()).isVeryNear()));
        matrixStack.m_85849_();
    }

    public Vec3 getRenderOffset(LabelEntity entity, float partialTicks) {
        return Vec3.f_82478_;
    }

    public ResourceLocation getTextureLocation(LabelEntity labelEntity) {
        return TextureAtlas.f_118259_;
    }

    protected boolean shouldShowName(LabelEntity labelEntity) {
        return false;
    }
}

