/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.util.color;

import com.mojang.serialization.Codec;
import dev.obscuria.fragmentum.extension.CodecExtension;
import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.fragmentum.util.color.Colors;
import dev.obscuria.fragmentum.util.color.HSV;
import java.util.List;
import lombok.Generated;
import net.minecraft.util.Mth;

public record RGB(float red, float green, float blue) {
    public static final Codec<RGB> DECIMAL_CODEC = Codec.INT.xmap(Colors::rgbOf, RGB::decimal);
    public static final Codec<RGB> HEXADECIMAL_CODEC = Codec.STRING.xmap(Colors::rgbOf, RGB::hexadecimal);
    public static final Codec<RGB> NORMALIZED_CODEC = Codec.FLOAT.listOf().xmap(Colors::rgbOf, RGB::normalized);
    public static final Codec<RGB> CODEC = CodecExtension.withAlternative(DECIMAL_CODEC, HEXADECIMAL_CODEC, NORMALIZED_CODEC);

    public int decimal() {
        int r = Math.min(255, Math.max(0, (int)(this.red * 255.0f)));
        int g = Math.min(255, Math.max(0, (int)(this.green * 255.0f)));
        int b = Math.min(255, Math.max(0, (int)(this.blue * 255.0f)));
        return r << 16 | g << 8 | b;
    }

    public String hexadecimal() {
        return String.format("#%06X", this.decimal() & 0xFFFFFF);
    }

    public List<Float> normalized() {
        return List.of(Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public RGB lerp(RGB to, float delta) {
        return new RGB(Mth.m_14179_((float)delta, (float)this.red, (float)to.red), Mth.m_14179_((float)delta, (float)this.green, (float)to.green), Mth.m_14179_((float)delta, (float)this.blue, (float)to.blue));
    }

    public ARGB toARGB(float alpha) {
        return new ARGB(alpha, this.red, this.green, this.blue);
    }

    public HSV toHSV() {
        float min;
        float max = Math.max(this.red, Math.max(this.green, this.blue));
        float delta = max - (min = Math.min(this.red, Math.min(this.green, this.blue)));
        float hue = delta == 0.0f ? 0.0f : (max == this.red ? (this.green - this.blue) / delta : (max == this.green ? (this.blue - this.red) / delta + 2.0f : (this.red - this.green) / delta + 4.0f));
        if ((hue = hue / 6.0f % 1.0f) < 0.0f) {
            hue += 1.0f;
        }
        float saturation = max == 0.0f ? 0.0f : delta / max;
        return new HSV(hue, saturation, max);
    }

    @Generated
    public RGB withRed(float red) {
        return this.red == red ? this : new RGB(red, this.green, this.blue);
    }

    @Generated
    public RGB withGreen(float green) {
        return this.green == green ? this : new RGB(this.red, green, this.blue);
    }

    @Generated
    public RGB withBlue(float blue) {
        return this.blue == blue ? this : new RGB(this.red, this.green, blue);
    }
}

