/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.filter;

import com.mojang.serialization.Codec;
import dev.obscuria.fragmentum.registry.BootstrapContext;
import dev.obscuria.tooltips.client.filter.AllOfFilter;
import dev.obscuria.tooltips.client.filter.AlwaysFilter;
import dev.obscuria.tooltips.client.filter.AnyOfFilter;
import dev.obscuria.tooltips.client.filter.EnchantmentFilter;
import dev.obscuria.tooltips.client.filter.ItemOrTagFilter;
import dev.obscuria.tooltips.client.filter.ModFilter;
import dev.obscuria.tooltips.client.filter.NbtFilter;
import dev.obscuria.tooltips.client.filter.NeverFilter;
import dev.obscuria.tooltips.client.filter.NoneOfFilter;
import dev.obscuria.tooltips.client.filter.PropertyFilter;
import dev.obscuria.tooltips.client.filter.RarityFilter;
import dev.obscuria.tooltips.content.registry.TooltipRegistries;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;

public interface ItemFilter {
    public static final Codec<ItemFilter> CODEC = TooltipRegistries.ITEM_FILTER_TYPE.byNameCodec().dispatch(ItemFilter::codec, Function.identity());

    public Codec<? extends ItemFilter> codec();

    public boolean test(ItemStack var1);

    public static void bootstrap(BootstrapContext<Codec<? extends ItemFilter>> context) {
        context.register("always", () -> AlwaysFilter.CODEC);
        context.register("never", () -> NeverFilter.CODEC);
        context.register("all_of", () -> AllOfFilter.CODEC);
        context.register("any_of", () -> AnyOfFilter.CODEC);
        context.register("none_of", () -> NoneOfFilter.CODEC);
        context.register("item", () -> ItemOrTagFilter.CODEC);
        context.register("mod", () -> ModFilter.CODEC);
        context.register("enchantment", () -> EnchantmentFilter.CODEC);
        context.register("rarity", () -> RarityFilter.CODEC);
        context.register("nbt", () -> NbtFilter.CODEC);
        context.register("property", () -> PropertyFilter.CODEC);
    }
}

