/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.blocks;

import com.daeruin.darkestbeforedawn.DarkestBeforeDawn;
import com.daeruin.darkestbeforedawn.blocks.BlockRegistry;
import com.daeruin.darkestbeforedawn.blocks.BlockTileEntity;
import com.daeruin.darkestbeforedawn.config.DarkestConfig;
import com.daeruin.darkestbeforedawn.items.ItemRegistry;
import com.daeruin.darkestbeforedawn.network.CampfirePacket;
import com.daeruin.darkestbeforedawn.network.GuiHandler;
import com.daeruin.darkestbeforedawn.network.PacketHandler;
import com.daeruin.darkestbeforedawn.tileentity.TileEntityCampfire;
import com.daeruin.primallib.config.PrimalConfig;
import com.daeruin.primallib.items.PrimalItemRegistry;
import com.daeruin.primallib.util.PrimalUtil;
import com.daeruin.primallib.util.PrimalUtilSpawn;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTileEntityCampfire
extends BlockTileEntity<TileEntityCampfire> {
    public static final PropertyEnum<EnumCampfireState> CAMPFIRE_STATE = PropertyEnum.func_177709_a((String)"campfire_state", EnumCampfireState.class);
    public static final Material[] VALID_CAMPFIRE_SUPPORT = new Material[]{Material.field_151571_B, Material.field_151578_c, Material.field_151573_f, Material.field_151576_e, Material.field_151595_p};
    private static final int STOKE_THRESHOLD = 80;
    private static final int MAX_STOKE_TIME = 140;
    private static final int TINDER_MIN_BREATHS = 3;
    private static final int TINDER_MAX_BREATHS = 5;
    private static final int KINDLING_MIN_BREATHS = 6;
    private static final int KINDLING_MAX_BREATHS = 8;
    private static final int NUM_TWIGS_FOR_KINDLING = 3;
    private static final AxisAlignedBB AABB_BURNING = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.9375, 0.875);
    private static final AxisAlignedBB AABB_DEFAULT = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.09375, 0.9375);

    BlockTileEntityCampfire(String registryName) {
        super(registryName, DarkestBeforeDawn.PRIMAL_CAMPFIRE, 0.0f, 0.0f, false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CAMPFIRE_STATE, (Comparable)((Object)EnumCampfireState.TINDER)));
    }

    public static void setCampfireState(World world, BlockPos pos, EnumCampfireState campfireState) {
        world.func_175656_a(pos, BlockRegistry.CAMPFIRE.func_176223_P().func_177226_a(CAMPFIRE_STATE, (Comparable)((Object)campfireState)));
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (state.func_177229_b(CAMPFIRE_STATE) == EnumCampfireState.BURNING) {
            entityIn.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(CAMPFIRE_STATE) == EnumCampfireState.BURNING) {
            return AABB_BURNING;
        }
        return AABB_DEFAULT;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
        if (state.func_177229_b(CAMPFIRE_STATE) == EnumCampfireState.BURNING) {
            return AABB_BURNING;
        }
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149750_m(IBlockState state) {
        switch ((EnumCampfireState)((Object)state.func_177229_b(CAMPFIRE_STATE))) {
            case TINDER: 
            case KINDLING: 
            case ASHES: {
                return 0;
            }
            case TINDER_STOKED: {
                return 2;
            }
            case KINDLING_STOKED: 
            case COALS: {
                return 5;
            }
            case BURNING: {
                return 14;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150349_c) {
            worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P());
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    private void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    private boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState stateBelow = worldIn.func_180495_p(pos.func_177977_b());
            for (Material material : VALID_CAMPFIRE_SUPPORT) {
                if (stateBelow.func_185904_a() != material || stateBelow.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) != BlockFaceShape.SOLID) continue;
                return true;
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropInventory((IBlockAccess)world, pos);
        super.func_180663_b(world, pos, state);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        switch ((EnumCampfireState)((Object)state.func_177229_b(CAMPFIRE_STATE))) {
            case TINDER: 
            case TINDER_STOKED: {
                drops.add((Object)new ItemStack(ItemRegistry.TINDER, 1));
                break;
            }
            case KINDLING: 
            case KINDLING_STOKED: {
                drops.add((Object)new ItemStack(ItemRegistry.TINDER, 1));
                if (!PrimalConfig.TWIGS.allowTwigs) break;
                drops.add((Object)new ItemStack(PrimalItemRegistry.TWIG_GENERIC, 3));
                break;
            }
            case ASHES: {
                if (!DarkestConfig.basicItems.allowCharcoalDust) break;
                drops.add((Object)new ItemStack(ItemRegistry.DUST_CHARCOAL, 1));
                break;
            }
            case COALS: 
            case BURNING: {
                this.dropInventory(world, pos);
                if (!DarkestConfig.basicItems.allowCharcoalDust) break;
                drops.add((Object)new ItemStack(ItemRegistry.DUST_CHARCOAL, 1));
            }
        }
    }

    private void dropInventory(IBlockAccess world, BlockPos pos) {
        TileEntityCampfire tileEntity = (TileEntityCampfire)((Object)this.getTileEntity(world, pos));
        if (tileEntity != null) {
            tileEntity.expelInventory();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        double yPos = pos.func_177956_o();
        double xPos = pos.func_177958_n();
        double zPos = pos.func_177952_p();
        double yAdj = rand.nextDouble();
        double xAdj = rand.nextDouble();
        double zAdj = rand.nextDouble();
        EnumCampfireState campfireState = (EnumCampfireState)((Object)stateIn.func_177229_b(CAMPFIRE_STATE));
        if (campfireState == EnumCampfireState.TINDER_STOKED || campfireState == EnumCampfireState.KINDLING_STOKED || campfireState == EnumCampfireState.COALS) {
            xAdj = xAdj * 0.5 + 0.25;
            zAdj = zAdj * 0.5 + 0.25;
            PrimalUtilSpawn.spawnLittleSmoke((World)world, (double)(xPos + xAdj), (double)yPos, (double)(zPos + zAdj));
        }
        if (campfireState == EnumCampfireState.BURNING) {
            double lowerBound = (yAdj *= 0.6) / 2.0;
            double upperBound = 100.0 - yAdj / 2.0;
            if (xAdj < lowerBound) {
                xAdj = lowerBound;
            }
            if (xAdj > upperBound) {
                xAdj = upperBound;
            }
            if (zAdj < lowerBound) {
                zAdj = lowerBound;
            }
            if (zAdj > upperBound) {
                zAdj = upperBound;
            }
            PrimalUtilSpawn.spawnFlame((World)world, (double)(xPos + xAdj), (double)(yPos + yAdj), (double)(zPos + zAdj));
            PrimalUtilSpawn.spawnBigSmoke((World)world, (double)(xPos + 0.5), (double)(yPos + yAdj), (double)(zPos + 0.5));
            PrimalUtilSpawn.playFireAudio((World)world, (double)(xPos + 0.5), (double)(yPos + 0.5), (double)(zPos + 0.5));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityCampfire tileEntity = (TileEntityCampfire)((Object)this.getTileEntity((IBlockAccess)world, pos));
            if (tileEntity == null) {
                return false;
            }
            EnumCampfireState campfireState = (EnumCampfireState)((Object)state.func_177229_b(CAMPFIRE_STATE));
            ItemStack heldItemStack = player.func_184586_b(hand);
            Item heldItem = heldItemStack.func_77973_b();
            if (campfireState == EnumCampfireState.TINDER) {
                if (!heldItemStack.func_190926_b()) {
                    if (heldItem == ItemRegistry.GLOWING_EMBER || heldItem == Items.field_151033_d || DarkestConfig.basicItems.allowUnlitTorches && heldItem == Item.func_150898_a((Block)BlockRegistry.TORCH_LIT) || DarkestConfig.basicItems.allowVanillaTorches && heldItem == Item.func_150898_a((Block)Blocks.field_150478_aa) && !world.func_175727_C(pos.func_177984_a())) {
                        if (player.func_184812_l_()) {
                            tileEntity.setBurnTimeRemaining(4000);
                            tileEntity.setBurnTimeInitial(4000);
                            tileEntity.setCoalsCoolDown(600);
                            BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.BURNING);
                            return true;
                        }
                        if (heldItem == ItemRegistry.GLOWING_EMBER) {
                            heldItemStack.func_190918_g(1);
                        } else if (heldItem == Items.field_151033_d) {
                            heldItemStack.func_77972_a(1, (EntityLivingBase)player);
                        }
                        if (tileEntity.getStokeTimer() == 0 && !world.func_175727_C(pos.func_177984_a())) {
                            tileEntity.setStokeTimer(80);
                            BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.TINDER_STOKED);
                        }
                    } else if (heldItem == PrimalItemRegistry.TWIG_GENERIC && heldItemStack.func_190916_E() >= 3) {
                        heldItemStack.func_190918_g(3);
                        tileEntity.setStokeTimer(0);
                        BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.KINDLING);
                    }
                } else if (player.func_70093_af()) {
                    BlockTileEntityCampfire.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(ItemRegistry.TINDER));
                    world.func_175698_g(pos);
                }
            } else if (campfireState == EnumCampfireState.TINDER_STOKED) {
                if (!heldItemStack.func_190926_b()) {
                    if (heldItem == PrimalItemRegistry.TWIG_GENERIC && heldItemStack.func_190916_E() >= 3) {
                        heldItemStack.func_190918_g(3);
                        if (tileEntity.getTimesBlown() >= 3) {
                            tileEntity.setStokeTimer(tileEntity.getStokeTimer() - 40);
                            BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.KINDLING_STOKED);
                        } else {
                            tileEntity.setStokeTimer(0);
                            BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.KINDLING);
                        }
                    } else if (PrimalUtil.isLog((Block)Block.func_149634_a((Item)heldItem))) {
                        tileEntity.setStokeTimer(0);
                        tileEntity.setTimesBlown(0);
                        BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.TINDER);
                    } else if (heldItem == Items.field_151131_as) {
                        this.putOutCampfire(world, pos, tileEntity);
                        return true;
                    }
                } else if (player.func_70093_af()) {
                    BlockTileEntityCampfire.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(ItemRegistry.TINDER));
                    world.func_175698_g(pos);
                } else {
                    this.attemptStokeCampfire(world, pos, tileEntity, (EntityPlayerMP)player, 5);
                }
            } else if (campfireState == EnumCampfireState.KINDLING) {
                if (!heldItemStack.func_190926_b()) {
                    if ((DarkestConfig.basicItems.allowUnlitTorches && heldItem == Item.func_150898_a((Block)BlockRegistry.TORCH_LIT) || DarkestConfig.basicItems.allowVanillaTorches && heldItem == Item.func_150898_a((Block)Blocks.field_150478_aa)) && !world.func_175727_C(pos.func_177984_a())) {
                        tileEntity.setStokeTimer(80);
                        tileEntity.setTimesBlown(4);
                        BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.KINDLING_STOKED);
                    }
                } else if (player.func_70093_af()) {
                    BlockTileEntityCampfire.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(PrimalItemRegistry.TWIG_GENERIC, 3));
                    BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.TINDER);
                }
            } else if (campfireState == EnumCampfireState.KINDLING_STOKED) {
                if (!heldItemStack.func_190926_b()) {
                    if (PrimalUtil.isLog((Block)Block.func_149634_a((Item)heldItem))) {
                        if (tileEntity.getTimesBlown() >= 6) {
                            tileEntity.insertHeldItem(player, hand);
                            return true;
                        }
                        tileEntity.setStokeTimer(0);
                        tileEntity.setTimesBlown(0);
                        BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.KINDLING);
                    } else if (heldItem == Items.field_151131_as) {
                        this.putOutCampfire(world, pos, tileEntity);
                        return true;
                    }
                } else if (player.func_70093_af()) {
                    BlockTileEntityCampfire.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(PrimalItemRegistry.TWIG_GENERIC, 3));
                    BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.TINDER);
                } else {
                    this.attemptStokeCampfire(world, pos, tileEntity, (EntityPlayerMP)player, 8);
                }
            } else if (campfireState == EnumCampfireState.BURNING) {
                if (!heldItemStack.func_190926_b()) {
                    if (heldItem == Items.field_151131_as) {
                        this.putOutCampfire(world, pos, tileEntity);
                        return true;
                    }
                    if (tileEntity.insertHeldItem(player, hand)) {
                        return true;
                    }
                }
            } else if (campfireState == EnumCampfireState.COALS) {
                if (!heldItemStack.func_190926_b()) {
                    if (heldItem == Items.field_151131_as) {
                        this.putOutCampfire(world, pos, tileEntity);
                        return true;
                    }
                    if (tileEntity.insertHeldItem(player, hand)) {
                        return true;
                    }
                }
            } else if (campfireState == EnumCampfireState.ASHES && !heldItemStack.func_190926_b()) {
                if (heldItem instanceof ItemSpade && DarkestConfig.basicItems.allowCharcoalDust) {
                    ItemStack stack = new ItemStack(ItemRegistry.DUST_CHARCOAL, DarkestConfig.itemScarcity.charcoalAmtAshes);
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.5f), (double)pos.func_177952_p(), stack));
                    world.func_175698_g(pos);
                } else if (heldItem == ItemRegistry.TINDER) {
                    BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.TINDER);
                    heldItemStack.func_190918_g(1);
                }
            }
            if (campfireState == EnumCampfireState.BURNING || campfireState == EnumCampfireState.COALS) {
                player.openGui((Object)DarkestBeforeDawn.INSTANCE, GuiHandler.GUI_CAMPFIRE, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    private void attemptStokeCampfire(World world, BlockPos pos, TileEntityCampfire tileEntity, EntityPlayerMP player, int burnoutThreshold) {
        if (tileEntity.getStokeTimer() < 80 && !world.func_175727_C(pos.func_177984_a())) {
            this.blowOnCampfire(world, pos, tileEntity, player);
        }
        if (tileEntity.getTimesBlown() >= burnoutThreshold) {
            this.putOutCampfire(world, pos, tileEntity);
        }
    }

    private void blowOnCampfire(World world, BlockPos pos, TileEntityCampfire tileEntity, EntityPlayerMP player) {
        PacketHandler.INSTANCE.sendTo((IMessage)new CampfirePacket((EntityPlayer)player, 0, pos), player);
        tileEntity.setStokeTimer(140);
        tileEntity.setTimesBlown(tileEntity.getTimesBlown() + 1);
        if (tileEntity.getTimesBlown() >= 3) {
            this.spawnFlame(world, pos);
        }
        if (tileEntity.getTimesBlown() >= 6) {
            this.spawnFlame(world, pos);
            this.spawnBigSmoke(world, pos);
        }
    }

    private void putOutCampfire(World world, BlockPos pos, TileEntityCampfire tileEntity) {
        tileEntity.setStokeTimer(0);
        tileEntity.setTimesBlown(0);
        tileEntity.setBurnTimeInitial(0);
        tileEntity.setCoalsCoolDown(0);
        BlockTileEntityCampfire.setCampfireState(world, pos, EnumCampfireState.ASHES);
        this.dropInventory((IBlockAccess)world, pos);
    }

    private void spawnFlame(World world, BlockPos pos) {
        double xPos = (double)pos.func_177958_n() + (Math.random() * 0.7 + 0.25);
        double yPos = (double)pos.func_177956_o() + 0.1;
        double zPos = (double)pos.func_177952_p() + (Math.random() * 0.7 + 0.25);
        PrimalUtilSpawn.spawnFlame((World)world, (double)xPos, (double)yPos, (double)zPos);
    }

    private void spawnBigSmoke(World world, BlockPos pos) {
        double xPos = (double)pos.func_177958_n() + 0.5;
        double yPos = (double)pos.func_177956_o() + 0.1;
        double zPos = (double)pos.func_177952_p() + 0.5;
        PrimalUtilSpawn.spawnBigSmoke((World)world, (double)xPos, (double)yPos, (double)zPos);
    }

    @Override
    public Class<TileEntityCampfire> getTileEntityClass() {
        return TileEntityCampfire.class;
    }

    @Override
    @Nullable
    public TileEntityCampfire createTileEntity(World world, IBlockState state) {
        return new TileEntityCampfire();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            case 0: {
                return this.func_176223_P().func_177226_a(CAMPFIRE_STATE, (Comparable)((Object)EnumCampfireState.TINDER));
            }
            case 1: {
                return this.func_176223_P().func_177226_a(CAMPFIRE_STATE, (Comparable)((Object)EnumCampfireState.TINDER_STOKED));
            }
            case 2: {
                return this.func_176223_P().func_177226_a(CAMPFIRE_STATE, (Comparable)((Object)EnumCampfireState.KINDLING));
            }
            case 3: {
                return this.func_176223_P().func_177226_a(CAMPFIRE_STATE, (Comparable)((Object)EnumCampfireState.KINDLING_STOKED));
            }
            case 4: {
                return this.func_176223_P().func_177226_a(CAMPFIRE_STATE, (Comparable)((Object)EnumCampfireState.BURNING));
            }
            case 5: {
                return this.func_176223_P().func_177226_a(CAMPFIRE_STATE, (Comparable)((Object)EnumCampfireState.COALS));
            }
            case 6: {
                return this.func_176223_P().func_177226_a(CAMPFIRE_STATE, (Comparable)((Object)EnumCampfireState.ASHES));
            }
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumCampfireState)((Object)state.func_177229_b(CAMPFIRE_STATE))).getMeta();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CAMPFIRE_STATE});
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public static enum EnumCampfireState implements IStringSerializable
    {
        TINDER(0, "tinder"),
        TINDER_STOKED(1, "tinder_stoked"),
        KINDLING(2, "kindling"),
        KINDLING_STOKED(3, "kindling_stoked"),
        BURNING(4, "burning"),
        COALS(5, "coals"),
        ASHES(6, "ashes");

        private final int meta;
        private final String name;

        private EnumCampfireState(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        int getMeta() {
            return this.meta;
        }
    }
}

