/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.blocks;

import com.daeruin.darkestbeforedawn.config.DarkestConfig;
import com.daeruin.darkestbeforedawn.items.ItemBlockTorchLit;
import com.daeruin.darkestbeforedawn.items.ItemBlockTorchUnlit;
import com.daeruin.darkestbeforedawn.tileentity.TileEntityTorch;
import com.daeruin.primallib.IHasCustomItemBlock;
import com.daeruin.primallib.config.PrimalConfig;
import com.daeruin.primallib.items.PrimalItemRegistry;
import com.daeruin.primallib.util.PrimalUtilReg;
import com.daeruin.primallib.util.PrimalUtilSpawn;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTileEntityTorchLit
extends BlockTorch
implements IHasCustomItemBlock {
    public static final int LIFESPAN = DarkestConfig.torchBehavior.torchDuration;
    private static final int SMOLDERING = (int)((float)LIFESPAN * DarkestConfig.torchBehavior.smolderingRatio);
    private static final int SMOLDERING_LIGHT_VALUE = DarkestConfig.torchBehavior.smolderingBrightness;
    private static final int NORMAL_LIGHT_VALUE = DarkestConfig.torchBehavior.fullBrightness;
    protected String registryName;

    BlockTileEntityTorchLit(String registryName) {
        PrimalUtilReg.initializeBlock((Block)this, (String)registryName);
    }

    public int getLifespan() {
        return LIFESPAN;
    }

    private boolean isSmoldering(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity != null && tileEntity instanceof TileEntityTorch && ((TileEntityTorch)tileEntity).currentAge > SMOLDERING;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.isSmoldering(world, pos)) {
            return SMOLDERING_LIGHT_VALUE;
        }
        return NORMAL_LIGHT_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isSmoldering((IBlockAccess)world, pos)) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176596_a);
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.7;
            double z = (double)pos.func_177952_p() + 0.5;
            double mod1 = 0.22;
            double mod2 = 0.27;
            int r = rand.nextInt(4);
            if (facing.func_176740_k().func_176722_c()) {
                EnumFacing opposite = facing.func_176734_d();
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.27 * (double)opposite.func_82601_c(), y + 0.22, z + 0.27 * (double)opposite.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                if (r == 2) {
                    world.func_175688_a(EnumParticleTypes.FLAME, x + 0.27 * (double)opposite.func_82601_c(), y + 0.22, z + 0.27 * (double)opposite.func_82599_e(), 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                if (r == 2) {
                    world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else {
            super.func_180655_c(state, world, pos, rand);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityTorch tileEntity = (TileEntityTorch)worldIn.func_175625_s(pos);
        if (tileEntity != null) {
            tileEntity.currentAge = stack.func_77952_i();
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (DarkestConfig.torchBehavior.sneakToPickUp && player.func_70093_af()) {
                TileEntity tileEntity = world.func_175625_s(pos);
                this.spawnTorchEntity(world, pos, tileEntity);
                return true;
            }
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemBlockTorchUnlit) {
                return false;
            }
        }
        return false;
    }

    private void spawnTorchEntity(@Nonnull World world, @Nonnull BlockPos pos, TileEntity tileEntity) {
        int blockTorchAge;
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this));
        if (DarkestConfig.torchBehavior.torchDuration > 0 && tileEntity != null && tileEntity instanceof TileEntityTorch && (blockTorchAge = ((TileEntityTorch)tileEntity).currentAge) > 0) {
            itemStack.func_77964_b(blockTorchAge);
        }
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStack);
        world.func_72838_d((Entity)entityItem);
        world.func_175698_g(pos);
    }

    @ParametersAreNonnullByDefault
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity tileEntity, ItemStack stack) {
        if (DarkestConfig.torchBehavior.sneakToPickUp) {
            if (PrimalConfig.BRANCHES_AND_SHAFTS.allowWoodenShafts && !PrimalConfig.BRANCHES_AND_SHAFTS.sticksCountAsShafts) {
                PrimalUtilSpawn.spawnEntityItem((World)world, (BlockPos)pos, (Item)PrimalItemRegistry.WOODEN_SHAFT, (int)1);
            } else {
                PrimalUtilSpawn.spawnEntityItem((World)world, (BlockPos)pos, (Item)Items.field_151055_y, (int)1);
            }
        } else {
            this.spawnTorchEntity(world, pos, tileEntity);
        }
        world.func_175698_g(pos);
    }

    public Class<TileEntityTorch> getTileEntityClass() {
        return TileEntityTorch.class;
    }

    public TileEntityTorch getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TileEntityTorch)world.func_175625_s(pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public TileEntityTorch createTileEntity(World world, IBlockState state) {
        return new TileEntityTorch();
    }

    public ItemBlock getItemBlock() {
        return new ItemBlockTorchLit();
    }
}

