/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.events;

import com.daeruin.darkestbeforedawn.blocks.BlockRegistry;
import com.daeruin.darkestbeforedawn.config.DarkestConfig;
import com.daeruin.darkestbeforedawn.items.ItemBlockTorchLit;
import com.daeruin.darkestbeforedawn.items.ItemRegistry;
import com.daeruin.darkestbeforedawn.utilities.DarkestUtil;
import com.daeruin.primallib.blocks.PrimalBlockLog;
import com.daeruin.primallib.blocks.PrimalBlockRegistry;
import com.daeruin.primallib.util.PrimalUtil;
import com.daeruin.primallib.util.PrimalUtilSpawn;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    private int updateLCG = new Random().nextInt();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!DarkestConfig.darknessBehavior.enableDarkness) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        WorldClient world = minecraft.field_71441_e;
        if (player == null || world == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && player.field_71093_bK == 0 && player.field_70173_aa % DarkestConfig.darknessBehavior.lightCheckFrequency == 0) {
            BlockPos playerPos = new BlockPos(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            int crudeBlockLight = world.func_175642_b(EnumSkyBlock.BLOCK, playerPos);
            int crudeSkyLight = world.func_175642_b(EnumSkyBlock.SKY, playerPos);
            float preciseBlockLight = 0.0f;
            float outdoorLight = 0.0f;
            float preciseSkyLight = 0.0f;
            if (crudeBlockLight > 0) {
                preciseBlockLight = this.getPreciseLightFromSource((World)world, player, EnumSkyBlock.BLOCK);
            }
            if (crudeSkyLight > 0) {
                outdoorLight = this.getOutdoorLight((World)world);
            }
            if (crudeSkyLight >= 15) {
                preciseSkyLight = 1.0f;
            } else if (outdoorLight > 0.0f) {
                preciseSkyLight = this.getPreciseLightFromSource((World)world, player, EnumSkyBlock.SKY);
            }
            float light = Math.max(preciseBlockLight, preciseSkyLight * outdoorLight);
            float darknessLevel = DarkestConfig.darknessBehavior.darknessLevel;
            minecraft.field_71474_y.field_74333_Y = light = light * (darknessLevel + 1.0f) - darknessLevel;
            if (player.field_70173_aa % 40 == 0) {
                // empty if block
            }
        }
    }

    private float getPreciseLightFromSource(World world, EntityPlayerSP player, EnumSkyBlock lightType) {
        float preciseLight;
        BlockPos playerPos = new BlockPos(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        int playerPosLight = world.func_175642_b(lightType, playerPos);
        int brightestLight = 0;
        EnumFacing brightestLightFacing = EnumFacing.UP;
        for (EnumFacing facingToCheck : EnumFacing.values()) {
            int lightAtFacing = world.func_175642_b(lightType, playerPos.func_177972_a(facingToCheck));
            if (lightAtFacing <= brightestLight) continue;
            brightestLight = lightAtFacing;
            brightestLightFacing = facingToCheck;
        }
        if (brightestLight <= playerPosLight) {
            preciseLight = 1.0f;
        } else {
            EnumFacing.Axis lightAxis = brightestLightFacing.func_176740_k();
            BlockPos lightPos = playerPos.func_177972_a(brightestLightFacing);
            double playerPosInLightDirection = 0.0;
            int brightestLightPosOnAxis = 0;
            if (lightAxis == EnumFacing.Axis.X) {
                playerPosInLightDirection = player.field_70165_t;
                brightestLightPosOnAxis = lightPos.func_177958_n();
            } else if (lightAxis == EnumFacing.Axis.Y) {
                playerPosInLightDirection = player.field_70163_u + (double)player.func_70047_e();
                brightestLightPosOnAxis = lightPos.func_177956_o();
            } else if (lightAxis == EnumFacing.Axis.Z) {
                playerPosInLightDirection = player.field_70161_v;
                brightestLightPosOnAxis = lightPos.func_177952_p();
            }
            float distanceInBlock = (float)playerPosInLightDirection - (float)((int)playerPosInLightDirection);
            distanceInBlock = Math.abs(distanceInBlock);
            preciseLight = (double)Math.abs(brightestLightPosOnAxis) < Math.abs(playerPosInLightDirection) ? (float)brightestLight - distanceInBlock : (float)brightestLight + distanceInBlock - 1.0f;
            preciseLight = Math.min(15.0f, preciseLight) / 15.0f;
        }
        return preciseLight;
    }

    private float getOutdoorLight(World world) {
        float adjustedTime = (world.func_72820_D() + 6000L) % 24000L;
        int SUNRISE_START = 3800;
        int SUNSET_START = 17800;
        int TRANSITION_LENGTH = 2200;
        float sunLight = adjustedTime < (float)SUNRISE_START ? 0.0f : (adjustedTime < (float)(SUNRISE_START + TRANSITION_LENGTH) ? (adjustedTime - (float)SUNRISE_START) / (float)TRANSITION_LENGTH : (adjustedTime < (float)SUNSET_START ? 1.0f : (adjustedTime < (float)(SUNSET_START + TRANSITION_LENGTH) ? 1.0f - (adjustedTime - (float)SUNSET_START) / (float)TRANSITION_LENGTH : 0.0f)));
        float moonPhase = world.func_130001_d();
        float moonLight = moonPhase / 2.0f;
        float outdoorLight = Math.max(sunLight, moonLight);
        float rainFactor = world.func_72867_j(1.0f) + 1.0f;
        float thunderFactor = world.func_72819_i(1.0f) + 1.0f;
        outdoorLight = outdoorLight / rainFactor / thunderFactor;
        return outdoorLight;
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity;
        if (!DarkestConfig.basicItems.allowVanillaTorches && (entity = event.getEntity()) instanceof EntityItem && ((EntityItem)entity).func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (DarkestConfig.basicItems.allowAnimalFat) {
            Entity entity = event.getEntity();
            int amount = 0;
            for (String animalFatSource : DarkestConfig.itemScarcity.animalFatSources) {
                try {
                    String[] fatSourceParsed = animalFatSource.split(",");
                    if (fatSourceParsed.length == 0) {
                        System.err.println("Animal fat source " + animalFatSource + " is not structured correctly. Please fix your config file.");
                        continue;
                    }
                    ResourceLocation resourceLocation = new ResourceLocation(fatSourceParsed[0]);
                    if (!EntityList.func_180123_a((Entity)entity, (ResourceLocation)resourceLocation)) continue;
                    amount = Integer.parseInt(fatSourceParsed[1]);
                }
                catch (Exception exception) {
                    System.err.println("Failed to parse " + animalFatSource + ". " + exception);
                }
            }
            if (amount > 0) {
                World world = entity.func_130014_f_();
                BlockPos pos = entity.func_180425_c();
                EntityItem animalFat = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(ItemRegistry.ANIMAL_FAT_RAW, amount));
                event.getDrops().add(animalFat);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WorldServer world = (WorldServer)event.world;
            if (world.field_73011_w instanceof WorldProviderSurface && world.field_73012_v.nextInt(100) == 0) {
                Iterator chunkIterator = world.func_184164_w().func_187300_b();
                while (chunkIterator.hasNext()) {
                    Chunk chunk = (Chunk)chunkIterator.next();
                    int chunkCornerX = chunk.field_76635_g * 16;
                    int chunkCornerZ = chunk.field_76647_h * 16;
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int rand = this.updateLCG >> 2;
                    int columnX = chunkCornerX + (rand & 0xF);
                    int columnZ = chunkCornerZ + (rand >> 8 & 0xF);
                    BlockPos randomPosTop = world.func_175725_q(new BlockPos(columnX, 0, columnZ));
                    int resinCheckingStage = 0;
                    BlockPos resinSource = null;
                    block8: for (int y = randomPosTop.func_177956_o(); y > 0; --y) {
                        BlockPos posToCheck = new BlockPos(columnX, y, columnZ);
                        IBlockState stateToCheck = world.func_180495_p(posToCheck);
                        Block blockToCheck = stateToCheck.func_177230_c();
                        switch (resinCheckingStage) {
                            case 0: {
                                if (!DarkestUtil.isSpruceLeaf(stateToCheck)) continue block8;
                                resinCheckingStage = 1;
                                continue block8;
                            }
                            case 1: {
                                if (DarkestUtil.isSpruceLeaf(stateToCheck)) continue block8;
                                if (DarkestUtil.isSpruceLog(stateToCheck)) {
                                    resinCheckingStage = 2;
                                    continue block8;
                                }
                                resinCheckingStage = 0;
                                continue block8;
                            }
                            case 2: {
                                if (DarkestUtil.isSpruceLog(stateToCheck)) continue block8;
                                if (blockToCheck == PrimalBlockRegistry.STRIPPED_SPRUCE_LOG) {
                                    resinSource = posToCheck;
                                    resinCheckingStage = 3;
                                    continue block8;
                                }
                                resinCheckingStage = 0;
                                continue block8;
                            }
                            case 3: {
                                if (blockToCheck == PrimalBlockRegistry.STRIPPED_SPRUCE_LOG) {
                                    resinSource = posToCheck;
                                    continue block8;
                                }
                                if (DarkestUtil.isSpruceLog(stateToCheck)) {
                                    resinCheckingStage = 4;
                                    continue block8;
                                }
                                resinCheckingStage = 0;
                                continue block8;
                            }
                            case 4: {
                                if (DarkestUtil.isSpruceLog(stateToCheck)) continue block8;
                                if (blockToCheck == PrimalBlockRegistry.STRIPPED_SPRUCE_LOG) {
                                    resinCheckingStage = 3;
                                    resinSource = posToCheck;
                                    continue block8;
                                }
                                if (blockToCheck instanceof BlockDirt) {
                                    world.func_175656_a(resinSource.func_177977_b(), BlockRegistry.LOG_SPRUCE_RESINOUS.func_176223_P().func_177226_a((IProperty)PrimalBlockLog.field_176298_M, (Comparable)EnumFacing.Axis.Y));
                                    resinCheckingStage = 0;
                                    continue block8;
                                }
                                resinCheckingStage = 0;
                                continue block8;
                            }
                            default: {
                                resinCheckingStage = 0;
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (!DarkestConfig.itemScarcity.requireSneaking || player.func_70093_af()) {
            IBlockState state = event.getState();
            float chance = DarkestConfig.itemScarcity.spruceConeDropChance;
            if (DarkestConfig.basicItems.allowSpruceConeTorches && DarkestUtil.isSpruceLeaf(state) && chance > 0.0f) {
                PrimalUtil.addDropWithChance((BlockEvent.HarvestDropsEvent)event, (Item)ItemRegistry.SPRUCE_CONE, (double)chance, (int)DarkestConfig.itemScarcity.spruceConeDropRate);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getResult() != Event.Result.DENY) {
            boolean addedStackToInventory;
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            Material material = state.func_185904_a();
            BlockPos destination = pos;
            EnumFacing faceClicked = event.getFace();
            if (faceClicked != null) {
                destination = destination.func_177972_a(faceClicked);
            }
            Item itemToBeGathered = null;
            int amount = 0;
            if (DarkestConfig.basicItems.allowResin && block == BlockRegistry.LOG_SPRUCE_RESINOUS) {
                world.func_175656_a(event.getPos(), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE));
                itemToBeGathered = ItemRegistry.RESIN;
                amount = DarkestConfig.itemScarcity.resinDropRate;
            }
            if (material == Material.field_151576_e || material == Material.field_151574_g || material == Material.field_151575_d || material == Material.field_151573_f) {
                ItemStack heldItem = event.getItemStack();
                if (DarkestConfig.basicItems.allowCharcoalDust && heldItem.func_77973_b() == Items.field_151044_h && heldItem.func_77960_j() == 1) {
                    heldItem.func_190918_g(1);
                    itemToBeGathered = ItemRegistry.DUST_CHARCOAL;
                    amount = DarkestConfig.itemScarcity.charcoalAmtCharcoal;
                } else if (DarkestConfig.basicItems.allowCaneTorches && heldItem.func_77973_b() == Items.field_151120_aE) {
                    heldItem.func_190918_g(1);
                    itemToBeGathered = ItemRegistry.FRAYED_CANE;
                    amount = 1;
                }
            }
            if (itemToBeGathered != null && !(addedStackToInventory = event.getEntityPlayer().func_191521_c(new ItemStack(itemToBeGathered, amount)))) {
                PrimalUtilSpawn.spawnEntityItem((World)world, (BlockPos)destination, (Item)itemToBeGathered, (int)amount);
            }
        }
    }

    @SubscribeEvent
    public void onEntityItemPickup(EntityItemPickupEvent event) {
        EntityItem entityItem = event.getItem();
        ItemStack itemStack = entityItem.func_92059_d();
        Item item = itemStack.func_77973_b();
        if (DarkestConfig.torchBehavior.torchCanOnlyBeHeldInHand) {
            EntityPlayer player = event.getEntityPlayer();
            if (itemStack.func_77973_b() instanceof ItemBlockTorchLit) {
                if (DarkestConfig.torchBehavior.preferOffHand && player.func_184592_cb().func_190926_b()) {
                    this.pickUpTorch(entityItem, itemStack, player, EnumHand.OFF_HAND);
                } else if (player.func_184614_ca().func_190926_b()) {
                    this.pickUpTorch(entityItem, itemStack, player, EnumHand.MAIN_HAND);
                } else if (player.func_184592_cb().func_190926_b()) {
                    this.pickUpTorch(entityItem, itemStack, player, EnumHand.OFF_HAND);
                }
                event.setCanceled(true);
            }
        }
        if (item == ItemRegistry.GLOWING_EMBER && !event.getEntityPlayer().func_184614_ca().func_190926_b()) {
            event.setCanceled(true);
        }
    }

    private void pickUpTorch(EntityItem entityItem, ItemStack itemStack, EntityPlayer player, EnumHand hand) {
        itemStack.func_77964_b(itemStack.func_77952_i() + entityItem.func_174872_o());
        player.func_184611_a(hand, itemStack);
        PrimalUtilSpawn.playSound((World)player.field_70170_p, (Entity)entityItem, (SoundEvent)SoundEvents.field_187638_cR);
        entityItem.func_70106_y();
    }
}

