/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.inventory;

import com.daeruin.darkestbeforedawn.tileentity.TileEntityCampfire;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStackHandlerCampfire
extends ItemStackHandler {
    private final TileEntityCampfire tileEntityCampfire;

    public ItemStackHandlerCampfire(TileEntityCampfire tileEntityCampfire) {
        super(3);
        this.tileEntityCampfire = tileEntityCampfire;
    }

    public int getSlotStackLimit(int slot) {
        int limit;
        switch (slot) {
            case 0: {
                limit = 1;
                break;
            }
            case 1: {
                limit = 4;
                break;
            }
            default: {
                limit = 64;
            }
        }
        return limit;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotStackLimit(slot), stack.func_77976_d());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            if (slot == 0) {
                this.tileEntityCampfire.setTotalCookTimeForInput(stack);
                this.tileEntityCampfire.setCookTimer(0);
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @ParametersAreNonnullByDefault
    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)((ItemStack)this.stacks.get(slot)), (ItemStack)stack)) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
        if (slot == 0) {
            this.tileEntityCampfire.setTotalCookTimeForInput(stack);
            this.tileEntityCampfire.setCookTimer(0);
        }
        this.onContentsChanged(slot);
    }
}

