/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.items;

import com.daeruin.darkestbeforedawn.blocks.BlockRegistry;
import com.daeruin.darkestbeforedawn.blocks.BlockTileEntityTorchLit;
import com.daeruin.darkestbeforedawn.config.DarkestConfig;
import com.daeruin.darkestbeforedawn.utilities.DarkestInvUtil;
import com.daeruin.darkestbeforedawn.utilities.DarkestUtil;
import com.daeruin.primallib.util.PrimalUtilSpawn;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBlockTorchLit
extends ItemBlock {
    public ItemBlockTorchLit() {
        super(BlockRegistry.TORCH_LIT);
        this.func_77656_e(BlockTileEntityTorchLit.LIFESPAN);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (DarkestUtil.isValidTorchPlacement(worldIn, pos)) {
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        return EnumActionResult.FAIL;
    }

    public void func_77663_a(ItemStack updatingStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityPlayerMP && !((EntityPlayer)entity).func_184812_l_()) {
            if (updatingStack.func_77973_b() instanceof ItemBlockTorchLit && DarkestConfig.torchBehavior.torchDuration > 0 && updatingStack.func_96631_a(1, world.field_73012_v, (EntityPlayerMP)entity) && world.func_72820_D() % 2L == 0L) {
                ItemStack replacementStack = new ItemStack(DarkestUtil.getTorchDrop());
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187658_bx, SoundCategory.NEUTRAL, 0.4f, 2.0f + DarkestUtil.random.nextFloat() * 0.4f);
                DarkestInvUtil.forEachEntityInventory(entity, inventory -> DarkestInvUtil.tryReplaceStack(inventory, itemSlot, updatingStack, replacementStack), DarkestInvUtil.EntityInventoryType.HAND, DarkestInvUtil.EntityInventoryType.MAIN);
            }
            if (world.func_72820_D() % 2L == 1L && updatingStack.func_77973_b() instanceof ItemBlockTorchLit && DarkestConfig.torchBehavior.torchCanOnlyBeHeldInHand) {
                ItemStack itemInMainHand = ((EntityPlayer)entity).func_184614_ca();
                ItemStack itemInOffHand = ((EntityPlayer)entity).func_184592_cb();
                if (updatingStack != itemInMainHand && updatingStack != itemInOffHand) {
                    EntityItem entityItem = new EntityItem(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, updatingStack);
                    world.func_72838_d((Entity)entityItem);
                    entity.func_174820_d(itemSlot, ItemStack.field_190927_a);
                }
            }
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return itemStack.func_77958_k() - itemStack.func_77952_i();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return false;
    }

    @Nullable
    public Entity createEntity(World world, Entity entity, ItemStack itemStack) {
        if (entity instanceof EntityItem) {
            return new EntityItem(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack);
        }
        return null;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.lifespan - entityItem.func_174872_o() == 1) {
            PrimalUtilSpawn.playSound((World)entityItem.field_70170_p, (Entity)entityItem, (SoundEvent)SoundEvents.field_187541_bC);
            PrimalUtilSpawn.spawnEntityItem((World)entityItem.field_70170_p, (BlockPos)entityItem.func_180425_c(), (Item)DarkestUtil.getTorchDrop(), (int)1);
        }
        return super.onEntityItemUpdate(entityItem);
    }
}

