/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.items;

import com.daeruin.darkestbeforedawn.blocks.BlockRegistry;
import com.daeruin.darkestbeforedawn.blocks.BlockTileEntityCampfire;
import com.daeruin.darkestbeforedawn.config.DarkestConfig;
import com.daeruin.darkestbeforedawn.utilities.DarkestUtil;
import com.daeruin.primallib.util.PrimalUtil;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemBlockTorchUnlit
extends ItemBlock {
    public ItemBlockTorchUnlit() {
        super(BlockRegistry.TORCH_UNLIT);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (DarkestUtil.isValidTorchPlacement(world, pos)) {
            return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        if (!world.field_72995_K) {
            for (String blockName : DarkestConfig.torchBehavior.ignitionSourcesForItem) {
                Block ignitionBlock = Block.func_149684_b((String)blockName);
                boolean shouldIgnite = false;
                if (ignitionBlock != null) {
                    IBlockState state = world.func_180495_p(pos);
                    Block blockClickedOn = state.func_177230_c();
                    if (ignitionBlock == Blocks.field_150480_ab) {
                        Block adjacentBlock = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
                        if (adjacentBlock == ignitionBlock) {
                            shouldIgnite = true;
                        }
                    } else if (ignitionBlock == BlockRegistry.CAMPFIRE && blockClickedOn == BlockRegistry.CAMPFIRE) {
                        BlockTileEntityCampfire.EnumCampfireState campfireState = (BlockTileEntityCampfire.EnumCampfireState)((Object)state.func_177229_b(BlockTileEntityCampfire.CAMPFIRE_STATE));
                        if (campfireState == BlockTileEntityCampfire.EnumCampfireState.BURNING || campfireState == BlockTileEntityCampfire.EnumCampfireState.COALS) {
                            shouldIgnite = true;
                        }
                    } else if (ignitionBlock == Blocks.field_150353_l || ignitionBlock == Blocks.field_150356_k) {
                        BlockPos rayBlockPos;
                        Material rayMaterial;
                        RayTraceResult ray = PrimalUtil.getRayTraceResultFromPlayer((World)world, (EntityLivingBase)player);
                        if (ray != null && ray.field_72313_a == RayTraceResult.Type.BLOCK && (rayMaterial = world.func_180495_p(rayBlockPos = ray.func_178782_a()).func_185904_a()) == Material.field_151587_i) {
                            shouldIgnite = true;
                        }
                    } else if (blockClickedOn == ignitionBlock) {
                        shouldIgnite = true;
                    }
                    if (!shouldIgnite) continue;
                    player.func_184586_b(hand).func_190918_g(1);
                    player.func_191521_c(new ItemStack(BlockRegistry.TORCH_LIT));
                    world.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    return EnumActionResult.SUCCESS;
                }
                System.out.println("Invalid ignition source in Darkest Before Dawn config.");
            }
        }
        return EnumActionResult.FAIL;
    }
}

