/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.recipes;

import com.daeruin.darkestbeforedawn.blocks.BlockRegistry;
import com.daeruin.darkestbeforedawn.config.DarkestConfig;
import com.daeruin.darkestbeforedawn.items.ItemRegistry;
import com.daeruin.primallib.blocks.PrimalBlockRegistry;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class CampfireRecipes {
    private static final CampfireRecipes INSTANCE = new CampfireRecipes();
    private final Map<ItemStack, ItemStack> cookingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();
    private final Map<ItemStack, Integer> cookTimeList = Maps.newHashMap();

    private CampfireRecipes() {
        int charcoalAmtLogs = DarkestConfig.itemScarcity.charcoalAmtLogs;
        IBlockState blockStateOak = Blocks.field_150364_r.func_176223_P();
        IBlockState blockStateSpruce = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
        IBlockState blockStateBirch = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
        IBlockState blockStateJungle = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState blockStateAcacia = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA);
        IBlockState blockStateDarkOak = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK);
        int metaOak = Blocks.field_150364_r.func_176201_c(blockStateOak);
        int metaSpruce = Blocks.field_150364_r.func_176201_c(blockStateSpruce);
        int metaBirch = Blocks.field_150364_r.func_176201_c(blockStateBirch);
        int metaJungle = Blocks.field_150364_r.func_176201_c(blockStateJungle);
        int metaAcacia = Blocks.field_150363_s.func_176201_c(blockStateAcacia);
        int metaDarkOak = Blocks.field_150363_s.func_176201_c(blockStateDarkOak);
        if (DarkestConfig.basicItems.allowUnlitTorches) {
            this.addCampfireRecipe(ItemRegistry.CLAY_BOWL_UNCOOKED, ItemRegistry.CLAY_BOWL, DarkestConfig.campfireBehavior.clayCookTime, 0.5f);
            this.addCampfireRecipe(ItemRegistry.CLAY_BOWL_FAT, ItemRegistry.CLAY_BOWL_FAT_RENDERED, 100, 0.1f);
            this.addCampfireRecipe(ItemRegistry.CLAY_BOWL_RESIN, ItemRegistry.CLAY_BOWL_RESIN_MELTED, 100, 0.1f);
        }
        this.addCampfireRecipe(new ItemStack(Blocks.field_150364_r, 1, metaOak), new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.oakBurnTime, 0.15f);
        this.addCampfireRecipe(new ItemStack(Blocks.field_150364_r, 1, metaSpruce), new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.spruceBurnTime, 0.15f);
        this.addCampfireRecipe(new ItemStack(Blocks.field_150364_r, 1, metaBirch), new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.birchBurnTime, 0.15f);
        this.addCampfireRecipe(new ItemStack(Blocks.field_150364_r, 1, metaJungle), new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.jungleBurnTime, 0.15f);
        this.addCampfireRecipe(new ItemStack(Blocks.field_150363_s, 1, metaAcacia), new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.acaciaBurnTime, 0.15f);
        this.addCampfireRecipe(new ItemStack(Blocks.field_150363_s, 1, metaDarkOak), new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.darkOakBurnTime, 0.15f);
        this.addCampfireRecipe(BlockRegistry.LOG_SPRUCE_RESINOUS, new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.spruceBurnTime, 0.15f);
        this.addCampfireRecipe(PrimalBlockRegistry.STRIPPED_ACACIA_LOG, new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.acaciaBurnTime, 0.15f);
        this.addCampfireRecipe(PrimalBlockRegistry.STRIPPED_BIRCH_LOG, new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.birchBurnTime, 0.15f);
        this.addCampfireRecipe(PrimalBlockRegistry.STRIPPED_DARK_OAK_LOG, new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.darkOakBurnTime, 0.15f);
        this.addCampfireRecipe(PrimalBlockRegistry.STRIPPED_JUNGLE_LOG, new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.jungleBurnTime, 0.15f);
        this.addCampfireRecipe(PrimalBlockRegistry.STRIPPED_OAK_LOG, new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.oakBurnTime, 0.15f);
        this.addCampfireRecipe(PrimalBlockRegistry.STRIPPED_SPRUCE_LOG, new ItemStack(ItemRegistry.DUST_CHARCOAL, charcoalAmtLogs), DarkestConfig.campfireBehavior.spruceBurnTime, 0.15f);
        this.addCampfireRecipe(Items.field_151147_al, new ItemStack(Items.field_151157_am), 200, 0.35f);
        this.addCampfireRecipe(Items.field_151082_bd, new ItemStack(Items.field_151083_be), 200, 0.35f);
        this.addCampfireRecipe(Items.field_151076_bf, new ItemStack(Items.field_151077_bg), 200, 0.35f);
        this.addCampfireRecipe(Items.field_179558_bo, new ItemStack(Items.field_179559_bp), 200, 0.35f);
        this.addCampfireRecipe(Items.field_179561_bm, new ItemStack(Items.field_179557_bn), 200, 0.35f);
        this.addCampfireRecipe(Items.field_151174_bG, new ItemStack(Items.field_151168_bH), 200, 0.35f);
        for (ItemFishFood.FishType fishType : ItemFishFood.FishType.values()) {
            if (!fishType.func_150973_i()) continue;
            this.addCampfireRecipe(new ItemStack(Items.field_151115_aP, 1, fishType.func_150976_a()), new ItemStack(Items.field_179566_aV, 1, fishType.func_150976_a()), 200, 0.35f);
        }
        this.addCampfireRecipe(Items.field_151119_aD, new ItemStack(Items.field_151118_aC), DarkestConfig.campfireBehavior.clayCookTime, 0.3f);
        this.addCampfireRecipe((Block)Blocks.field_150434_aF, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.GREEN.func_176767_b()), 200, 0.2f);
        this.addCampfireRecipe(new ItemStack(Blocks.field_150360_v, 1, 1), new ItemStack(Blocks.field_150360_v, 1, 0), 500, 0.15f);
        this.addCampfireRecipe(Items.field_185161_cS, new ItemStack(Items.field_185162_cT), 200, 0.1f);
    }

    public static CampfireRecipes instance() {
        return INSTANCE;
    }

    private void addCampfireRecipe(Block input, ItemStack result, int cookTime, float experience) {
        this.addCampfireRecipe(Item.func_150898_a((Block)input), result, cookTime, experience);
    }

    private void addCampfireRecipe(Item input, ItemStack result, int cookTime, float experience) {
        this.addCampfireRecipe(new ItemStack(input, 1, Short.MAX_VALUE), result, cookTime, experience);
    }

    private void addCampfireRecipe(Item input, Item result, int cookTime, float experience) {
        this.addCampfireRecipe(new ItemStack(input, 1, Short.MAX_VALUE), new ItemStack(result), cookTime, experience);
    }

    private void addCampfireRecipe(ItemStack input, ItemStack result, int cookTime, float experience) {
        if (this.getCookingResult(input) != ItemStack.field_190927_a) {
            FMLLog.log.info("Ignored smelting recipe with conflicting input: {} = {}", (Object)input, (Object)result);
            return;
        }
        this.cookingList.put(input, result);
        this.cookTimeList.put(input, cookTime);
        this.experienceList.put(result, Float.valueOf(experience));
    }

    public ItemStack getCookingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.cookingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    public int getTotalCookTime(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> entry : this.cookTimeList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return 0;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public float getCookingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

