/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.tileentity;

import com.daeruin.darkestbeforedawn.blocks.BlockRegistry;
import com.daeruin.darkestbeforedawn.blocks.BlockTileEntityCampfire;
import com.daeruin.darkestbeforedawn.blocks.BlockTorchUnlit;
import com.daeruin.darkestbeforedawn.config.DarkestConfig;
import com.daeruin.darkestbeforedawn.inventory.ItemStackHandlerCampfire;
import com.daeruin.darkestbeforedawn.recipes.CampfireRecipes;
import com.daeruin.primallib.blocks.PrimalBlockRegistry;
import com.daeruin.primallib.util.PrimalUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityCampfire
extends TileEntity
implements ITickable {
    private static final int MAX_COAL_TIME = 3600;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int FIELD_BURN_TIME_INITIAL = 0;
    public static final int FIELD_BURN_TIME_REMAINING = 1;
    public static final int FIELD_COOK_TIME = 2;
    public static final int FIELD_TOTAL_COOK_TIME = 3;
    private final ItemStackHandler inventory = new ItemStackHandlerCampfire(this);
    private int burnTimeInitial;
    private int burnTimeRemaining;
    private int cookTimer;
    private int totalCookTime;
    private int stokeTimer;
    private int timesBlown;
    private int coalsCoolDown;

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(TileEntityCampfire inventory) {
        return inventory.getField(1) > 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityCampfire.getItemBurnTime(stack) > 0;
    }

    private static int getItemBurnTime(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Item itemToBurn = stack.func_77973_b();
            for (String campfireFuel : DarkestConfig.campfireBehavior.campfireFuel) {
                try {
                    String[] campfireFuelParsed = campfireFuel.split(",");
                    if (campfireFuelParsed.length == 0) {
                        System.err.println("Campfire fuel " + campfireFuel + " is not structured correctly. Please fix your config file.");
                        continue;
                    }
                    String fuelName = campfireFuelParsed[0];
                    int fuelBurnTime = Integer.parseInt(campfireFuelParsed[1]);
                    Block blockFromConfig = Block.func_149684_b((String)fuelName);
                    Item itemFromConfig = blockFromConfig != null ? Item.func_150898_a((Block)blockFromConfig) : Item.func_111206_d((String)fuelName);
                    if (itemFromConfig == null || itemToBurn != itemFromConfig) continue;
                    return fuelBurnTime;
                }
                catch (Exception exception) {
                    System.err.println("Failed to parse " + campfireFuel + ". " + exception);
                }
            }
            Block block = Block.func_149634_a((Item)itemToBurn);
            if (block instanceof BlockOldLog || block instanceof BlockNewLog) {
                int meta = stack.func_77960_j();
                IBlockState state = block.func_176203_a(meta);
                BlockPlanks.EnumType logType = PrimalUtil.getLogEnumType((IBlockState)state);
                switch (logType) {
                    case ACACIA: {
                        return DarkestConfig.campfireBehavior.acaciaBurnTime;
                    }
                    case BIRCH: {
                        return DarkestConfig.campfireBehavior.birchBurnTime;
                    }
                    case DARK_OAK: {
                        return DarkestConfig.campfireBehavior.darkOakBurnTime;
                    }
                    case JUNGLE: {
                        return DarkestConfig.campfireBehavior.jungleBurnTime;
                    }
                    case OAK: {
                        return DarkestConfig.campfireBehavior.oakBurnTime;
                    }
                    case SPRUCE: {
                        return DarkestConfig.campfireBehavior.darkOakBurnTime;
                    }
                }
            } else {
                if (block == PrimalBlockRegistry.STRIPPED_ACACIA_LOG) {
                    return DarkestConfig.campfireBehavior.acaciaBurnTime;
                }
                if (block == PrimalBlockRegistry.STRIPPED_BIRCH_LOG) {
                    return DarkestConfig.campfireBehavior.birchBurnTime;
                }
                if (block == PrimalBlockRegistry.STRIPPED_DARK_OAK_LOG) {
                    return DarkestConfig.campfireBehavior.darkOakBurnTime;
                }
                if (block == PrimalBlockRegistry.STRIPPED_JUNGLE_LOG) {
                    return DarkestConfig.campfireBehavior.jungleBurnTime;
                }
                if (block == PrimalBlockRegistry.STRIPPED_OAK_LOG) {
                    return DarkestConfig.campfireBehavior.oakBurnTime;
                }
                if (block == PrimalBlockRegistry.STRIPPED_SPRUCE_LOG) {
                    return DarkestConfig.campfireBehavior.spruceBurnTime;
                }
                if (block == BlockRegistry.LOG_SPRUCE_RESINOUS) {
                    return DarkestConfig.campfireBehavior.spruceBurnTime;
                }
            }
        }
        return 0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.getBurnTimeInitial();
            }
            case 1: {
                return this.getBurnTimeRemaining();
            }
            case 2: {
                return this.getCookTimer();
            }
            case 3: {
                return this.getTotalCookTime();
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.setBurnTimeInitial(value);
                break;
            }
            case 1: {
                this.setBurnTimeRemaining(value);
                break;
            }
            case 2: {
                this.setCookTimer(value);
                break;
            }
            case 3: {
                this.setTotalCookTime(value);
            }
        }
    }

    public int getFieldCount() {
        return 4;
    }

    private boolean isBurning() {
        return this.getBurnTimeRemaining() > 0;
    }

    public void func_73660_a() {
        boolean isBurningAtStart = this.isBurning();
        boolean stateHasChanged = false;
        BlockTileEntityCampfire.EnumCampfireState campfireState = (BlockTileEntityCampfire.EnumCampfireState)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockTileEntityCampfire.CAMPFIRE_STATE));
        if (this.isBurning()) {
            this.setBurnTimeRemaining(this.getBurnTimeRemaining() - 1);
            if (this.field_145850_b.func_175727_C(this.func_174877_v().func_177984_a())) {
                this.setBurnTimeRemaining(MathHelper.func_76125_a((int)(this.getBurnTimeRemaining() - 7), (int)0, (int)this.getBurnTimeInitial()));
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelItem = this.inventory.getStackInSlot(1);
            ItemStack outputItem = this.inventory.getStackInSlot(2);
            if (campfireState == BlockTileEntityCampfire.EnumCampfireState.BURNING && !this.isBurning()) {
                if (this.field_145850_b.func_175727_C(this.func_174877_v().func_177984_a()) && !fuelItem.func_190926_b()) {
                    this.inventory.extractItem(1, fuelItem.func_190916_E(), false);
                    EntityItem entity = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), fuelItem);
                    this.field_145850_b.func_72838_d((Entity)entity);
                }
                if (fuelItem.func_190926_b()) {
                    BlockTileEntityCampfire.setCampfireState(this.field_145850_b, this.field_174879_c, BlockTileEntityCampfire.EnumCampfireState.COALS);
                }
            }
            if (campfireState == BlockTileEntityCampfire.EnumCampfireState.TINDER_STOKED || campfireState == BlockTileEntityCampfire.EnumCampfireState.KINDLING_STOKED) {
                if (this.getStokeTimer() > 0) {
                    this.setStokeTimer(this.getStokeTimer() - 1);
                }
                if (this.getStokeTimer() == 0) {
                    this.setTimesBlown(0);
                    if (campfireState == BlockTileEntityCampfire.EnumCampfireState.TINDER_STOKED) {
                        BlockTileEntityCampfire.setCampfireState(this.field_145850_b, this.field_174879_c, BlockTileEntityCampfire.EnumCampfireState.TINDER);
                    }
                    if (campfireState == BlockTileEntityCampfire.EnumCampfireState.KINDLING_STOKED) {
                        BlockTileEntityCampfire.setCampfireState(this.field_145850_b, this.field_174879_c, BlockTileEntityCampfire.EnumCampfireState.KINDLING);
                    }
                }
            }
            if (this.isBurning() || !fuelItem.func_190926_b()) {
                if (!this.isBurning() && !this.field_145850_b.func_175727_C(this.func_174877_v().func_177984_a())) {
                    this.setBurnTimeRemaining(TileEntityCampfire.getItemBurnTime(fuelItem));
                    this.setBurnTimeInitial(this.getBurnTimeRemaining());
                    if (this.isBurning()) {
                        stateHasChanged = true;
                        if (PrimalUtil.isLog((Block)Block.func_149634_a((Item)fuelItem.func_77973_b()))) {
                            this.setCoalsCoolDown(MathHelper.func_76125_a((int)(this.getCoalsCoolDown() + 600), (int)0, (int)3600));
                        }
                        this.inventory.extractItem(1, 1, false);
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ItemStack inputStack = this.inventory.getStackInSlot(0);
                    this.setCookTimer(this.getCookTimer() + 1);
                    if (this.getCookTimer() == this.getTotalCookTime()) {
                        this.setCookTimer(0);
                        this.setTotalCookTimeForInput(inputStack);
                        this.smeltItem();
                        stateHasChanged = true;
                    }
                } else {
                    this.setCookTimer(0);
                }
            } else if (!(this.isBurning() || this.getCookTimer() <= 0 || campfireState == BlockTileEntityCampfire.EnumCampfireState.COALS && Math.random() < 0.75)) {
                this.setCookTimer(MathHelper.func_76125_a((int)(this.getCookTimer() - 1), (int)0, (int)this.getTotalCookTime()));
            }
            if (campfireState == BlockTileEntityCampfire.EnumCampfireState.COALS) {
                if (this.getCoalsCoolDown() > 0) {
                    this.setCoalsCoolDown(this.getCoalsCoolDown() - 1);
                    if (this.field_145850_b.func_175727_C(this.func_174877_v().func_177984_a())) {
                        this.setCoalsCoolDown(MathHelper.func_76125_a((int)(this.getCoalsCoolDown() - 5), (int)0, (int)3600));
                    }
                }
                if (this.getCoalsCoolDown() <= 0) {
                    this.setBurnTimeInitial(0);
                    this.setCoalsCoolDown(0);
                    BlockTileEntityCampfire.setCampfireState(this.field_145850_b, this.field_174879_c, BlockTileEntityCampfire.EnumCampfireState.ASHES);
                    if (!outputItem.func_190926_b()) {
                        this.expelInventory();
                    }
                }
            }
            if (isBurningAtStart != this.isBurning()) {
                stateHasChanged = true;
                this.setStokeTimer(0);
                this.setTimesBlown(0);
                BlockTileEntityCampfire.setCampfireState(this.field_145850_b, this.field_174879_c, BlockTileEntityCampfire.EnumCampfireState.BURNING);
            }
        }
        if (stateHasChanged) {
            this.func_70296_d();
        }
    }

    public void expelInventory() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (stackInSlot.func_190926_b() || stackInSlot.func_190916_E() == 0) continue;
            this.inventory.extractItem(i, stackInSlot.func_190916_E(), false);
            EntityItem entity = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), stackInSlot);
            this.field_145850_b.func_72838_d((Entity)entity);
        }
    }

    private boolean canSmelt() {
        ItemStack inputStack = this.inventory.getStackInSlot(0);
        if (inputStack.func_190926_b()) {
            return false;
        }
        ItemStack smeltingResultOfInput = CampfireRecipes.instance().getCookingResult(inputStack);
        ItemStack outputStack = this.inventory.getStackInSlot(2);
        if (smeltingResultOfInput.func_190926_b()) {
            return false;
        }
        if (outputStack.func_190926_b()) {
            return true;
        }
        if (!outputStack.func_77969_a(smeltingResultOfInput)) {
            return false;
        }
        int combinedSize = outputStack.func_190916_E() + smeltingResultOfInput.func_190916_E();
        return combinedSize <= ((ItemStackHandlerCampfire)this.inventory).getSlotStackLimit(2) && combinedSize <= outputStack.func_77976_d();
    }

    private void smeltItem() {
        ItemStack outputStack = this.inventory.getStackInSlot(2);
        ItemStack inputStack = this.inventory.getStackInSlot(0);
        if (this.canSmelt()) {
            ItemStack smeltingResult = CampfireRecipes.instance().getCookingResult(inputStack);
            if (outputStack.func_190926_b()) {
                this.inventory.setStackInSlot(2, smeltingResult.func_77946_l());
            } else if (outputStack.func_77973_b() == smeltingResult.func_77973_b()) {
                outputStack.func_190917_f(smeltingResult.func_190916_E());
            }
            this.inventory.extractItem(0, 1, false);
        }
    }

    public boolean insertHeldItem(EntityPlayer player, EnumHand hand) {
        int destinationSlot;
        ItemStack heldItem = player.func_184586_b(hand);
        if (TileEntityCampfire.isItemFuel(heldItem) && !(Block.func_149634_a((Item)heldItem.func_77973_b()) instanceof BlockTorchUnlit)) {
            destinationSlot = 1;
        } else if (!CampfireRecipes.instance().getCookingResult(heldItem).func_190926_b() & this.isBurning()) {
            destinationSlot = 0;
        } else {
            return false;
        }
        ItemStack remainder = this.inventory.insertItem(destinationSlot, heldItem, true);
        int initialCount = heldItem.func_190916_E();
        if (remainder.func_190916_E() < initialCount) {
            this.inventory.insertItem(destinationSlot, heldItem, false);
            player.func_184611_a(hand, remainder);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return !(oldState.func_177230_c() instanceof BlockTileEntityCampfire) || !(newState.func_177230_c() instanceof BlockTileEntityCampfire);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("BurnTime", this.getBurnTimeRemaining());
        compound.func_74768_a("BurnTimeInit", this.getBurnTimeInitial());
        compound.func_74768_a("CookTime", this.getCookTimer());
        compound.func_74768_a("CookTimeTotal", this.getTotalCookTime());
        compound.func_74768_a("TinderStokeTime", this.getStokeTimer());
        compound.func_74768_a("TinderTimesBlown", this.getTimesBlown());
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.setBurnTimeRemaining(compound.func_74762_e("BurnTime"));
        this.setBurnTimeInitial(compound.func_74762_e("BurnTimeInit"));
        this.setCookTimer(compound.func_74762_e("CookTime"));
        this.setTotalCookTime(compound.func_74762_e("CookTimeTotal"));
        this.setStokeTimer(compound.func_74762_e("TinderStokeTime"));
        this.setTimesBlown(compound.func_74762_e("TinderTimesBlown"));
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        super.func_145839_a(compound);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public int getStokeTimer() {
        return this.stokeTimer;
    }

    public void setStokeTimer(int stokeTimer) {
        this.stokeTimer = stokeTimer;
    }

    public int getTimesBlown() {
        return this.timesBlown;
    }

    public void setTimesBlown(int timesBlown) {
        this.timesBlown = timesBlown;
    }

    public int getBurnTimeInitial() {
        return this.burnTimeInitial;
    }

    public void setBurnTimeInitial(int burnTimeInitial) {
        this.burnTimeInitial = burnTimeInitial;
    }

    public int getBurnTimeRemaining() {
        return this.burnTimeRemaining;
    }

    public void setBurnTimeRemaining(int burnTimeRemaining) {
        this.burnTimeRemaining = burnTimeRemaining;
    }

    private int getCoalsCoolDown() {
        return this.coalsCoolDown;
    }

    public void setCoalsCoolDown(int coalsCoolDown) {
        this.coalsCoolDown = coalsCoolDown;
    }

    public int getCookTimer() {
        return this.cookTimer;
    }

    public void setCookTimer(int cookTimer) {
        this.cookTimer = cookTimer;
    }

    public int getTotalCookTime() {
        return this.totalCookTime;
    }

    private void setTotalCookTime(int totalCookTime) {
        this.totalCookTime = totalCookTime;
    }

    public void setTotalCookTimeForInput(ItemStack stack) {
        this.totalCookTime = CampfireRecipes.instance().getTotalCookTime(stack);
    }
}

