/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.tileentity;

import com.daeruin.darkestbeforedawn.blocks.BlockDarkestFurnace;
import com.daeruin.darkestbeforedawn.inventory.ContainerDarkestFurnace;
import com.daeruin.darkestbeforedawn.items.ItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileEntityDarkestFurnace
extends TileEntityFurnace {
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_OUTPUT = 2;
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private int stokeTime;

    public static int getFuelBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == ItemRegistry.TINDER) {
            return 1;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150376_bx)) {
            return 150;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150468_ap)) {
            return 300;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150471_bO)) {
            return 50;
        }
        if (Block.func_149634_a((Item)item).func_176223_P().func_185904_a() == Material.field_151575_d) {
            return 300;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
            return 16000;
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 200;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 200;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 50;
        }
        if (item != Items.field_151031_f && item != Items.field_151112_aM) {
            if (item == Items.field_151155_ap) {
                return 200;
            }
            if (item == Items.field_151044_h) {
                return 1600;
            }
            if (item == Items.field_151129_at) {
                return 20000;
            }
            if (item != Item.func_150898_a((Block)Blocks.field_150345_g) && item != Items.field_151054_z) {
                if (item == Items.field_151072_bj) {
                    return 2400;
                }
                if (item instanceof ItemDoor && item != Items.field_151139_aw) {
                    return 200;
                }
                return item instanceof ItemBoat ? 400 : 0;
            }
            return 100;
        }
        return 300;
    }

    @Nonnull
    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDarkestFurnace(playerInventory, (IInventory)this);
    }

    public void setStokeTime(int stokeTime) {
        this.stokeTime = stokeTime;
    }

    private boolean isStoked() {
        return this.stokeTime > 0;
    }

    @ParametersAreNonnullByDefault
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack fuelItemStack = (ItemStack)this.furnaceItemStacks.get(1);
        return TileEntityDarkestFurnace.getFuelBurnTime(stack) > 0 || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && fuelItemStack.func_77973_b() != Items.field_151133_ar;
    }

    public void func_73660_a() {
        boolean isBurningAtStart = this.func_145950_i();
        boolean stateHasChanged = false;
        if (this.func_145950_i()) {
            --this.furnaceBurnTime;
        }
        if (this.isStoked()) {
            --this.stokeTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelItem = (ItemStack)this.furnaceItemStacks.get(1);
            if (this.func_145950_i() || this.isStoked() && !fuelItem.func_190926_b()) {
                if (!this.func_145950_i() && this.isStoked() && !fuelItem.func_190926_b()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityDarkestFurnace.getFuelBurnTime(fuelItem);
                    this.stokeTime = 0;
                    if (this.func_145950_i()) {
                        stateHasChanged = true;
                        if (!fuelItem.func_190926_b()) {
                            Item item = fuelItem.func_77973_b();
                            fuelItem.func_190918_g(1);
                            if (fuelItem.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(fuelItem);
                                this.furnaceItemStacks.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (this.func_145950_i() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.func_174904_a((ItemStack)this.furnaceItemStacks.get(0));
                        this.func_145949_j();
                        stateHasChanged = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.func_145950_i() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (isBurningAtStart != this.func_145950_i()) {
                stateHasChanged = true;
                BlockDarkestFurnace.func_176446_a((boolean)this.func_145950_i(), (World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
        }
        if (stateHasChanged) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
        if (smeltingResult.func_190926_b()) {
            return false;
        }
        ItemStack stackInOutputSlot = (ItemStack)this.furnaceItemStacks.get(2);
        int combinedSize = stackInOutputSlot.func_190916_E() + smeltingResult.func_190916_E();
        if (stackInOutputSlot.func_190926_b()) {
            return true;
        }
        if (!stackInOutputSlot.func_77969_a(smeltingResult)) {
            return false;
        }
        if (combinedSize <= this.func_70297_j_() && combinedSize <= stackInOutputSlot.func_77976_d()) {
            return true;
        }
        return combinedSize <= smeltingResult.func_77976_d();
    }
}

