/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.utilities;

import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;

public class DarkestInvUtil {
    @Nullable
    private static IItemHandler getMainInventory(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        }
        return null;
    }

    @Nullable
    private static IItemHandler getHandInventory(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return new PlayerOffhandInvWrapper(((EntityPlayer)entity).field_71071_by);
        }
        return (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
    }

    @Nullable
    private static IItemHandler getArmourInventory(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return new PlayerArmorInvWrapper(((EntityPlayer)entity).field_71071_by);
        }
        return (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
    }

    @Nullable
    private static IItemHandler getInventoryForType(Entity entity, EntityInventoryType inventoryType) {
        switch (inventoryType) {
            case MAIN: {
                return DarkestInvUtil.getMainInventory(entity);
            }
            case HAND: {
                return DarkestInvUtil.getHandInventory(entity);
            }
            case ARMOUR: {
                return DarkestInvUtil.getArmourInventory(entity);
            }
        }
        return null;
    }

    public static void forEachEntityInventory(Entity entity, Predicate<IItemHandler> operation, EntityInventoryType ... inventoryTypes) {
        for (EntityInventoryType inventoryType : inventoryTypes) {
            IItemHandler inventory = DarkestInvUtil.getInventoryForType(entity, inventoryType);
            if (inventory == null || !operation.test(inventory)) continue;
            return;
        }
    }

    public static boolean tryReplaceStack(IItemHandler inventory, int slot, ItemStack targetStack, ItemStack replacementStack) {
        ItemStack stackInSlot = inventory.getStackInSlot(slot);
        if (slot < inventory.getSlots() && stackInSlot == targetStack && !inventory.extractItem(slot, targetStack.func_190916_E(), true).func_190926_b()) {
            inventory.extractItem(slot, targetStack.func_190916_E(), false);
            inventory.insertItem(slot, replacementStack, false);
            return true;
        }
        return false;
    }

    public static enum EntityInventoryType {
        MAIN,
        HAND,
        ARMOUR;


        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

