/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.darkestbeforedawn.utilities;

import com.daeruin.darkestbeforedawn.config.DarkestConfig;
import com.daeruin.primallib.config.PrimalConfig;
import com.daeruin.primallib.items.PrimalItemRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DarkestUtil {
    public static final Random random = new Random();
    private static final Material[] VALID_TORCH_SUPPORT = new Material[]{Material.field_151571_B, Material.field_151596_z, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y};

    public static boolean isValidTorchPlacement(World worldIn, BlockPos pos) {
        for (Material material : VALID_TORCH_SUPPORT) {
            if (worldIn.func_180495_p(pos).func_185904_a() != material) continue;
            return true;
        }
        return false;
    }

    public static void validateTorchReplacement() {
        String replacementBlock;
        if (!DarkestConfig.basicItems.allowVanillaTorches && !(replacementBlock = DarkestConfig.basicItems.replacementForVanillaTorches).equals("") && Block.func_149684_b((String)replacementBlock) == null) {
            System.out.println("Darkest Before Dawn: You set vanilla Minecraft torches to be replaced with '" + replacementBlock + "', which is an invalid block.");
            System.out.println("Darkest Before Dawn: This will result in vanilla torches being deleted. Please fix your config file.");
        }
    }

    @Nullable
    public static Item getTorchDrop() {
        if (random.nextFloat() < DarkestConfig.torchBehavior.torchDropChance) {
            if (PrimalConfig.BRANCHES_AND_SHAFTS.allowWoodenShafts && !PrimalConfig.BRANCHES_AND_SHAFTS.sticksCountAsShafts) {
                return PrimalItemRegistry.WOODEN_SHAFT;
            }
            return Items.field_151055_y;
        }
        return null;
    }

    public static boolean isSpruceLeaf(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150362_t && state == state.func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE);
    }

    public static boolean isSpruceLog(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150364_r && state == state.func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
    }
}

