/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.primallib.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="primallib", category="")
public class PrimalConfig {
    private static final String LANG_KEY_PREFIX = "config.primallib:";
    private static final String LANG_KEY_PREFIX_BASICS = "config.primallib:basics";
    private static final String LANG_KEY_PREFIX_BARK = "config.primallib:bark_and_stripped_logs";
    private static final String LANG_KEY_PREFIX_BRANCHES = "config.primallib:branches_and_shafts";
    private static final String LANG_KEY_PREFIX_CORDAGE = "config.primallib:cordage";
    private static final String LANG_KEY_PREFIX_PLANT_FIBERS = "config.primallib:plant_fibers";
    private static final String LANG_KEY_PREFIX_TWIGS = "config.primallib:twigs";
    @Config.Name(value="Basics")
    @Config.LangKey(value="config.primallib:basics")
    public static final Basics BASICS = new Basics();
    @Config.Name(value="Bark and Stripped Logs")
    @Config.LangKey(value="config.primallib:bark_and_stripped_logs")
    public static final BarkAndStrippedLogs BARK_AND_STRIPPED_LOGS = new BarkAndStrippedLogs();
    @Config.Name(value="Branches and Shafts")
    @Config.LangKey(value="config.primallib:branches_and_shafts")
    public static final BranchesAndShafts BRANCHES_AND_SHAFTS = new BranchesAndShafts();
    @Config.Name(value="Cordage")
    @Config.LangKey(value="config.primallib:cordage")
    public static final Cordage CORDAGE = new Cordage();
    @Config.Name(value="Plant Fibers")
    @Config.LangKey(value="config.primallib:plant_fibers")
    public static final PlantFibers PLANT_FIBERS = new PlantFibers();
    @Config.Name(value="Twigs")
    @Config.LangKey(value="config.primallib:twigs")
    public static final Twigs TWIGS = new Twigs();

    @Mod.EventBusSubscriber
    private static class ConfigEventHandler {
        private ConfigEventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("primallib")) {
                ConfigManager.sync((String)"primallib", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Twigs {
        @Config.Name(value="Allow twigs")
        @Config.LangKey(value="config.primallib:twigsallow_twigs")
        @Config.Comment(value={"Whether twigs should drop from leaves. Disabling twigs will force Basket Case baskets to be made from vines or bark strips, if they are enabled. Wood-specific Basket Case baskets require either bark strips or twigs."})
        public boolean allowTwigs = true;
        @Config.Name(value="Twig drop count")
        @Config.LangKey(value="config.primallib:twigstwig_drop_count")
        @Config.Comment(value={"How many twigs should drop when breaking leaves."})
        @Config.RangeInt(min=0, max=100)
        public int twigDropCount = 1;
        @Config.Name(value="Twig drop chance varies by tool")
        @Config.LangKey(value="config.primallib:twigstwig_drop_chance_varies_by_tool")
        @Config.Comment(value={"Whether the chance of getting twigs should vary depending on the tool used. Setting this to false makes the next two settings have no effect."})
        public boolean twigDropChanceVariesByTool = true;
        @Config.Name(value="Twig drop chance with axe")
        @Config.LangKey(value="config.primallib:twigstwig_drop_chance_with_axe")
        @Config.Comment(value={"The chance that twigs should drop when breaking leaves with an axe.", "Min: 0.0", "Max: 1.0"})
        public float twigDropChanceWithAxe = 1.0f;
        @Config.Name(value="Twig drop chance with hands")
        @Config.LangKey(value="config.primallib:twigstwig_drop_chance_with_hands")
        @Config.Comment(value={"The chance that twigs should drop when breaking leaves with your bare hands.", "Min: 0.0", "Max: 1.0"})
        public float twigDropChanceWithBareHands = 0.5f;
    }

    public static class PlantFibers {
        @Config.Name(value="Allow plant fibers")
        @Config.LangKey(value="config.primallib:plant_fibersallow_plant_fibers")
        @Config.Comment(value={"Whether plant fibers should drop from tall grass."})
        public boolean allowPlantFibers = true;
        @Config.Name(value="Plant fibers drop count")
        @Config.LangKey(value="config.primallib:plant_fibersplant_fibers_drop_count")
        @Config.Comment(value={"How many plant fibers should drop when breaking tall grass."})
        @Config.RangeInt(min=0, max=100)
        public int plantFibersDropCount = 1;
        @Config.Name(value="Plant fiber drop chance varies by tool")
        @Config.LangKey(value="config.primallib:plant_fibersplant_fiber_drop_chance_varies_by_tool")
        @Config.Comment(value={"Whether the chance of getting plant fibers should vary depending on the tool used. Setting this to false makes the next three settings have no effect."})
        public boolean plantFiberDropChanceVariesByTool = true;
        @Config.Name(value="Plant fiber drop chance with axe")
        @Config.LangKey(value="config.primallib:plant_fibersplant_fiber_drop_chance_with_axe")
        @Config.Comment(value={"The chance that plant fibers should drop when breaking tall grass with an axe.", "Min: 0.0", "Max: 1.0"})
        public float plantFibersDropChanceWithAxe = 1.0f;
        @Config.Name(value="Plant fiber drop chance with hands")
        @Config.LangKey(value="config.primallib:plant_fibersplant_fiber_drop_chance_with_hands")
        @Config.Comment(value={"The chance that plant fibers should drop when breaking tall grass with your bare hands.", "Min: 0.0", "Max: 1.0"})
        public float plantFibersDropChanceWithBareHands = 0.5f;
        @Config.Name(value="Plant fiber drop chance with shovel")
        @Config.LangKey(value="config.primallib:plant_fibersplant_fiber_drop_chance_with_shovel")
        @Config.Comment(value={"The chance that plant fibers should drop when breaking tall grass with a shovel.", "Min: 0.0", "Max: 1.0"})
        public float plantFibersDropChanceWithShovel = 0.7f;
    }

    public static class Cordage {
        @Config.Name(value="Allow bark strips as cordage")
        @Config.LangKey(value="config.primallib:cordageallow_bark_strips_as_cordage")
        @Config.Comment(value={"Whether bark strips can be used as cordage in crafting recipes. Cordage is used in Basket Case to make wicker baskets."})
        public boolean allowBarkStripsAsCordage = true;
        @Config.Name(value="Allow plant fibers as cordage")
        @Config.LangKey(value="config.primallib:cordageallow_plant_fibers_as_cordage")
        @Config.Comment(value={"Whether cordage should be craftable from plant fibers. Cordage is used in Basket Case to make wicker baskets."})
        public boolean allowPlantFibersAsCordage = true;
        @Config.Name(value="Allow string as cordage")
        @Config.LangKey(value="config.primallib:cordageallow_string_as_cordage")
        @Config.Comment(value={"Whether string can be used as cordage in crafting recipes. Cordage is used in Basket Case to make wicker baskets."})
        public boolean allowStringAsCordage = false;
        @Config.Name(value="Allow sugar cane as cordage")
        @Config.LangKey(value="config.primallib:cordageallow_sugar_cane_as_cordage")
        @Config.Comment(value={"Whether sugar cane can be used as cordage in crafting recipes. Cordage is used in Basket Case to make wicker baskets."})
        public boolean allowSugarCaneAsCordage = true;
        @Config.Name(value="Allow vines as cordage")
        @Config.LangKey(value="config.primallib:cordageallow_vines_as_cordage")
        @Config.Comment(value={"Whether vines can be used as cordage in crafting recipes. Cordage is used in Basket Case to make wicker baskets."})
        public boolean allowVinesAsCordage = true;
    }

    public static class BranchesAndShafts {
        @Config.Name(value="Allow branches from leaves")
        @Config.LangKey(value="config.primallib:branches_and_shaftsallow_branches_from_leaves")
        @Config.Comment(value={"Whether branches should drop from leaves. Disabling branches will also disable wooden shafts, and the rest of the options in this section will have no effect."})
        public boolean allowBranches = false;
        @Config.Name(value="Branch drop count")
        @Config.LangKey(value="config.primallib:branches_and_shaftsbranch_drop_count")
        @Config.Comment(value={"How many branches should drop when breaking leaves."})
        @Config.RangeInt(min=0, max=100)
        public int branchDropCount = 1;
        @Config.Name(value="Branch drop chance varies by tool")
        @Config.LangKey(value="config.primallib:branches_and_shaftsbranch_drop_count_varies_by_tool")
        @Config.Comment(value={"Whether the chance of getting branches should vary depending on the tool used. Setting this to false makes the next two settings have no effect."})
        public boolean branchDropChanceVariesByTool = true;
        @Config.Name(value="Branch drop chance with axe")
        @Config.LangKey(value="config.primallib:branches_and_shaftsbranch_drop_chance_with_axe")
        @Config.Comment(value={"The chance that branches should drop when breaking leaves with an axe. Multiply by 100 to get % change, for example 0.2 = 20% chance.", "Min: 0.0", "Max: 1.0"})
        public float branchDropChanceWithAxe = 1.0f;
        @Config.Name(value="Branch drop chance with hands")
        @Config.LangKey(value="config.primallib:branches_and_shaftsbranch_drop_chance_with_hands")
        @Config.Comment(value={"The chance that branches should drop when breaking leaves with your bare hands.", "Min: 0.0", "Max: 1.0"})
        public float branchDropChanceWithBareHands = 0.2f;
        @Config.Name(value="Allow wooden shafts")
        @Config.LangKey(value="config.primallib:branches_and_shaftsallow_wooden_shafts")
        @Config.Comment(value={"Whether branches can be crafted into wooden shafts."})
        public boolean allowWoodenShafts = true;
        @Config.Name(value="Sticks count as shafts")
        @Config.LangKey(value="config.primallib:branches_and_shaftssticks_count_as_shafts")
        @Config.Comment(value={"Whether sticks can be used in place of shafts in crafting recipes. This setting doesn't have any practical use yet. It's for future functionality."})
        public boolean sticksCountAsShafts = false;
    }

    public static class BarkAndStrippedLogs {
        @Config.Name(value="Allow bark and stripped logs")
        @Config.LangKey(value="config.primallib:bark_and_stripped_logsallow_bark_and_stripped_logs")
        @Config.Comment(value={"Whether logs should produce bark when right-clicked wth an axe or put in the crafting grid with an axe. Disabling bark will also disable stripped logs and bark strips, and the other settings in this section will have no effect."})
        public boolean allowBarkAndStrippedLogs = true;
        @Config.Name(value="Craft bark strips from bark")
        @Config.LangKey(value="config.primallib:bark_and_stripped_logscraft_bark_strips_from_bark")
        @Config.Comment(value={"Whether bark strips should be craftable from bark. Disabling bark strips will force Basket Case baskets to be made from vines or twigs, if they are enabled. Wood-specific Basket Case baskets require either bark strips or twigs."})
        public boolean allowBarkStrips = true;
        @Config.Name(value="Craft planks from stripped logs")
        @Config.LangKey(value="config.primallib:bark_and_stripped_logscraft_planks_from_stripped_logs")
        @Config.Comment(value={"Whether stripped logs can be used to craft planks."})
        public boolean allowStrippedLogsToMakePlanks = true;
        @Config.Name(value="Plank recipe amount")
        @Config.LangKey(value="config.primallib:bark_and_stripped_logsplank_recipe_amount")
        @Config.Comment(value={"How many planks are produced when crafting planks from stripped logs."})
        @Config.RangeInt(min=0, max=64)
        public int plankAmount = 4;
        @Config.Name(value="Bark amount")
        @Config.LangKey(value="config.primallib:bark_and_stripped_logsbark_amount")
        @Config.Comment(value={"How many pieces of bark are produced when right-clicking logs with axe or when crafting from logs with axe."})
        @Config.RangeInt(min=0, max=64)
        public int barkAmount = 4;
        @Config.Name(value="Stripped log burn time")
        @Config.LangKey(value="config.primallib:bark_and_stripped_logsstripped_log_burn_time")
        @Config.Comment(value={"How many ticks a stripped log will burn in a furnace."})
        public int strippedLogBurnTime = 300;
    }

    public static class Basics {
        @Config.Name(value="Logs affect branch/twig drops")
        @Config.LangKey(value="config.primallib:basicslogs_affect_branch_twig_drops")
        @Config.Comment(value={"Branches only drop from leaves next to logs, and twigs only drop from leaves NOT next to logs."})
        public boolean branchTwigDependsOnLogProximity = true;
        @Config.Name(value="Cascading vine breakage")
        @Config.LangKey(value="config.primallib:basicscascading_vine_breakage")
        @Config.Comment(value={"Whether breaking a vine block automatically breaks all attached vine blocks directly below."})
        public boolean cascadingVineBreakage = true;
        @Config.Name(value="Must sneak for mod drops")
        @Config.LangKey(value="config.primallib:basicsmust_sneak_for_mod_drops")
        @Config.Comment(value={"Whether the player must be sneaking to get twigs, branches, and plant fibers. Set to true to give players more control over when they want to obtain these drops."})
        public boolean requireSneaking = false;
        @Config.Name(value="Enable Biomes O' Plenty integration")
        @Config.LangKey(value="config.primallib:basicsenable_biomes_o_plenty_integration")
        @Config.Comment(value={"When true, various Biomes O' Plenty grasses will drop plant fiber, and bushes and shrubs will drop twigs."})
        public boolean biomesOPlentyIntegration = false;
        @Config.Name(value="Enable No Tree Punching integration")
        @Config.LangKey(value="config.primallib:basicsenable_no_tree_punching_integration")
        @Config.Comment(value={"When true, hatchet and mattocks from No Tree Punching can get bark (but not planks) from a log, and saws can craft stripped logs into planks."})
        public boolean noTreePunchingIntegration = false;
    }
}

