/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.primallib.events;

import com.daeruin.primallib.blocks.PrimalBlockLog;
import com.daeruin.primallib.config.PrimalConfig;
import com.daeruin.primallib.items.PrimalItemRegistry;
import com.daeruin.primallib.util.PrimalUtil;
import com.daeruin.primallib.util.PrimalUtilSpawn;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PrimalEventHandler {
    @SubscribeEvent
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (!PrimalConfig.BASICS.requireSneaking || player.func_70093_af()) {
            ItemStack heldItemStack = player.func_184614_ca();
            Item heldItem = heldItemStack.func_77973_b();
            IBlockState blockState = event.getState();
            Block block = blockState.func_177230_c();
            float chance = 0.0f;
            if (PrimalConfig.PLANT_FIBERS.allowPlantFibers && (block instanceof BlockTallGrass || block instanceof BlockDoublePlant || PrimalConfig.BASICS.biomesOPlentyIntegration && PrimalUtil.dropsPlantFiber(blockState))) {
                if (PrimalConfig.PLANT_FIBERS.plantFiberDropChanceVariesByTool) {
                    if (heldItemStack.func_190926_b()) {
                        chance = PrimalConfig.PLANT_FIBERS.plantFibersDropChanceWithBareHands;
                    } else if (heldItem instanceof ItemSpade) {
                        chance = PrimalConfig.PLANT_FIBERS.plantFibersDropChanceWithShovel;
                    } else if (PrimalUtil.isAxe(heldItem)) {
                        chance = PrimalConfig.PLANT_FIBERS.plantFibersDropChanceWithAxe;
                    }
                } else {
                    chance = 1.0f;
                }
                if (chance > 0.0f) {
                    PrimalUtil.addDropWithChance(event, PrimalItemRegistry.PLANT_FIBER, chance, PrimalConfig.PLANT_FIBERS.plantFibersDropCount);
                }
            }
            if (block instanceof BlockLeaves && (PrimalConfig.TWIGS.allowTwigs || PrimalConfig.BRANCHES_AND_SHAFTS.allowBranches)) {
                boolean leafIsNextToLog = false;
                if (PrimalConfig.BASICS.branchTwigDependsOnLogProximity) {
                    BlockPos posOrigin = event.getPos();
                    for (EnumFacing direction : EnumFacing.field_82609_l) {
                        if (!PrimalUtil.isLog(event.getWorld(), posOrigin.func_177972_a(direction))) continue;
                        leafIsNextToLog = true;
                    }
                }
                if (PrimalConfig.TWIGS.allowTwigs && (!PrimalConfig.BASICS.branchTwigDependsOnLogProximity || !leafIsNextToLog) && (chance = this.getTwigDropChance(heldItemStack)) > 0.0f) {
                    Item itemToDrop = PrimalItemRegistry.TWIG_GENERIC;
                    PrimalUtil.addDropWithChance(event, itemToDrop, chance, PrimalConfig.TWIGS.twigDropCount);
                }
                if (PrimalConfig.BRANCHES_AND_SHAFTS.allowBranches && (!PrimalConfig.BASICS.branchTwigDependsOnLogProximity || leafIsNextToLog) && (chance = this.getBranchDropChance(heldItemStack)) > 0.0f) {
                    PrimalUtil.addDropWithChance(event, PrimalItemRegistry.BRANCH, chance, PrimalConfig.BRANCHES_AND_SHAFTS.branchDropCount);
                }
            }
            if (PrimalUtil.dropsTwigs(blockState) && PrimalConfig.TWIGS.allowTwigs && PrimalConfig.BASICS.biomesOPlentyIntegration && (chance = this.getTwigDropChance(heldItemStack)) > 0.0f) {
                Item itemToDrop = PrimalItemRegistry.TWIG_GENERIC;
                PrimalUtil.addDropWithChance(event, itemToDrop, chance, PrimalConfig.TWIGS.twigDropCount);
            }
        }
    }

    private float getTwigDropChance(ItemStack heldItemStack) {
        float chance = 0.0f;
        if (PrimalConfig.TWIGS.twigDropChanceVariesByTool) {
            if (heldItemStack.func_190926_b()) {
                chance = PrimalConfig.TWIGS.twigDropChanceWithBareHands;
            } else if (PrimalUtil.isAxe(heldItemStack.func_77973_b())) {
                chance = PrimalConfig.TWIGS.twigDropChanceWithAxe;
            }
        } else {
            chance = 1.0f;
        }
        return chance;
    }

    private float getBranchDropChance(ItemStack heldItemStack) {
        float chance = 0.0f;
        if (PrimalConfig.BRANCHES_AND_SHAFTS.branchDropChanceVariesByTool) {
            if (heldItemStack.func_190926_b()) {
                chance = PrimalConfig.BRANCHES_AND_SHAFTS.branchDropChanceWithBareHands;
            } else if (PrimalUtil.isAxe(heldItemStack.func_77973_b())) {
                chance = PrimalConfig.BRANCHES_AND_SHAFTS.branchDropChanceWithAxe;
            }
        } else {
            chance = 1.0f;
        }
        return chance;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (PrimalConfig.BARK_AND_STRIPPED_LOGS.allowBarkAndStrippedLogs && !event.getWorld().field_72995_K && event.getResult() != Event.Result.DENY) {
            EntityPlayer player = event.getEntityPlayer();
            World world = event.getWorld();
            EnumHand hand = event.getHand();
            Item heldItem = player.func_184586_b(hand).func_77973_b();
            BlockPos pos = event.getPos();
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof BlockLog && PrimalUtil.isAxe(heldItem)) {
                Item itemToDrop = PrimalUtil.getBark(state);
                Block targetBlock = PrimalUtil.getStrippedLog(state);
                for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
                    if (!Objects.equals(axis.func_176610_l(), ((BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a)).func_176610_l())) continue;
                    IBlockState targetState = targetBlock.func_176223_P().func_177226_a((IProperty)PrimalBlockLog.field_176298_M, (Comparable)axis);
                    world.func_175656_a(event.getPos(), targetState);
                    BlockPos barkDestination = pos;
                    EnumFacing faceClicked = event.getFace();
                    if (faceClicked != null) {
                        barkDestination = barkDestination.func_177972_a(faceClicked);
                    }
                    PrimalUtilSpawn.spawnEntityItem(world, barkDestination, itemToDrop, PrimalConfig.BARK_AND_STRIPPED_LOGS.barkAmount);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        if (PrimalConfig.BASICS.cascadingVineBreakage) {
            World world = event.getWorld();
            IBlockState state = event.getState();
            Block block = state.func_177230_c();
            EntityPlayer player = event.getPlayer();
            Item heldItem = player.func_184614_ca().func_77973_b();
            if (block instanceof BlockVine && PrimalUtil.isAxe(heldItem) && player.func_70093_af()) {
                BlockPos pos = event.getPos();
                Item itemToDrop = Item.func_150898_a((Block)Blocks.field_150395_bd);
                int count = BlockVine.func_176268_d((IBlockState)state);
                PrimalUtilSpawn.spawnEntityItem(world, pos, itemToDrop, count);
                pos = pos.func_177972_a(EnumFacing.DOWN);
                state = world.func_180495_p(pos);
                block = state.func_177230_c();
                ArrayList<BlockPos> vinesToDelete = new ArrayList<BlockPos>();
                count = 0;
                while (block instanceof BlockVine) {
                    vinesToDelete.add(pos);
                    count += BlockVine.func_176268_d((IBlockState)state);
                    pos = pos.func_177972_a(EnumFacing.DOWN);
                    state = world.func_180495_p(pos);
                    block = state.func_177230_c();
                }
                for (BlockPos vinePosToDelete : vinesToDelete) {
                    if (!(world.func_180495_p(vinePosToDelete).func_177230_c() instanceof BlockVine)) continue;
                    world.func_175698_g(vinePosToDelete);
                }
                PrimalUtilSpawn.spawnEntityItem(world, pos, itemToDrop, count);
            }
        }
    }

    @SubscribeEvent
    public void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (Block.func_149634_a((Item)event.getItemStack().func_77973_b()) instanceof PrimalBlockLog) {
            event.setBurnTime(PrimalConfig.BARK_AND_STRIPPED_LOGS.strippedLogBurnTime);
        }
    }
}

