/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.primallib.recipes;

import com.daeruin.primallib.blocks.PrimalBlockRegistry;
import com.daeruin.primallib.config.PrimalConfig;
import com.daeruin.primallib.items.PrimalItemRegistry;
import com.daeruin.primallib.util.PrimalUtilRecipe;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class OreDictRegistry {
    public static void registerOreDictEntries() {
        if (PrimalConfig.CORDAGE.allowPlantFibersAsCordage) {
            PrimalUtilRecipe.addAlternateIngredients("plantFiber", PrimalItemRegistry.PLANT_FIBER);
        }
        if (PrimalConfig.CORDAGE.allowVinesAsCordage) {
            PrimalUtilRecipe.addAlternateIngredients("cordageStrong", Blocks.field_150395_bd);
            PrimalUtilRecipe.addAlternateIngredients("cordage", Blocks.field_150395_bd);
        }
        if (PrimalConfig.CORDAGE.allowSugarCaneAsCordage) {
            PrimalUtilRecipe.addAlternateIngredients("plantFiber", Items.field_151120_aE);
        }
        if (PrimalConfig.CORDAGE.allowBarkStripsAsCordage) {
            PrimalUtilRecipe.addAlternateIngredients("cordageStrong", PrimalItemRegistry.BARK_STRIPS_GENERIC);
            PrimalUtilRecipe.addAlternateIngredients("cordage", PrimalItemRegistry.BARK_STRIPS_GENERIC);
        }
        if (PrimalConfig.CORDAGE.allowStringAsCordage) {
            PrimalUtilRecipe.addAlternateIngredients("cordageWeak", Items.field_151007_F);
            PrimalUtilRecipe.addAlternateIngredients("cordage", Items.field_151007_F);
        }
        PrimalUtilRecipe.addAlternateIngredients("string", PrimalItemRegistry.TWINE);
        PrimalUtilRecipe.addAlternateIngredients("cordageWeak", PrimalItemRegistry.TWINE);
        PrimalUtilRecipe.addAlternateIngredients("cordage", PrimalItemRegistry.TWINE);
        PrimalUtilRecipe.addAlternateIngredients("twig", PrimalItemRegistry.TWIG_GENERIC);
        PrimalUtilRecipe.addAlternateIngredients("barkStrips", PrimalItemRegistry.BARK_STRIPS_GENERIC);
        PrimalUtilRecipe.addAlternateIngredients("barkWood", PrimalItemRegistry.OAK_BARK, PrimalItemRegistry.SPRUCE_BARK, PrimalItemRegistry.BIRCH_BARK, PrimalItemRegistry.JUNGLE_BARK, PrimalItemRegistry.ACACIA_BARK, PrimalItemRegistry.DARK_OAK_BARK);
        PrimalUtilRecipe.addAlternateIngredients("barkOak", PrimalItemRegistry.OAK_BARK);
        PrimalUtilRecipe.addAlternateIngredients("barkSpruce", PrimalItemRegistry.SPRUCE_BARK);
        PrimalUtilRecipe.addAlternateIngredients("barkBirch", PrimalItemRegistry.BIRCH_BARK);
        PrimalUtilRecipe.addAlternateIngredients("barkJungle", PrimalItemRegistry.JUNGLE_BARK);
        PrimalUtilRecipe.addAlternateIngredients("barkAcacia", PrimalItemRegistry.ACACIA_BARK);
        PrimalUtilRecipe.addAlternateIngredients("barkDarkOak", PrimalItemRegistry.DARK_OAK_BARK);
        PrimalUtilRecipe.addAlternateIngredients("logWood", PrimalBlockRegistry.STRIPPED_OAK_LOG, PrimalBlockRegistry.STRIPPED_SPRUCE_LOG, PrimalBlockRegistry.STRIPPED_BIRCH_LOG, PrimalBlockRegistry.STRIPPED_JUNGLE_LOG, PrimalBlockRegistry.STRIPPED_ACACIA_LOG, PrimalBlockRegistry.STRIPPED_DARK_OAK_LOG);
        PrimalUtilRecipe.addAlternateIngredients("stickWood", PrimalItemRegistry.WOODEN_SHAFT);
        PrimalUtilRecipe.addAlternateIngredients("shaftWood", PrimalItemRegistry.WOODEN_SHAFT);
        if (PrimalConfig.BRANCHES_AND_SHAFTS.sticksCountAsShafts) {
            PrimalUtilRecipe.addAlternateIngredients("shaftWood", Items.field_151055_y);
        }
        if (Loader.isModLoaded((String)"biomesoplenty") && PrimalConfig.BASICS.biomesOPlentyIntegration) {
            IForgeRegistry blockRegistry = GameRegistry.findRegistry(Block.class);
            if (PrimalConfig.CORDAGE.allowVinesAsCordage) {
                Block blockWillowVine;
                Block blockIvy = (Block)blockRegistry.getValue(new ResourceLocation("biomesoplenty:ivy"));
                if (blockIvy != null) {
                    PrimalUtilRecipe.addAlternateIngredients("cordage", blockIvy);
                    PrimalUtilRecipe.addAlternateIngredients("cordageStrong", blockIvy);
                    PrimalUtilRecipe.addAlternateIngredients("vine", blockIvy);
                }
                if ((blockWillowVine = (Block)blockRegistry.getValue(new ResourceLocation("biomesoplenty:willow_vine"))) != null) {
                    PrimalUtilRecipe.addAlternateIngredients("cordage", blockWillowVine);
                    PrimalUtilRecipe.addAlternateIngredients("cordageStrong", blockWillowVine);
                    PrimalUtilRecipe.addAlternateIngredients("vine", blockWillowVine);
                }
            }
            if (PrimalConfig.CORDAGE.allowSugarCaneAsCordage) {
                Block doublePlant;
                Block plant1 = (Block)blockRegistry.getValue(new ResourceLocation("biomesoplenty:plant_1"));
                if (plant1 != null) {
                    PrimalUtilRecipe.addAlternateIngredients("plantFiber", new ItemStack(plant1, 1, 4));
                    PrimalUtilRecipe.addAlternateIngredients("plantFiber", new ItemStack(plant1, 1, 5));
                    PrimalUtilRecipe.addAlternateIngredients("plantFiber", new ItemStack(plant1, 1, 8));
                    PrimalUtilRecipe.addAlternateIngredients("plantFiber", new ItemStack(plant1, 1, 9));
                }
                if ((doublePlant = (Block)blockRegistry.getValue(new ResourceLocation("biomesoplenty:double_plant"))) != null) {
                    PrimalUtilRecipe.addAlternateIngredients("plantFiber", new ItemStack(doublePlant, 1, 0));
                    PrimalUtilRecipe.addAlternateIngredients("plantFiber", new ItemStack(doublePlant, 1, 1));
                }
            }
        }
    }
}

