/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.primallib.recipes;

import com.daeruin.primallib.config.PrimalConfig;
import com.daeruin.primallib.recipes.ParsedPrimalRecipe;
import com.daeruin.primallib.util.PrimalUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PrimalRecipe
extends ShapelessOreRecipe
implements IRecipe {
    private final String primalRecipeGroup;

    PrimalRecipe(ParsedPrimalRecipe parsedPrimalRecipe) {
        super(parsedPrimalRecipe.getResourceLocation(), parsedPrimalRecipe.getIngredientList(), parsedPrimalRecipe.getCraftingResult());
        this.primalRecipeGroup = parsedPrimalRecipe.getRecipeType();
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting craftingInventory) {
        if (this.primalRecipeGroup.equals("bark_from_log")) {
            NonNullList remainingItems = NonNullList.func_191197_a((int)craftingInventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack stack = craftingInventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                Item item = stack.func_77973_b();
                if (PrimalUtil.isAxe(item)) {
                    remainingItems.set(i, (Object)stack.func_77946_l());
                    continue;
                }
                if (Block.func_149634_a((Item)item) instanceof BlockLog) {
                    Block block = Block.func_149634_a((Item)item);
                    int meta = stack.func_77960_j();
                    IBlockState state = block.func_176203_a(meta);
                    Block remainingBlock = PrimalUtil.getStrippedLog(state);
                    remainingItems.set(i, (Object)new ItemStack(remainingBlock));
                    continue;
                }
                remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
            }
            return remainingItems;
        }
        return super.func_179532_b(craftingInventory);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting craftingInventory) {
        if (this.primalRecipeGroup.equals("bark_from_log")) {
            this.output.func_190920_e(PrimalConfig.BARK_AND_STRIPPED_LOGS.barkAmount);
            return this.output;
        }
        if (this.primalRecipeGroup.equals("planks_from_stripped_logs")) {
            this.output.func_190920_e(PrimalConfig.BARK_AND_STRIPPED_LOGS.plankAmount);
            return this.output;
        }
        return super.func_77572_b(craftingInventory);
    }
}

