/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.primallib.util;

import com.daeruin.primallib.blocks.PrimalBlockLog;
import com.daeruin.primallib.blocks.PrimalBlockRegistry;
import com.daeruin.primallib.config.PrimalConfig;
import com.daeruin.primallib.items.PrimalItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.ArrayUtils;

public class PrimalUtil {
    public static Item getItem(Block block) {
        return Item.func_150898_a((Block)block);
    }

    public static BlockPlanks.EnumType getLogEnumType(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        BlockPlanks.EnumType type = BlockPlanks.EnumType.OAK;
        if (block instanceof BlockLog) {
            if (block == Blocks.field_150364_r) {
                type = (BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockOldLog.field_176301_b);
            } else if (block == Blocks.field_150363_s) {
                type = (BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockNewLog.field_176300_b);
            }
        }
        return type;
    }

    public static Block getStrippedLog(IBlockState blockState) {
        BlockPlanks.EnumType type = PrimalUtil.getLogEnumType(blockState);
        switch (type) {
            case ACACIA: {
                return PrimalBlockRegistry.STRIPPED_ACACIA_LOG;
            }
            case BIRCH: {
                return PrimalBlockRegistry.STRIPPED_BIRCH_LOG;
            }
            case DARK_OAK: {
                return PrimalBlockRegistry.STRIPPED_DARK_OAK_LOG;
            }
            case JUNGLE: {
                return PrimalBlockRegistry.STRIPPED_JUNGLE_LOG;
            }
            case OAK: {
                return PrimalBlockRegistry.STRIPPED_OAK_LOG;
            }
            case SPRUCE: {
                return PrimalBlockRegistry.STRIPPED_SPRUCE_LOG;
            }
        }
        return PrimalBlockRegistry.STRIPPED_OAK_LOG;
    }

    public static Item getBark(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block instanceof BlockLog) {
            BlockPlanks.EnumType type = PrimalUtil.getLogEnumType(blockState);
            switch (type) {
                case ACACIA: {
                    return PrimalItemRegistry.ACACIA_BARK;
                }
                case BIRCH: {
                    return PrimalItemRegistry.BIRCH_BARK;
                }
                case DARK_OAK: {
                    return PrimalItemRegistry.DARK_OAK_BARK;
                }
                case JUNGLE: {
                    return PrimalItemRegistry.JUNGLE_BARK;
                }
                case OAK: {
                    return PrimalItemRegistry.OAK_BARK;
                }
                case SPRUCE: {
                    return PrimalItemRegistry.SPRUCE_BARK;
                }
            }
        }
        return PrimalItemRegistry.OAK_BARK;
    }

    public static void addDropWithChance(BlockEvent.HarvestDropsEvent event, Item dropItem, double chance, int amount) {
        double dieRoll = event.getWorld().field_73012_v.nextDouble();
        if (dieRoll <= chance) {
            event.getDrops().add(new ItemStack(dropItem, amount));
        }
    }

    public static boolean isLog(Block block) {
        return block instanceof BlockLog || block instanceof PrimalBlockLog;
    }

    public static boolean isLog(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof BlockLog || block instanceof PrimalBlockLog;
    }

    public static boolean isAxe(Item item) {
        return item instanceof ItemAxe || PrimalConfig.BASICS.noTreePunchingIntegration && PrimalUtil.isNoTreePunchingAxe(item);
    }

    private static boolean isNoTreePunchingAxe(Item item) {
        String modName;
        ResourceLocation resLoc = item.getRegistryName();
        if (resLoc != null && (modName = resLoc.func_110624_b()).equals("notreepunching")) {
            String itemName = resLoc.func_110623_a();
            int indexOfSlashChar = itemName.indexOf(47);
            return (itemName = itemName.substring(0, indexOfSlashChar)).equals("axe") || itemName.equals("mattock");
        }
        return false;
    }

    public static boolean dropsPlantFiber(IBlockState blockState) {
        if (Loader.isModLoaded((String)"biomesoplenty")) {
            Block block = blockState.func_177230_c();
            ResourceLocation resourceLocation = block.getRegistryName();
            int blockMeta = block.func_176201_c(blockState);
            if (resourceLocation != null) {
                switch (resourceLocation.toString()) {
                    case "biomesoplenty:plant_0": {
                        int[] biomesOPlentyPlant0Metas = new int[]{1, 7, 13, 14};
                        return ArrayUtils.contains((int[])biomesOPlentyPlant0Metas, (int)blockMeta);
                    }
                    case "biomesoplenty:plant_1": {
                        int[] biomesOPlentyPlant1Metas = new int[]{0, 1, 3, 7, 11};
                        return ArrayUtils.contains((int[])biomesOPlentyPlant1Metas, (int)blockMeta);
                    }
                    case "biomesoplenty:double_plant": {
                        int[] biomesOPlentyDoublePlantMetas = new int[]{3};
                        return ArrayUtils.contains((int[])biomesOPlentyDoublePlantMetas, (int)blockMeta);
                    }
                }
            }
        }
        return false;
    }

    public static boolean dropsTwigs(IBlockState blockState) {
        Block block;
        ResourceLocation resourceLocation;
        if (Loader.isModLoaded((String)"biomesoplenty") && (resourceLocation = (block = blockState.func_177230_c()).getRegistryName()) != null && resourceLocation.toString().equals("biomesoplenty:plant_0")) {
            int[] biomesOPlentyPlant0Metas = new int[]{2, 6};
            int blockMeta = block.func_176201_c(blockState);
            return ArrayUtils.contains((int[])biomesOPlentyPlant0Metas, (int)blockMeta);
        }
        return false;
    }

    public static RayTraceResult getRayTraceResultFromPlayer(World world, EntityLivingBase entity) {
        int reach = 4;
        float var4 = 1.0f;
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * var4;
        float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * var4;
        double posX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)var4;
        double posY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)var4 + 1.62 - entity.func_70033_W();
        double posZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)var4;
        Vec3d vecOne = new Vec3d(posX, posY, posZ);
        float var14 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        Vec3d vecTwo = vecOne.func_72441_c((double)(var18 * (float)reach), (double)(var17 * (float)reach), (double)(var20 * (float)reach));
        boolean stopOnLiquid = true;
        boolean ignoreBlockWithoutBoundingBox = false;
        boolean returnLastUncollidableBlock = true;
        if (!(Double.isNaN(vecOne.field_72450_a) || Double.isNaN(vecOne.field_72448_b) || Double.isNaN(vecOne.field_72449_c))) {
            if (!(Double.isNaN(vecTwo.field_72450_a) || Double.isNaN(vecTwo.field_72448_b) || Double.isNaN(vecTwo.field_72449_c))) {
                RayTraceResult raytraceresult;
                int vecTwoX = MathHelper.func_76128_c((double)vecTwo.field_72450_a);
                int vecTwoY = MathHelper.func_76128_c((double)vecTwo.field_72448_b);
                int vecTwoZ = MathHelper.func_76128_c((double)vecTwo.field_72449_c);
                int vecOneX = MathHelper.func_76128_c((double)vecOne.field_72450_a);
                int vecOneY = MathHelper.func_76128_c((double)vecOne.field_72448_b);
                int vecOneZ = MathHelper.func_76128_c((double)vecOne.field_72449_c);
                BlockPos vecOnePos = new BlockPos(vecOneX, vecOneY, vecOneZ);
                IBlockState vecOneBlockState = world.func_180495_p(vecOnePos);
                Block block = vecOneBlockState.func_177230_c();
                if ((!ignoreBlockWithoutBoundingBox || vecOneBlockState.func_185890_d((IBlockAccess)world, vecOnePos) != Block.field_185506_k) && block.func_176209_a(vecOneBlockState, stopOnLiquid) && (raytraceresult = vecOneBlockState.func_185910_a(world, vecOnePos, vecOne, vecTwo)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vecOne.field_72450_a) || Double.isNaN(vecOne.field_72448_b) || Double.isNaN(vecOne.field_72449_c)) {
                        return null;
                    }
                    if (vecOneX == vecTwoX && vecOneY == vecTwoY && vecOneZ == vecTwoZ) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (vecTwoX > vecOneX) {
                        d0 = (double)vecOneX + 1.0;
                    } else if (vecTwoX < vecOneX) {
                        d0 = (double)vecOneX + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (vecTwoY > vecOneY) {
                        d1 = (double)vecOneY + 1.0;
                    } else if (vecTwoY < vecOneY) {
                        d1 = (double)vecOneY + 0.0;
                    } else {
                        flag = false;
                    }
                    if (vecTwoZ > vecOneZ) {
                        d2 = (double)vecOneZ + 1.0;
                    } else if (vecTwoZ < vecOneZ) {
                        d2 = (double)vecOneZ + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vecTwo.field_72450_a - vecOne.field_72450_a;
                    double d7 = vecTwo.field_72448_b - vecOne.field_72448_b;
                    double d8 = vecTwo.field_72449_c - vecOne.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vecOne.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vecOne.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vecOne.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = vecTwoX > vecOneX ? EnumFacing.WEST : EnumFacing.EAST;
                        vecOne = new Vec3d(d0, vecOne.field_72448_b + d7 * d3, vecOne.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = vecTwoY > vecOneY ? EnumFacing.DOWN : EnumFacing.UP;
                        vecOne = new Vec3d(vecOne.field_72450_a + d6 * d4, d1, vecOne.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = vecTwoZ > vecOneZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vecOne = new Vec3d(vecOne.field_72450_a + d6 * d5, vecOne.field_72448_b + d7 * d5, d2);
                    }
                    vecOneX = MathHelper.func_76128_c((double)vecOne.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    vecOneY = MathHelper.func_76128_c((double)vecOne.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    vecOneZ = MathHelper.func_76128_c((double)vecOne.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    vecOnePos = new BlockPos(vecOneX, vecOneY, vecOneZ);
                    IBlockState iblockstate1 = world.func_180495_p(vecOnePos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)world, vecOnePos) == Block.field_185506_k) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid) || block1 instanceof BlockLiquid && (Integer)iblockstate1.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(world, vecOnePos, vecOne, vecTwo);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vecOne, enumfacing, vecOnePos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }
}

