/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.primallib.util;

import com.daeruin.primallib.recipes.DummyRecipe;
import com.daeruin.primallib.recipes.ParsedPrimalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PrimalUtilRecipe {
    public static void addAlternateIngredients(String name, Object ... objects) {
        for (Object object : objects) {
            if (object instanceof Block) {
                OreDictionary.registerOre((String)name, (Block)((Block)object));
                continue;
            }
            if (object instanceof Item) {
                OreDictionary.registerOre((String)name, (Item)((Item)object));
                continue;
            }
            if (object instanceof ItemStack) {
                OreDictionary.registerOre((String)name, (ItemStack)((ItemStack)object));
                continue;
            }
            FMLLog.bigWarning((String)"Invalid registration attempt for an Ore Dictionary item with name {} has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", (Object[])new Object[]{name});
        }
    }

    public static void removeCraftingRecipe(Item itemToMatch) {
        IForgeRegistry recipeRegistry = ForgeRegistries.RECIPES;
        for (IRecipe recipe : recipeRegistry) {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput.func_190926_b() || recipeOutput.func_77973_b() != itemToMatch || recipe.getRegistryName() == null) continue;
            System.out.println("\u001b[0;33mPlease ignore 'Potentially Dangerous alternative prefix' warning for recipe `" + itemToMatch.getRegistryName() + "`. It's being removed intentionally due to a config setting.");
            IRecipe replacement = (IRecipe)new DummyRecipe().setRegistryName(recipe.getRegistryName());
            recipeRegistry.register((IForgeRegistryEntry)replacement);
        }
    }

    public static void removeCraftingRecipe(Block block) {
        PrimalUtilRecipe.removeCraftingRecipe(Item.func_150898_a((Block)block));
    }

    public static void removeSmeltingRecipe(Item itemToMatch) {
        Map recipeList = FurnaceRecipes.func_77602_a().func_77599_b();
        Iterator recipeIterator = recipeList.entrySet().iterator();
        while (recipeIterator.hasNext()) {
            Map.Entry entry = recipeIterator.next();
            ItemStack recipeOutput = (ItemStack)entry.getValue();
            if (recipeOutput.func_190926_b() || recipeOutput.func_77973_b() != itemToMatch) continue;
            recipeIterator.remove();
        }
    }

    public static ParsedPrimalRecipe parsePrimalRecipe(JsonContext context, JsonObject json) {
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList ingredients = NonNullList.func_191196_a();
        for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        String primalRecipeGroup = json.getAsJsonArray("conditions").get(0).getAsJsonObject().get("primal_recipe_group").getAsString();
        return new ParsedPrimalRecipe(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ingredients, result, primalRecipeGroup);
    }

    public static void generateNoTreePunchingRecipes() {
        String[] NTP_SAWS;
        String[] NTP_AXES;
        String NTP_MOD_ID = "notreepunching";
        String ASSETS_DIR = "/Users/" + System.getProperty("user.name") + "/Developer/mc112/primallib112/src/main/resources/assets/primallib/recipes/";
        for (String axe : NTP_AXES = new String[]{"axe/flint", "mattock/iron", "mattock/gold", "mattock/diamond", "mattock/copper", "mattock/tin", "mattock/bronze", "mattock/steel"}) {
            for (BlockPlanks.EnumType woodType : BlockPlanks.EnumType.values()) {
                String woodName = woodType.func_176610_l();
                String recipeFileName = "NTP_bark_" + woodName + "_from_log_with_" + axe.replace('/', '_') + ".json";
                String recipeText = PrimalUtilRecipe.constructBarkRecipeText(NTP_MOD_ID, axe, woodType);
                PrimalUtilRecipe.writeRecipe(recipeFileName, recipeText, ASSETS_DIR);
            }
        }
        for (String saw : NTP_SAWS = new String[]{"saw/iron", "saw/gold", "saw/diamond", "saw/copper", "saw/tin", "saw/bronze", "saw/steel"}) {
            for (BlockPlanks.EnumType woodType : BlockPlanks.EnumType.values()) {
                String woodName = woodType.func_176610_l();
                String recipeFileName = "NTP_planks_" + woodName + "_with_" + saw.replace('/', '_') + ".json";
                String recipeText = PrimalUtilRecipe.constructSawRecipeText(NTP_MOD_ID, saw, woodType);
                PrimalUtilRecipe.writeRecipe(recipeFileName, recipeText, ASSETS_DIR);
            }
        }
    }

    private static String constructBarkRecipeText(String modid, String tool, BlockPlanks.EnumType woodType) {
        int logMeta = woodType.func_176839_a();
        String woodName = woodType.func_176610_l();
        String logType = "log";
        if (woodName.equals("acacia") || woodName.equals("dark_oak")) {
            logType = "log2";
            logMeta -= 4;
        }
        return "{\n  \"conditions\": [\n    {\n      \"type\": \"primallib:is_recipe_allowed\",\n      \"recipe_name\": \"bark_from_log_NTP\"\n    }\n  ],\n  \"type\": \"primallib:primallib_recipe\",\n  \"ingredients\": [\n    {\n      \"item\": \"" + modid + ":" + tool + "\"\n    },\n    {\n      \"item\": \"minecraft:" + logType + "\",\n      \"data\": " + logMeta + "\n    }\n  ],\n  \"result\": {\n    \"item\": \"primallib:bark_" + woodName + "\",\n    \"count\": 4\n  }\n}";
    }

    private static String constructSawRecipeText(String modid, String tool, BlockPlanks.EnumType woodType) {
        int logMeta = woodType.func_176839_a();
        String woodName = woodType.func_176610_l();
        return "{\n  \"conditions\":\n  [\n    {\n      \"type\": \"primallib:is_recipe_allowed\",\n      \"recipe_name\": \"planks_NTP\"\n    }\n  ],\n  \"type\": \"forge:ore_shaped\",\n  \"pattern\":\n  [\n    \"S\",\n    \"L\"\n  ],\n  \"key\":\n  {\n    \"S\":\n    {\n      \"item\": \"" + modid + ":" + tool + "\",\n       \"data\": 32767\n    },\n    \"L\":\n    {\n      \"item\": \"primallib:log_stripped_" + woodName + "\"\n    }\n  },\n  \"result\": {\n    \"item\": \"minecraft:planks\",\n    \"data\": " + logMeta + ",\n    \"count\": 4\n  }\n}";
    }

    private static void writeRecipe(String recipeFileName, String recipeText, String recipeDestination) {
        Path path = Paths.get(recipeDestination + recipeFileName, new String[0]);
        ArrayList<String> recipeIterable = new ArrayList<String>(Arrays.asList(recipeText.split("/n")));
        try {
            Files.write(path, recipeIterable, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

