/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.primallib.util;

import com.daeruin.primallib.IHasCustomItemBlock;
import com.daeruin.primallib.INeedsCustomModelReg;
import com.daeruin.primallib.util.PrimalCreativeTab;
import com.daeruin.primallib.util.PrimalUtil;
import java.util.HashSet;
import java.util.LinkedHashSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PrimalUtilReg {
    public static void initializeBlock(Block block, String name) {
        block.func_149647_a(PrimalCreativeTab.PRIMAL_TAB);
        block.setRegistryName(name);
        if (block.getRegistryName() != null) {
            block.func_149663_c(block.getRegistryName().toString());
        }
    }

    public static void initializeItem(Item item, String name) {
        item.func_77637_a(PrimalCreativeTab.PRIMAL_TAB);
        item.setRegistryName(name);
        if (item.getRegistryName() != null) {
            item.func_77655_b(item.getRegistryName().toString());
        }
    }

    public static void registerItems(RegistryEvent.Register<Item> event, LinkedHashSet<Item> items) {
        IForgeRegistry itemRegistry = event.getRegistry();
        for (Item item : items) {
            itemRegistry.register((IForgeRegistryEntry)item);
        }
    }

    public static void registerBlocks(RegistryEvent.Register<Block> event, LinkedHashSet<Block> blocks) {
        IForgeRegistry blockRegistry = event.getRegistry();
        for (Block block : blocks) {
            blockRegistry.register((IForgeRegistryEntry)block);
        }
    }

    public static void registerItemBlocks(RegistryEvent.Register<Item> event, HashSet<Block> blocks) {
        IForgeRegistry itemBlockRegistry = event.getRegistry();
        for (Block block : blocks) {
            ItemBlock itemBlock = block instanceof IHasCustomItemBlock ? ((IHasCustomItemBlock)block).getItemBlock() : new ItemBlock(block);
            if (block.getRegistryName() == null) continue;
            itemBlock.setRegistryName(block.getRegistryName());
            itemBlockRegistry.register((IForgeRegistryEntry)itemBlock);
        }
    }

    public static void registerItemModels(HashSet<Item> items) {
        for (Item item : items) {
            if (item instanceof INeedsCustomModelReg) {
                ((INeedsCustomModelReg)item).registerCustomModel();
                continue;
            }
            PrimalUtilReg.registerModel(item, 0, PrimalUtilReg.getResourceLocation(item));
        }
    }

    public static void registerBlockModels(HashSet<Block> blocks) {
        for (Block block : blocks) {
            if (block instanceof INeedsCustomModelReg) {
                ((INeedsCustomModelReg)block).registerCustomModel();
                continue;
            }
            Item item = PrimalUtil.getItem(block);
            PrimalUtilReg.registerModel(item, 0, PrimalUtilReg.getResourceLocation(item));
        }
    }

    public static ModelResourceLocation getResourceLocation(Item item) {
        return new ModelResourceLocation(item.getRegistryName().toString(), "inventory");
    }

    public static void registerModel(Item item, int meta, ModelResourceLocation resourceLocation) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)resourceLocation);
    }

    public static void remapBlockTo(RegistryEvent.MissingMappings.Mapping<Block> mapping, String newName, LinkedHashSet<Block> blockList) {
        ResourceLocation newRegistryName = new ResourceLocation(newName);
        Block newBlock = PrimalUtilReg.getRegisteredBlock(newRegistryName, blockList);
        if (newBlock != null) {
            mapping.remap((IForgeRegistryEntry)newBlock);
        } else {
            mapping.fail();
        }
    }

    private static Block getRegisteredBlock(ResourceLocation blockName, LinkedHashSet<Block> blockList) {
        for (Block block : blockList) {
            if (block.getRegistryName().compareTo(blockName) != 0) continue;
            return block;
        }
        return null;
    }

    public static void remapItemTo(RegistryEvent.MissingMappings.Mapping<Item> mapping, String newName, LinkedHashSet<Item> itemList) {
        ResourceLocation newRegistryName = new ResourceLocation(newName);
        Item newItem = PrimalUtilReg.getRegisteredItem(newRegistryName, itemList);
        if (newItem != null) {
            mapping.remap((IForgeRegistryEntry)newItem);
        } else {
            mapping.fail();
        }
    }

    private static Item getRegisteredItem(ResourceLocation itemName, LinkedHashSet<Item> itemList) {
        for (Item item : itemList) {
            if (item.getRegistryName().compareTo(itemName) != 0) continue;
            return item;
        }
        return null;
    }

    public static void remapItemBlockTo(RegistryEvent.MissingMappings.Mapping<Item> mapping, String newName, LinkedHashSet<Block> blockList) {
        ResourceLocation newRegistryName = new ResourceLocation(newName);
        Block newBlock = PrimalUtilReg.getRegisteredBlock(newRegistryName, blockList);
        if (newBlock != null) {
            Item itemBlock = Item.func_150898_a((Block)newBlock);
            mapping.remap((IForgeRegistryEntry)itemBlock);
        } else {
            mapping.fail();
        }
    }
}

