/*
 * Decompiled with CFR 0.152.
 */
package net.click.projecttacznpcs.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ProjectTaczNpcsConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> HAZMAT_TARGETS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DARK_TARGETS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> FOREST_TARGETS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> JUGGERNAUT_TARGETS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SHADOW_TARGETS;
    public static final ForgeConfigSpec.IntValue HAZMAT_ENGAGE_DELAY_TICKS;
    public static final ForgeConfigSpec.IntValue HAZMAT_RETARGET_INTERVAL_TICKS;
    public static final ForgeConfigSpec.DoubleValue HAZMAT_INACCURACY_DEG;
    public static final ForgeConfigSpec.BooleanValue HAZMAT_ANTI_FRIENDLY_FIRE;
    public static final ForgeConfigSpec.IntValue DARK_ENGAGE_DELAY_TICKS;
    public static final ForgeConfigSpec.IntValue DARK_RETARGET_INTERVAL_TICKS;
    public static final ForgeConfigSpec.DoubleValue DARK_INACCURACY_DEG;
    public static final ForgeConfigSpec.BooleanValue DARK_ANTI_FRIENDLY_FIRE;
    public static final ForgeConfigSpec.IntValue FOREST_ENGAGE_DELAY_TICKS;
    public static final ForgeConfigSpec.IntValue FOREST_RETARGET_INTERVAL_TICKS;
    public static final ForgeConfigSpec.DoubleValue FOREST_INACCURACY_DEG;
    public static final ForgeConfigSpec.BooleanValue FOREST_ANTI_FRIENDLY_FIRE;
    public static final ForgeConfigSpec.IntValue JUGGERNAUT_ENGAGE_DELAY_TICKS;
    public static final ForgeConfigSpec.IntValue JUGGERNAUT_RETARGET_INTERVAL_TICKS;
    public static final ForgeConfigSpec.DoubleValue JUGGERNAUT_INACCURACY_DEG;
    public static final ForgeConfigSpec.BooleanValue JUGGERNAUT_ANTI_FRIENDLY_FIRE;
    public static final ForgeConfigSpec.IntValue SHADOW_ENGAGE_DELAY_TICKS;
    public static final ForgeConfigSpec.IntValue SHADOW_RETARGET_INTERVAL_TICKS;
    public static final ForgeConfigSpec.DoubleValue SHADOW_INACCURACY_DEG;
    public static final ForgeConfigSpec.BooleanValue SHADOW_ANTI_FRIENDLY_FIRE;
    public static final ForgeConfigSpec.DoubleValue HAZMAT_MAX_HEALTH;
    public static final ForgeConfigSpec.DoubleValue HAZMAT_ARMOR;
    public static final ForgeConfigSpec.DoubleValue HAZMAT_FOLLOW_RANGE;
    public static final ForgeConfigSpec.DoubleValue HAZMAT_KNOCKBACK_RESISTANCE;
    public static final ForgeConfigSpec.DoubleValue DARK_MAX_HEALTH;
    public static final ForgeConfigSpec.DoubleValue DARK_ARMOR;
    public static final ForgeConfigSpec.DoubleValue DARK_FOLLOW_RANGE;
    public static final ForgeConfigSpec.DoubleValue DARK_KNOCKBACK_RESISTANCE;
    public static final ForgeConfigSpec.DoubleValue FOREST_MAX_HEALTH;
    public static final ForgeConfigSpec.DoubleValue FOREST_ARMOR;
    public static final ForgeConfigSpec.DoubleValue FOREST_FOLLOW_RANGE;
    public static final ForgeConfigSpec.DoubleValue FOREST_KNOCKBACK_RESISTANCE;
    public static final ForgeConfigSpec.DoubleValue JUGGERNAUT_MAX_HEALTH;
    public static final ForgeConfigSpec.DoubleValue JUGGERNAUT_ARMOR;
    public static final ForgeConfigSpec.DoubleValue JUGGERNAUT_FOLLOW_RANGE;
    public static final ForgeConfigSpec.DoubleValue JUGGERNAUT_KNOCKBACK_RESISTANCE;
    public static final ForgeConfigSpec.DoubleValue SHADOW_MAX_HEALTH;
    public static final ForgeConfigSpec.DoubleValue SHADOW_ARMOR;
    public static final ForgeConfigSpec.DoubleValue SHADOW_FOLLOW_RANGE;
    public static final ForgeConfigSpec.DoubleValue SHADOW_KNOCKBACK_RESISTANCE;
    public static final ForgeConfigSpec.BooleanValue HAZMAT_SPAWN_ENABLED;
    public static final ForgeConfigSpec.BooleanValue HAZMAT_SPAWN_OVERWORLD;
    public static final ForgeConfigSpec.BooleanValue HAZMAT_SPAWN_NETHER;
    public static final ForgeConfigSpec.BooleanValue HAZMAT_SPAWN_END;
    public static final ForgeConfigSpec.BooleanValue HAZMAT_EXCLUDE_DEEP_DARK;
    public static final ForgeConfigSpec.BooleanValue DARK_SPAWN_ENABLED;
    public static final ForgeConfigSpec.BooleanValue DARK_SPAWN_OVERWORLD;
    public static final ForgeConfigSpec.BooleanValue DARK_SPAWN_NETHER;
    public static final ForgeConfigSpec.BooleanValue DARK_SPAWN_END;
    public static final ForgeConfigSpec.BooleanValue DARK_EXCLUDE_DEEP_DARK;
    public static final ForgeConfigSpec.BooleanValue FOREST_SPAWN_ENABLED;
    public static final ForgeConfigSpec.BooleanValue FOREST_SPAWN_OVERWORLD;
    public static final ForgeConfigSpec.BooleanValue FOREST_SPAWN_NETHER;
    public static final ForgeConfigSpec.BooleanValue FOREST_SPAWN_END;
    public static final ForgeConfigSpec.BooleanValue FOREST_EXCLUDE_DEEP_DARK;
    public static final ForgeConfigSpec.BooleanValue JUGGERNAUT_SPAWN_ENABLED;
    public static final ForgeConfigSpec.BooleanValue JUGGERNAUT_SPAWN_OVERWORLD;
    public static final ForgeConfigSpec.BooleanValue JUGGERNAUT_SPAWN_NETHER;
    public static final ForgeConfigSpec.BooleanValue JUGGERNAUT_SPAWN_END;
    public static final ForgeConfigSpec.BooleanValue JUGGERNAUT_EXCLUDE_DEEP_DARK;
    public static final ForgeConfigSpec.BooleanValue SHADOW_SPAWN_ENABLED;
    public static final ForgeConfigSpec.BooleanValue SHADOW_SPAWN_OVERWORLD;
    public static final ForgeConfigSpec.BooleanValue SHADOW_SPAWN_NETHER;
    public static final ForgeConfigSpec.BooleanValue SHADOW_SPAWN_END;
    public static final ForgeConfigSpec.BooleanValue SHADOW_EXCLUDE_DEEP_DARK;

    static {
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        b.push("targets");
        HAZMAT_TARGETS = b.comment("Entity IDs Hazmat targets by default").defineList("hazmat", Arrays.asList("minecraft:player", "minecraft:villager", "minecraft:iron_golem", "project_tacz_npcs:dark_wanderer", "project_tacz_npcs:forest_soilder", "project_tacz_npcs:juggernaut", "project_tacz_npcs:shadow_soilder"), o -> o instanceof String);
        DARK_TARGETS = b.comment("Entity IDs Dark Wanderer targets by default").defineList("dark_wanderer", Arrays.asList("minecraft:player", "minecraft:villager", "minecraft:iron_golem", "project_tacz_npcs:hazmat_soilder", "project_tacz_npcs:forest_soilder", "project_tacz_npcs:juggernaut", "project_tacz_npcs:shadow_soilder"), o -> o instanceof String);
        FOREST_TARGETS = b.comment("Entity IDs Forest Soldier targets by default").defineList("forest_soilder", Arrays.asList("minecraft:player", "minecraft:villager", "minecraft:iron_golem", "project_tacz_npcs:hazmat_soilder", "project_tacz_npcs:dark_wanderer", "project_tacz_npcs:juggernaut", "project_tacz_npcs:shadow_soilder"), o -> o instanceof String);
        JUGGERNAUT_TARGETS = b.comment("Entity IDs Juggernaut targets by default").defineList("juggernaut", Arrays.asList("minecraft:player", "minecraft:villager", "minecraft:iron_golem", "project_tacz_npcs:hazmat_soilder", "project_tacz_npcs:dark_wanderer", "project_tacz_npcs:forest_soilder", "project_tacz_npcs:shadow_soilder"), o -> o instanceof String);
        SHADOW_TARGETS = b.comment("Entity IDs Shadow Soldier targets by default").defineList("shadow_soilder", Arrays.asList("minecraft:player", "minecraft:villager", "minecraft:iron_golem", "project_tacz_npcs:hazmat_soilder", "project_tacz_npcs:dark_wanderer", "project_tacz_npcs:forest_soilder", "project_tacz_npcs:juggernaut"), o -> o instanceof String);
        b.pop();
        b.push("combat");
        b.push("hazmat");
        HAZMAT_ENGAGE_DELAY_TICKS = b.comment("Ticks to wait after acquiring a target before engaging (still tracks/aims during delay)").defineInRange("engage_delay_ticks", 50, 0, 400);
        HAZMAT_RETARGET_INTERVAL_TICKS = b.comment("Ticks between reassessing nearest valid target (lower = more responsive)").defineInRange("retarget_interval_ticks", 3, 1, 40);
        HAZMAT_INACCURACY_DEG = b.defineInRange("inaccuracy_deg", 4.0, 0.0, 15.0);
        HAZMAT_ANTI_FRIENDLY_FIRE = b.comment("If true, Hazmat will not retaliate against another Hazmat when damaged by one").define("anti_friendly_fire", true);
        b.pop();
        b.push("dark_wanderer");
        DARK_ENGAGE_DELAY_TICKS = b.defineInRange("engage_delay_ticks", 50, 0, 400);
        DARK_RETARGET_INTERVAL_TICKS = b.defineInRange("retarget_interval_ticks", 3, 1, 40);
        DARK_INACCURACY_DEG = b.defineInRange("inaccuracy_deg", 4.0, 0.0, 15.0);
        DARK_ANTI_FRIENDLY_FIRE = b.comment("If true, Dark Wanderer will not retaliate against another Dark Wanderer when damaged by one").define("anti_friendly_fire", true);
        b.pop();
        b.push("forest_soilder");
        FOREST_ENGAGE_DELAY_TICKS = b.defineInRange("engage_delay_ticks", 50, 0, 400);
        FOREST_RETARGET_INTERVAL_TICKS = b.defineInRange("retarget_interval_ticks", 3, 1, 40);
        FOREST_INACCURACY_DEG = b.defineInRange("inaccuracy_deg", 4.5, 0.0, 15.0);
        FOREST_ANTI_FRIENDLY_FIRE = b.comment("If true, Forest Soldier will not retaliate against another Forest Soldier when damaged by one").define("anti_friendly_fire", true);
        b.pop();
        b.push("juggernaut");
        JUGGERNAUT_ENGAGE_DELAY_TICKS = b.defineInRange("engage_delay_ticks", 50, 0, 400);
        JUGGERNAUT_RETARGET_INTERVAL_TICKS = b.defineInRange("retarget_interval_ticks", 3, 1, 40);
        JUGGERNAUT_INACCURACY_DEG = b.defineInRange("inaccuracy_deg", 5.0, 0.0, 15.0);
        JUGGERNAUT_ANTI_FRIENDLY_FIRE = b.comment("If true, Juggernaut will not retaliate against another Juggernaut when damaged by one").define("anti_friendly_fire", true);
        b.pop();
        b.push("shadow_soilder");
        SHADOW_ENGAGE_DELAY_TICKS = b.defineInRange("engage_delay_ticks", 50, 0, 400);
        SHADOW_RETARGET_INTERVAL_TICKS = b.defineInRange("retarget_interval_ticks", 3, 1, 40);
        SHADOW_INACCURACY_DEG = b.defineInRange("inaccuracy_deg", 4.0, 0.0, 15.0);
        SHADOW_ANTI_FRIENDLY_FIRE = b.comment("If true, Shadow Soldier will not retaliate against another Shadow Soldier when damaged by one").define("anti_friendly_fire", true);
        b.pop();
        b.pop();
        b.push("attributes");
        b.push("hazmat");
        HAZMAT_MAX_HEALTH = b.defineInRange("max_health", 20.0, 1.0, 2000.0);
        HAZMAT_ARMOR = b.defineInRange("armor", 2.0, 0.0, 100.0);
        HAZMAT_FOLLOW_RANGE = b.defineInRange("follow_range", 48.0, 8.0, 200.0);
        HAZMAT_KNOCKBACK_RESISTANCE = b.defineInRange("knockback_resistance", 0.1, 0.0, 1.0);
        b.pop();
        b.push("dark_wanderer");
        DARK_MAX_HEALTH = b.defineInRange("max_health", 20.0, 1.0, 2000.0);
        DARK_ARMOR = b.defineInRange("armor", 4.0, 0.0, 100.0);
        DARK_FOLLOW_RANGE = b.defineInRange("follow_range", 48.0, 8.0, 200.0);
        DARK_KNOCKBACK_RESISTANCE = b.defineInRange("knockback_resistance", 0.1, 0.0, 1.0);
        b.pop();
        b.push("forest_soilder");
        FOREST_MAX_HEALTH = b.defineInRange("max_health", 30.0, 1.0, 2000.0);
        FOREST_ARMOR = b.defineInRange("armor", 6.0, 0.0, 100.0);
        FOREST_FOLLOW_RANGE = b.defineInRange("follow_range", 48.0, 8.0, 200.0);
        FOREST_KNOCKBACK_RESISTANCE = b.defineInRange("knockback_resistance", 0.1, 0.0, 1.0);
        b.pop();
        b.push("juggernaut");
        JUGGERNAUT_MAX_HEALTH = b.defineInRange("max_health", 80.0, 1.0, 2000.0);
        JUGGERNAUT_ARMOR = b.defineInRange("armor", 12.0, 0.0, 100.0);
        JUGGERNAUT_FOLLOW_RANGE = b.defineInRange("follow_range", 48.0, 8.0, 200.0);
        JUGGERNAUT_KNOCKBACK_RESISTANCE = b.defineInRange("knockback_resistance", 0.6, 0.0, 1.0);
        b.pop();
        b.push("shadow_soilder");
        SHADOW_MAX_HEALTH = b.defineInRange("max_health", 30.0, 1.0, 2000.0);
        SHADOW_ARMOR = b.defineInRange("armor", 6.0, 0.0, 100.0);
        SHADOW_FOLLOW_RANGE = b.defineInRange("follow_range", 48.0, 8.0, 200.0);
        SHADOW_KNOCKBACK_RESISTANCE = b.defineInRange("knockback_resistance", 0.1, 0.0, 1.0);
        b.pop();
        b.pop();
        b.push("spawn");
        b.push("hazmat");
        HAZMAT_SPAWN_ENABLED = b.define("enabled", true);
        HAZMAT_SPAWN_OVERWORLD = b.define("overworld", true);
        HAZMAT_SPAWN_NETHER = b.define("nether", true);
        HAZMAT_SPAWN_END = b.define("end", false);
        HAZMAT_EXCLUDE_DEEP_DARK = b.define("exclude_deep_dark", true);
        b.pop();
        b.push("dark_wanderer");
        DARK_SPAWN_ENABLED = b.define("enabled", true);
        DARK_SPAWN_OVERWORLD = b.define("overworld", true);
        DARK_SPAWN_NETHER = b.define("nether", false);
        DARK_SPAWN_END = b.define("end", false);
        DARK_EXCLUDE_DEEP_DARK = b.define("exclude_deep_dark", true);
        b.pop();
        b.push("forest_soilder");
        FOREST_SPAWN_ENABLED = b.define("enabled", true);
        FOREST_SPAWN_OVERWORLD = b.define("overworld", true);
        FOREST_SPAWN_NETHER = b.define("nether", false);
        FOREST_SPAWN_END = b.define("end", false);
        FOREST_EXCLUDE_DEEP_DARK = b.define("exclude_deep_dark", true);
        b.pop();
        b.push("juggernaut");
        JUGGERNAUT_SPAWN_ENABLED = b.define("enabled", true);
        JUGGERNAUT_SPAWN_OVERWORLD = b.define("overworld", true);
        JUGGERNAUT_SPAWN_NETHER = b.define("nether", false);
        JUGGERNAUT_SPAWN_END = b.define("end", false);
        JUGGERNAUT_EXCLUDE_DEEP_DARK = b.define("exclude_deep_dark", true);
        b.pop();
        b.push("shadow_soilder");
        SHADOW_SPAWN_ENABLED = b.define("enabled", true);
        SHADOW_SPAWN_OVERWORLD = b.define("overworld", true);
        SHADOW_SPAWN_NETHER = b.define("nether", false);
        SHADOW_SPAWN_END = b.define("end", false);
        SHADOW_EXCLUDE_DEEP_DARK = b.define("exclude_deep_dark", true);
        b.pop();
        b.pop();
        COMMON_SPEC = b.build();
    }
}

