/*
 * Decompiled with CFR 0.152.
 */
package net.click.projecttacznpcs.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.click.projecttacznpcs.config.ProjectTaczNpcsConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public final class TargetingUtil {
    private TargetingUtil() {
    }

    private static Set<ResourceLocation> toIdSet(List<? extends String> list) {
        HashSet<ResourceLocation> s = new HashSet<ResourceLocation>();
        for (String string : list) {
            try {
                s.add(ResourceLocation.parse((String)string));
            }
            catch (Throwable throwable) {}
        }
        return s;
    }

    public static Predicate<LivingEntity> hazmatTargets() {
        return TargetingUtil.allowedPredicate((List)ProjectTaczNpcsConfig.HAZMAT_TARGETS.get());
    }

    public static Predicate<LivingEntity> darkTargets() {
        return TargetingUtil.allowedPredicate((List)ProjectTaczNpcsConfig.DARK_TARGETS.get());
    }

    public static Predicate<LivingEntity> forestTargets() {
        return TargetingUtil.allowedPredicate((List)ProjectTaczNpcsConfig.FOREST_TARGETS.get());
    }

    public static Predicate<LivingEntity> juggernautTargets() {
        return TargetingUtil.allowedPredicate((List)ProjectTaczNpcsConfig.JUGGERNAUT_TARGETS.get());
    }

    public static Predicate<LivingEntity> shadowTargets() {
        return TargetingUtil.allowedPredicate((List)ProjectTaczNpcsConfig.SHADOW_TARGETS.get());
    }

    private static Predicate<LivingEntity> allowedPredicate(List<? extends String> ids) {
        Set<ResourceLocation> allowed = TargetingUtil.toIdSet(ids);
        return living -> {
            ResourceLocation typeId = ForgeRegistries.ENTITY_TYPES.getKey((Object)living.m_6095_());
            return typeId != null && allowed.contains(typeId);
        };
    }
}

