/*
 * Decompiled with CFR 0.152.
 */
package net.click.projecttacznpcs.entity;

import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.click.projecttacznpcs.ProjectTaczNpcsMod;
import net.click.projecttacznpcs.config.ProjectTaczNpcsConfig;
import net.click.projecttacznpcs.config.TargetingUtil;
import net.click.projecttacznpcs.config.WeaponConfigUtil;
import net.click.projecttacznpcs.entity.ai.GunAttackGoal;
import net.click.projecttacznpcs.entity.base.AbstractGunNpcEntity;
import net.click.projecttacznpcs.init.ProjectTaczNpcsModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class HazmatSoilderEntity
extends AbstractGunNpcEntity
implements RangedAttackMob {
    public HazmatSoilderEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<HazmatSoilderEntity>)((EntityType)ProjectTaczNpcsModEntities.HAZMAT_SOILDER.get()), world);
    }

    public HazmatSoilderEntity(EntityType<HazmatSoilderEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 10;
        this.m_21557_(false);
        this.m_21553_(false);
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
        this.m_21409_(EquipmentSlot.HEAD, 0.0f);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        this.m_21409_(EquipmentSlot.LEGS, 0.0f);
        this.m_21409_(EquipmentSlot.FEET, 0.0f);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new GunAttackGoal((Mob)this, 1.1, 24.0f, (Integer)ProjectTaczNpcsConfig.HAZMAT_ENGAGE_DELAY_TICKS.get(), (Double)ProjectTaczNpcsConfig.HAZMAT_INACCURACY_DEG.get()));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(@Nonnull LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, ((Integer)ProjectTaczNpcsConfig.HAZMAT_RETARGET_INTERVAL_TICKS.get()).intValue(), false, false, TargetingUtil.hazmatTargets()));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(@Nonnull DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.player.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)"entity.player.death"));
    }

    public void m_6504_(@Nonnull LivingEntity target, float flval) {
        this.ensureEquippedGun();
        this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        IGunOperator.fromLivingEntity((LivingEntity)this).aim(true);
        IGunOperator.fromLivingEntity((LivingEntity)this).shoot(() -> ((HazmatSoilderEntity)this).m_146909_(), () -> ((HazmatSoilderEntity)this).m_146908_());
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ProjectTaczNpcsModEntities.HAZMAT_SOILDER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            boolean allowedDim;
            if (!((Boolean)ProjectTaczNpcsConfig.HAZMAT_SPAWN_ENABLED.get()).booleanValue()) {
                return false;
            }
            ResourceKey dim = world.m_6018_().m_46472_();
            boolean bl = allowedDim = (Boolean)ProjectTaczNpcsConfig.HAZMAT_SPAWN_OVERWORLD.get() != false && dim == Level.f_46428_ || (Boolean)ProjectTaczNpcsConfig.HAZMAT_SPAWN_NETHER.get() != false && dim == Level.f_46429_ || (Boolean)ProjectTaczNpcsConfig.HAZMAT_SPAWN_END.get() != false && dim == Level.f_46430_;
            if (!allowedDim) {
                return false;
            }
            if (((Boolean)ProjectTaczNpcsConfig.HAZMAT_EXCLUDE_DEEP_DARK.get()).booleanValue() && world.m_204166_(pos).m_203565_(Biomes.f_220594_)) {
                return false;
            }
            return world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
        });
    }

    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor world, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        try {
            AttributeInstance kb;
            AttributeInstance follow;
            AttributeInstance armor;
            AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
            if (maxHealth != null) {
                maxHealth.m_22100_(((Double)ProjectTaczNpcsConfig.HAZMAT_MAX_HEALTH.get()).doubleValue());
                this.m_21153_((float)maxHealth.m_22115_());
            }
            if ((armor = this.m_21051_(Attributes.f_22284_)) != null) {
                armor.m_22100_(((Double)ProjectTaczNpcsConfig.HAZMAT_ARMOR.get()).doubleValue());
            }
            if ((follow = this.m_21051_(Attributes.f_22277_)) != null) {
                follow.m_22100_(((Double)ProjectTaczNpcsConfig.HAZMAT_FOLLOW_RANGE.get()).doubleValue());
            }
            if ((kb = this.m_21051_(Attributes.f_22278_)) != null) {
                kb.m_22100_(((Double)ProjectTaczNpcsConfig.HAZMAT_KNOCKBACK_RESISTANCE.get()).doubleValue());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.m_9236_().f_46443_) {
            this.ensureEquippedGun();
            ProjectTaczNpcsMod.queueServerWork(1, this::ensureEquippedGun);
            ProjectTaczNpcsMod.queueServerWork(5, this::ensureEquippedGun);
            ProjectTaczNpcsMod.queueServerWork(20, this::ensureEquippedGun);
            ProjectTaczNpcsMod.queueServerWork(60, this::ensureEquippedGun);
        }
        return data;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.1);
        return builder;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.ensureEquippedGun();
        }
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        LivingEntity living;
        boolean anti;
        Entity attacker = source.m_7639_();
        boolean res = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && (anti = ((Boolean)ProjectTaczNpcsConfig.HAZMAT_ANTI_FRIENDLY_FIRE.get()).booleanValue()) && attacker instanceof LivingEntity && (living = (LivingEntity)attacker).m_6095_() == this.m_6095_()) {
            this.m_6703_(null);
        }
        return res;
    }

    private void ensureEquippedGun() {
        ItemStack stackNow;
        IGun gunNow;
        ItemStack main = this.m_21205_();
        if (!(main.m_41720_() instanceof IGun)) {
            Item taczGunItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)"tacz:modern_kinetic_gun"));
            if (taczGunItem == null) {
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)taczGunItem);
            ResourceLocation gunId = WeaponConfigUtil.pickRandomAvailable(this.m_217043_(), Collections.emptyList(), ResourceLocation.parse((String)"tacz:hk_mp5a5"), ResourceLocation.parse((String)"tacz:ump45"), ResourceLocation.parse((String)"tacz:b93r")).orElse(null);
            IGun iGun = IGun.getIGunOrNull((ItemStack)stack);
            if (iGun != null) {
                if (gunId != null) {
                    iGun.setGunId(stack, gunId);
                }
                try {
                    iGun.setMaxDummyAmmoAmount(stack, 999);
                    iGun.setDummyAmmoAmount(stack, 999);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                iGun.setCurrentAmmoCount(stack, 99);
                try {
                    iGun.setFireMode(stack, FireMode.AUTO);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.m_21008_(InteractionHand.MAIN_HAND, stack);
        }
        HazmatSoilderEntity operator = this;
        if (operator.getDataHolder().currentGunItem == null) {
            operator.draw(() -> ((HazmatSoilderEntity)this).m_21205_());
            try {
                operator.getDataHolder().drawTimestamp = System.currentTimeMillis() - 10000L;
            }
            catch (Throwable stack) {
                // empty catch block
            }
        }
        if ((gunNow = IGun.getIGunOrNull((ItemStack)(stackNow = this.m_21205_()))) != null) {
            try {
                if (gunNow.getCurrentAmmoCount(stackNow) < 5) {
                    gunNow.setCurrentAmmoCount(stackNow, 60);
                }
                gunNow.setBulletInBarrel(stackNow, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void m_6668_(@Nonnull DamageSource source) {
        try {
            this.m_21226_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void m_7472_(@Nonnull DamageSource source, int looting, boolean recentlyHit) {
    }

    public int m_213860_() {
        return 10;
    }

    @Nullable
    public ItemEntity m_5552_(@Nonnull ItemStack stack, float offsetY) {
        return null;
    }

    @Nullable
    public ItemEntity m_19983_(@Nonnull ItemStack stack) {
        return null;
    }
}

