/*
 * Decompiled with CFR 0.152.
 */
package net.click.projecttacznpcs.entity.ai;

import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class GunAttackGoal
extends Goal {
    private final Mob mob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private final int engageDelayTicks;
    private final double inaccuracyDeg;
    private static final int STRAFE_TICKS_MIN = 20;
    private static final int STRAFE_TICKS_MAX = 40;
    private int seeTime = 0;
    private int strafingTime = -1;
    private boolean strafingClockwise = false;
    private boolean strafingBackwards = false;
    private int targetChangeTick = 0;
    private int lastTargetId = -1;
    private static final int MIN_AIM_WARMUP_TICKS = 3;
    private static final float AIM_ANGLE_THRESHOLD_DEG = 12.0f;

    public GunAttackGoal(Mob mob, double speedModifier, float attackRadius) {
        this(mob, speedModifier, attackRadius, 3, 0.0);
    }

    public GunAttackGoal(Mob mob, double speedModifier, float attackRadius, int engageDelayTicks) {
        this(mob, speedModifier, attackRadius, engageDelayTicks, 0.0);
    }

    public GunAttackGoal(Mob mob, double speedModifier, float attackRadius, int engageDelayTicks, double inaccuracyDeg) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.engageDelayTicks = Math.max(0, engageDelayTicks);
        this.inaccuracyDeg = Math.max(0.0, inaccuracyDeg);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        return target != null && target.m_6084_();
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        return target != null && target.m_6084_();
    }

    public void m_8056_() {
        IGunOperator i;
        Mob mob = this.mob;
        IGunOperator op = mob instanceof IGunOperator ? (i = (IGunOperator)mob) : IGunOperator.fromLivingEntity((LivingEntity)this.mob);
        op.draw(() -> ((Mob)this.mob).m_21205_());
        try {
            op.getDataHolder().drawTimestamp = System.currentTimeMillis() - 10000L;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        double distSqr = this.mob.m_20280_((Entity)target);
        boolean hasLOS = this.mob.m_142582_((Entity)target);
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (target.m_19879_() != this.lastTargetId) {
            this.lastTargetId = target.m_19879_();
            this.targetChangeTick = this.mob.f_19797_;
        }
        if (hasLOS) {
            if (this.seeTime < 0) {
                this.seeTime = 0;
            }
            ++this.seeTime;
        } else {
            if (this.seeTime > 0) {
                this.seeTime = 0;
            }
            --this.seeTime;
        }
        if (distSqr > (double)this.attackRadiusSqr || this.seeTime < 5) {
            this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
            this.strafingTime = -1;
        } else {
            this.mob.m_21573_().m_26573_();
            ++this.strafingTime;
        }
        if (this.strafingTime >= 20) {
            Vec3 delta = new Vec3(this.mob.m_20185_() - target.m_20185_(), 0.0, this.mob.m_20189_() - target.m_20189_());
            double dist = Math.sqrt(Math.max(1.0E-4, delta.m_82556_()));
            if (dist < Math.sqrt(this.attackRadiusSqr) * 0.3) {
                this.strafingBackwards = true;
            } else if (dist > Math.sqrt(this.attackRadiusSqr) * 0.7) {
                this.strafingBackwards = false;
            }
            if (this.mob.m_217043_().m_188501_() < 0.3f) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if (this.mob.m_217043_().m_188501_() < 0.3f) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            float forward = this.strafingBackwards ? -0.5f : 0.5f;
            float lateral = this.strafingClockwise ? 0.5f : -0.5f;
            this.mob.m_21566_().m_24988_(forward, lateral);
        }
        IGunOperator op = IGunOperator.fromLivingEntity((LivingEntity)this.mob);
        if (hasLOS && this.seeTime >= 5) {
            float dPitch;
            float dYaw;
            Vec3 eye = this.mob.m_20299_(1.0f);
            Vec3 targetEye = target.m_20299_(1.0f);
            Vec3 delta = targetEye.m_82546_(eye);
            double horiz = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
            float desiredYaw = (float)(Mth.m_14136_((double)delta.f_82481_, (double)delta.f_82479_) * 57.29577951308232) - 90.0f;
            float desiredPitch = (float)(-(Mth.m_14136_((double)delta.f_82480_, (double)horiz) * 57.29577951308232));
            float yawErr = Mth.m_14177_((float)(desiredYaw - this.mob.m_6080_()));
            float pitchErr = desiredPitch - this.mob.m_146909_();
            boolean warmedUp = this.mob.f_19797_ - this.targetChangeTick >= this.engageDelayTicks;
            boolean facingOk = Math.abs(yawErr) <= 12.0f && Math.abs(pitchErr) <= 12.0f;
            float basePitch = this.mob.m_5686_(1.0f);
            float baseYaw = this.mob.m_5675_(1.0f);
            if (this.inaccuracyDeg > 0.0) {
                double gy = this.mob.m_217043_().m_188583_() * (this.inaccuracyDeg * 0.5);
                double gp = this.mob.m_217043_().m_188583_() * (this.inaccuracyDeg * 0.5);
                dYaw = (float)Mth.m_14008_((double)gy, (double)(-this.inaccuracyDeg), (double)this.inaccuracyDeg);
                dPitch = (float)Mth.m_14008_((double)gp, (double)(-this.inaccuracyDeg), (double)this.inaccuracyDeg);
            } else {
                dYaw = 0.0f;
                dPitch = 0.0f;
            }
            Supplier<Float> pitch = () -> Float.valueOf(basePitch + dPitch);
            Supplier<Float> yaw = () -> Float.valueOf(baseYaw + dYaw);
            op.aim(true);
            if (warmedUp && facingOk) {
                ShootResult result = op.shoot(pitch, yaw);
                if (result == ShootResult.NOT_DRAW) {
                    op.draw(() -> ((Mob)this.mob).m_21205_());
                } else if (result == ShootResult.NEED_BOLT) {
                    op.bolt();
                }
            }
        } else {
            op.aim(false);
        }
    }

    private int randomStrafeWindow() {
        int span = 21;
        return 20 + this.mob.m_217043_().m_188503_(span);
    }
}

