/*
 * Decompiled with CFR 0.152.
 */
package net.click.projecttacznpcs.entity.base;

import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.entity.shooter.LivingEntityAim;
import com.tacz.guns.entity.shooter.LivingEntityAmmoCheck;
import com.tacz.guns.entity.shooter.LivingEntityBolt;
import com.tacz.guns.entity.shooter.LivingEntityCrawl;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityFireSelect;
import com.tacz.guns.entity.shooter.LivingEntityMelee;
import com.tacz.guns.entity.shooter.LivingEntityReload;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.LivingEntitySpeedModifier;
import com.tacz.guns.entity.shooter.LivingEntitySprint;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.entity.sync.ModSyncedEntityData;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractGunNpcEntity
extends Monster
implements IGunOperator {
    private final LivingEntity tacz$shooter = this;
    private final ShooterDataHolder tacz$data = new ShooterDataHolder();
    private final LivingEntityDrawGun tacz$draw = new LivingEntityDrawGun(this.tacz$shooter, this.tacz$data);
    private final LivingEntityAim tacz$aim = new LivingEntityAim(this.tacz$shooter, this.tacz$data);
    private final LivingEntityCrawl tacz$crawl = new LivingEntityCrawl(this.tacz$shooter, this.tacz$data);
    private final LivingEntityAmmoCheck tacz$ammoCheck = new LivingEntityAmmoCheck(this.tacz$shooter);
    private final LivingEntityFireSelect tacz$fireSelect = new LivingEntityFireSelect(this.tacz$shooter, this.tacz$data);
    private final LivingEntityMelee tacz$melee = new LivingEntityMelee(this.tacz$shooter, this.tacz$data, this.tacz$draw);
    private final LivingEntityShoot tacz$shoot = new LivingEntityShoot(this.tacz$shooter, this.tacz$data, this.tacz$draw);
    private final LivingEntityBolt tacz$bolt = new LivingEntityBolt(this.tacz$data, this.tacz$shooter, this.tacz$draw, this.tacz$shoot);
    private final LivingEntityReload tacz$reload = new LivingEntityReload(this.tacz$shooter, this.tacz$data, this.tacz$draw, this.tacz$shoot);
    private final LivingEntitySpeedModifier tacz$speed = new LivingEntitySpeedModifier(this.tacz$shooter, this.tacz$data);
    private final LivingEntitySprint tacz$sprint = new LivingEntitySprint(this.tacz$shooter, this.tacz$data);

    protected AbstractGunNpcEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.initialData();
    }

    public void draw(Supplier<ItemStack> gunItemSupplier) {
        this.tacz$draw.draw(gunItemSupplier);
    }

    public void reload() {
        this.tacz$reload.reload();
    }

    public void aim(boolean isAim) {
        this.tacz$aim.aim(isAim);
    }

    public void crawl(boolean isCrawl) {
        this.tacz$crawl.crawl(isCrawl);
    }

    public void fireSelect() {
        this.tacz$fireSelect.fireSelect();
    }

    public void zoom() {
        this.tacz$aim.zoom();
    }

    public void bolt() {
        this.tacz$bolt.bolt();
    }

    public void cancelReload() {
        this.tacz$reload.cancelReload();
    }

    public ShootResult shoot(Supplier<Float> pitch, Supplier<Float> yaw) {
        return this.shoot(pitch, yaw, System.currentTimeMillis() - this.tacz$data.baseTimestamp);
    }

    public ShootResult shoot(Supplier<Float> pitch, Supplier<Float> yaw, long timestamp) {
        return this.tacz$shoot.shoot(pitch, yaw, timestamp);
    }

    public ShooterDataHolder getDataHolder() {
        return this.tacz$data;
    }

    public boolean needCheckAmmo() {
        return false;
    }

    public boolean consumesAmmoOrNot() {
        return this.tacz$ammoCheck.consumesAmmoOrNot();
    }

    public void updateCacheProperty(AttachmentCacheProperty cacheProperty) {
        this.tacz$data.cacheProperty = cacheProperty;
    }

    @Nullable
    public AttachmentCacheProperty getCacheProperty() {
        return this.tacz$data.cacheProperty;
    }

    public void melee() {
        this.tacz$melee.melee();
    }

    public boolean getProcessedSprintStatus(boolean sprint) {
        return this.tacz$sprint.getProcessedSprintStatus(sprint);
    }

    public boolean nextBulletIsTracer(int tracerCountInterval) {
        ++this.tacz$data.shootCount;
        return true;
    }

    public long getSynShootCoolDown() {
        return (Long)ModSyncedEntityData.SHOOT_COOL_DOWN_KEY.getValue((Entity)this.tacz$shooter);
    }

    public long getSynMeleeCoolDown() {
        return (Long)ModSyncedEntityData.MELEE_COOL_DOWN_KEY.getValue((Entity)this.tacz$shooter);
    }

    public long getSynDrawCoolDown() {
        return (Long)ModSyncedEntityData.DRAW_COOL_DOWN_KEY.getValue((Entity)this.tacz$shooter);
    }

    public boolean getSynIsBolting() {
        return (Boolean)ModSyncedEntityData.IS_BOLTING_KEY.getValue((Entity)this.tacz$shooter);
    }

    public ReloadState getSynReloadState() {
        return (ReloadState)ModSyncedEntityData.RELOAD_STATE_KEY.getValue((Entity)this.tacz$shooter);
    }

    public float getSynAimingProgress() {
        return ((Float)ModSyncedEntityData.AIMING_PROGRESS_KEY.getValue((Entity)this.tacz$shooter)).floatValue();
    }

    public float getSynSprintTime() {
        return ((Float)ModSyncedEntityData.SPRINT_TIME_KEY.getValue((Entity)this.tacz$shooter)).floatValue();
    }

    public boolean getSynIsAiming() {
        return (Boolean)ModSyncedEntityData.IS_AIMING_KEY.getValue((Entity)this.tacz$shooter);
    }

    public void initialData() {
        this.tacz$data.initialData();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            ReloadState reloadState = this.tacz$reload.tickReloadState();
            this.tacz$aim.tickAimingProgress();
            this.tacz$aim.tickSprint();
            this.tacz$crawl.tickCrawling();
            this.tacz$bolt.tickBolt();
            this.tacz$melee.scheduleTickMelee();
            this.tacz$speed.updateSpeedModifier();
            this.m_6858_(this.tacz$sprint.getProcessedSprintStatus(this.m_20142_()));
            ModSyncedEntityData.SHOOT_COOL_DOWN_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$shoot.getShootCoolDown());
            ModSyncedEntityData.MELEE_COOL_DOWN_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$melee.getMeleeCoolDown());
            ModSyncedEntityData.DRAW_COOL_DOWN_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$draw.getDrawCoolDown());
            ModSyncedEntityData.IS_BOLTING_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$data.isBolting);
            ModSyncedEntityData.RELOAD_STATE_KEY.setValue((Entity)this.tacz$shooter, (Object)reloadState);
            ModSyncedEntityData.AIMING_PROGRESS_KEY.setValue((Entity)this.tacz$shooter, (Object)Float.valueOf(this.tacz$data.aimingProgress));
            ModSyncedEntityData.IS_AIMING_KEY.setValue((Entity)this.tacz$shooter, (Object)this.tacz$data.isAiming);
            ModSyncedEntityData.SPRINT_TIME_KEY.setValue((Entity)this.tacz$shooter, (Object)Float.valueOf(this.tacz$data.sprintTimeS));
        }
    }
}

