/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.loot;

import baguchi.bagus_lib.register.ModLootModifiers;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class OneItemLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<OneItemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> OneItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(m -> m.lootTable)).apply((Applicative)inst, OneItemLootModifier::new)));
    public final ResourceLocation lootTable;

    public OneItemLootModifier(LootItemCondition[] conditionsIn, ResourceLocation lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList stacks = new ObjectArrayList();
        context.getResolver().lookupOrThrow(Registries.LOOT_TABLE).get(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable)).ifPresent(extraTable -> ((LootTable)extraTable.value()).getRandomItemsRaw(context, LootTable.createStackSplitter((ServerLevel)context.getLevel(), arg_0 -> ((ObjectArrayList)stacks).add(arg_0))));
        List<ItemStack> itemStacks = stacks.stream().filter(itemStack -> !itemStack.isEmpty()).toList();
        if (!itemStacks.isEmpty()) {
            return stacks;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)ModLootModifiers.ONE_IN_LOOT.get();
    }
}

