/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.attachment;

import baguchi.bagus_lib.util.data.BagusAnimationData;
import baguchi.tofucraft.entity.projectile.ZundaBuster;
import baguchi.tofucraft.registry.TofuAnimations;
import baguchi.tofucraft.registry.TofuAttachments;
import baguchi.tofucraft.utils.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;

public class TofuLivingAttachment
implements ValueIOSerializable {
    public boolean isInsidePortal = false;
    public int portalTimer = 0;
    public float portalAnimTime = 0.0f;
    public float prevPortalAnimTime = 0.0f;
    public float recoverHealth = 0.0f;
    public int eatCooldown;
    public boolean zundafied = false;
    private final BagusAnimationData thrownRightAnimationData = new BagusAnimationData(TofuAnimations.THROWN_RIGHT, 10);
    private final BagusAnimationData thrownLeftAnimationData = new BagusAnimationData(TofuAnimations.THROWN_LEFT, 10);
    private final BagusAnimationData busterRightAnimationData = new BagusAnimationData(TofuAnimations.BUSTER_RIGHT, 20);
    private final BagusAnimationData busterLeftAnimationData = new BagusAnimationData(TofuAnimations.BUSTER_LEFT, 20);

    public void tick(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handlePortal(player);
        }
        this.handleFood(entity);
        this.thrownRightAnimationData.tick(entity);
        this.thrownLeftAnimationData.tick(entity);
        this.busterRightAnimationData.tick(entity);
        this.busterLeftAnimationData.tick(entity);
        if (!entity.level().isClientSide()) {
            ZundaBuster zundaBuster;
            ItemStack stack;
            LivingEntity living;
            if (this.busterRightAnimationData.started && this.busterRightAnimationData.animationTick == 8 && entity instanceof LivingEntity) {
                living = (LivingEntity)entity;
                stack = living.getMainHandItem();
                zundaBuster = new ZundaBuster(living.level(), living, stack);
                zundaBuster.shootFromRotation((Entity)living, living.getXRot(), living.getYRot(), 0.0f, 3.0f, 1.0f);
                living.level().addFreshEntity((Entity)zundaBuster);
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.25f, 1.25f + entity.getRandom().nextFloat() * 0.4f);
            }
            if (this.busterLeftAnimationData.started && this.busterLeftAnimationData.animationTick == 8 && entity instanceof LivingEntity) {
                living = (LivingEntity)entity;
                stack = living.getOffhandItem();
                zundaBuster = new ZundaBuster(living.level(), living, stack);
                zundaBuster.shootFromRotation((Entity)living, living.getXRot(), living.getYRot(), 0.0f, 3.0f, 1.0f);
                living.level().addFreshEntity((Entity)zundaBuster);
                entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.25f, 1.25f + entity.getRandom().nextFloat() * 0.4f);
            }
        }
    }

    public void thrownAnimation(Entity entity, InteractionHand interactionHand) {
        this.thrownRightAnimationData.stop(entity);
        this.thrownLeftAnimationData.stop(entity);
        if (interactionHand == InteractionHand.MAIN_HAND) {
            this.thrownLeftAnimationData.start(entity);
        } else {
            this.thrownRightAnimationData.start(entity);
        }
    }

    public void busterAnimation(Entity entity, InteractionHand interactionHand) {
        this.busterRightAnimationData.stop(entity);
        this.busterLeftAnimationData.stop(entity);
        if (interactionHand == InteractionHand.MAIN_HAND) {
            this.busterRightAnimationData.start(entity);
        } else {
            this.busterLeftAnimationData.start(entity);
        }
    }

    private void handleFood(Entity entity) {
        if (this.eatCooldown > 0) {
            --this.eatCooldown;
        }
    }

    public boolean isEatCooldown() {
        return this.eatCooldown > 0;
    }

    public void setRecoverHealth(Entity entity, float recoverHealth) {
        this.recoverHealth = recoverHealth;
        if (!entity.level().isClientSide() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity.syncData(TofuAttachments.TOFU_LIVING);
        }
    }

    public float getRecoverHealth() {
        return this.recoverHealth;
    }

    public void setZundafied(Entity entity, boolean zundafied) {
        this.zundafied = zundafied;
        if (!entity.level().isClientSide() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity.syncData(TofuAttachments.TOFU_LIVING);
        }
    }

    public boolean isZundafied() {
        return this.zundafied;
    }

    public void setInPortal(boolean inPortal) {
        this.isInsidePortal = inPortal;
    }

    public boolean isInsidePortal() {
        return this.isInsidePortal;
    }

    public void setPortalTimer(int timer) {
        this.portalTimer = timer;
    }

    public int getPortalTimer() {
        return this.portalTimer;
    }

    public float getPortalAnimTime() {
        return this.portalAnimTime;
    }

    public float getPrevPortalAnimTime() {
        return this.prevPortalAnimTime;
    }

    public void handlePortal(Player player) {
        if (player.level().isClientSide()) {
            this.prevPortalAnimTime = this.portalAnimTime;
            if (this.isInsidePortal()) {
                if (!(Minecraft.getInstance().screen == null || Minecraft.getInstance().screen.isPauseScreen() || Minecraft.getInstance().screen instanceof DeathScreen || Minecraft.getInstance().screen instanceof WinScreen)) {
                    if (Minecraft.getInstance().screen instanceof AbstractContainerScreen) {
                        player.closeContainer();
                    }
                    Minecraft.getInstance().setScreen(null);
                }
                if (this.portalAnimTime == 0.0f) {
                    ClientUtils.playPortalSound(player);
                }
            }
        }
        if (this.isInsidePortal()) {
            ++this.portalTimer;
            if (player.level().isClientSide()) {
                this.portalAnimTime += 0.0125f;
                if (this.getPortalAnimTime() > 1.0f) {
                    this.portalAnimTime = 1.0f;
                }
            }
            this.isInsidePortal = false;
        } else {
            if (player.level().isClientSide()) {
                if (this.getPortalAnimTime() > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.getPortalAnimTime() < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
            if (this.getPortalTimer() > 0) {
                this.portalTimer -= 4;
            }
        }
    }

    public void setEatCooldown(int eatCooldown) {
        this.eatCooldown = eatCooldown;
    }

    public void serialize(ValueOutput valueOutput) {
        valueOutput.putFloat("recover_health", this.recoverHealth);
        valueOutput.putBoolean("zundafied", this.zundafied);
        if (this.eatCooldown > 0) {
            valueOutput.putInt("eat_cooldown", this.eatCooldown);
        }
    }

    public void deserialize(ValueInput nbt) {
        this.recoverHealth = nbt.getFloatOr("recover_health", 0.0f);
        this.zundafied = nbt.getBooleanOr("zundafied", false);
        this.eatCooldown = nbt.getIntOr("eat_cooldown", 0);
    }
}

