/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.attachment;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.api.TofuLearning;
import baguchi.tofucraft.network.AddLearningPacket;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.network.PacketDistributor;

public class TofuPlayerAttachment
implements ValueIOSerializable {
    private final List<Holder<TofuLearning>> learning = Lists.newArrayList();
    private boolean sync;

    public void addLearning(Holder<TofuLearning> learning, Player player) {
        this.learning.add(learning);
        if (!player.level().isClientSide()) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new AddLearningPacket((Entity)player, ((ResourceKey)learning.unwrap().left().get()).location(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void trackDiscoveries(Player player, AdvancementHolder advancement) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RegistryAccess registryAccess = serverPlayer.registryAccess();
            this.trackLearningEntries(serverPlayer, registryAccess, advancement);
            if (this.sync) {
                this.sync = false;
            }
        }
    }

    private void trackLearningEntries(ServerPlayer serverPlayer, RegistryAccess registryAccess, AdvancementHolder advancement) {
        Registry learnings = registryAccess.lookupOrThrow(TofuLearning.REGISTRY_KEY);
        for (Holder.Reference entry : learnings.listElements().toList()) {
            if (!((TofuLearning)entry.value()).learning_advancement().isPresent() || !advancement.id().equals((Object)((TofuLearning)entry.value()).learning_advancement().get()) || this.learning.contains(entry)) continue;
            this.addLearning((Holder<TofuLearning>)entry, (Player)serverPlayer);
            this.sync = true;
        }
    }

    public List<Holder<TofuLearning>> getLearning() {
        return this.learning;
    }

    public void serialize(ValueOutput output) {
        ListTag listnbt = new ListTag();
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.learning.size(); ++i) {
            CompoundTag compoundTag = new CompoundTag();
            ResourceLocation resourceLocation = TofuCraftReload.registryAccess().lookupOrThrow(TofuLearning.REGISTRY_KEY).getKey((Object)((TofuLearning)this.learning.get(i).value()));
            if (resourceLocation != null) {
                compoundTag.putString("Learn", resourceLocation.toString());
            }
            listnbt.add((Object)compoundTag);
        }
        tag.put("LearnData", (Tag)listnbt);
        output.store("Learned", CompoundTag.CODEC, (Object)tag);
    }

    public void deserialize(ValueInput nbt) {
        CompoundTag compoundTag = nbt.read("Learned", CompoundTag.CODEC).orElse(null);
        ListTag list = compoundTag.getListOrEmpty("LearnData");
        this.learning.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compoundnbt = list.getCompoundOrEmpty(i);
            if (!compoundnbt.contains("Learn")) continue;
            Optional learn = TofuCraftReload.registryAccess().lookupOrThrow(TofuLearning.REGISTRY_KEY).get(ResourceLocation.parse((String)compoundnbt.getStringOr("Learn", "")));
            learn.ifPresent(this.learning::add);
        }
    }
}

